/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.spec.mapping.impl;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import it.unibz.inf.ontop.dbschema.DBMetadata;
import it.unibz.inf.ontop.dbschema.QualifiedAttributeID;
import it.unibz.inf.ontop.dbschema.QuotedID;
import it.unibz.inf.ontop.dbschema.QuotedIDFactory;
import it.unibz.inf.ontop.exception.MetaMappingExpansionException;
import it.unibz.inf.ontop.exception.MinorOntopInternalBugException;
import it.unibz.inf.ontop.model.atom.TargetAtom;
import it.unibz.inf.ontop.model.term.DBConstant;
import it.unibz.inf.ontop.model.term.IRIConstant;
import it.unibz.inf.ontop.model.term.ImmutableFunctionalTerm;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.model.term.functionsymbol.FunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.RDFTermFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.DBTypeConversionFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.ObjectStringTemplateFunctionSymbol;
import it.unibz.inf.ontop.model.type.RDFTermType;
import it.unibz.inf.ontop.model.type.TypeFactory;
import it.unibz.inf.ontop.spec.mapping.OBDASQLQuery;
import it.unibz.inf.ontop.spec.mapping.SQLMappingFactory;
import it.unibz.inf.ontop.spec.mapping.impl.SQLMappingFactoryImpl;
import it.unibz.inf.ontop.spec.mapping.parser.exception.InvalidSelectQueryException;
import it.unibz.inf.ontop.spec.mapping.parser.exception.UnsupportedSelectQueryException;
import it.unibz.inf.ontop.spec.mapping.parser.impl.SelectQueryAttributeExtractor2;
import it.unibz.inf.ontop.spec.mapping.pp.SQLPPTriplesMap;
import it.unibz.inf.ontop.spec.mapping.pp.impl.OntopNativeSQLPPTriplesMap;
import it.unibz.inf.ontop.substitution.ImmutableSubstitution;
import it.unibz.inf.ontop.substitution.SubstitutionFactory;
import it.unibz.inf.ontop.utils.IDGenerator;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import it.unibz.inf.ontop.utils.Templates;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.sf.jsqlparser.JSQLParserException;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.StringValue;
import net.sf.jsqlparser.expression.operators.conditional.AndExpression;
import net.sf.jsqlparser.expression.operators.relational.EqualsTo;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.select.AllColumns;
import net.sf.jsqlparser.statement.select.AllTableColumns;
import net.sf.jsqlparser.statement.select.Distinct;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.select.SelectExpressionItem;
import net.sf.jsqlparser.statement.select.SelectItem;
import net.sf.jsqlparser.statement.select.SelectItemVisitor;
import org.apache.commons.rdf.api.RDF;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetaMappingExpander {
    private static final Logger log = LoggerFactory.getLogger(MetaMappingExpander.class);
    private static final SQLMappingFactory MAPPING_FACTORY = SQLMappingFactoryImpl.getInstance();
    private final TermFactory termFactory;
    private final ImmutableList<SQLPPTriplesMap> nonExpandableMappings;
    private final ImmutableList<Expansion> mappingsToBeExpanded;
    private final SubstitutionFactory substitutionFactory;
    private final RDF rdfFactory;
    private final TypeFactory typeFactory;

    public MetaMappingExpander(Collection<SQLPPTriplesMap> mappings, TermFactory termFactory, SubstitutionFactory substitutionFactory, TypeFactory typeFactory, RDF rdfFactory) {
        this.termFactory = termFactory;
        this.substitutionFactory = substitutionFactory;
        this.typeFactory = typeFactory;
        this.rdfFactory = rdfFactory;
        ImmutableList.Builder builder1 = ImmutableList.builder();
        ImmutableList.Builder builder2 = ImmutableList.builder();
        for (SQLPPTriplesMap mapping : mappings) {
            ImmutableList toBeExpanded = (ImmutableList)mapping.getTargetAtoms().stream().filter(targetAtom -> {
                ImmutableTerm propertyTerm = targetAtom.getSubstitutedTerm(1);
                if (MetaMappingExpander.isURIRDFType(propertyTerm, termFactory, typeFactory)) {
                    return !targetAtom.getSubstitutedTerm(2).isGround();
                }
                return !propertyTerm.isGround();
            }).collect(ImmutableCollectors.toList());
            if (toBeExpanded.isEmpty()) {
                builder1.add((Object)mapping);
                continue;
            }
            builder2.addAll(toBeExpanded.stream().map(target -> new Expansion(mapping.getId(), mapping.getSourceQuery(), (TargetAtom)target)).iterator());
        }
        this.nonExpandableMappings = builder1.build();
        this.mappingsToBeExpanded = builder2.build();
    }

    public boolean hasMappingsToBeExpanded() {
        return !this.mappingsToBeExpanded.isEmpty();
    }

    public ImmutableList<SQLPPTriplesMap> getNonExpandableMappings() {
        return this.nonExpandableMappings;
    }

    public ImmutableList<SQLPPTriplesMap> getExpandedMappings(Connection connection, DBMetadata metadata) throws MetaMappingExpansionException {
        LinkedList<String> errorMessages = new LinkedList<String>();
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.addAll(this.nonExpandableMappings);
        for (Expansion m : this.mappingsToBeExpanded) {
            try {
                List templateColumns;
                boolean isClass = MetaMappingExpander.isURIRDFType(m.target.getSubstitutedTerm(1), this.termFactory, this.typeFactory);
                ImmutableFunctionalTerm templateAtom = (ImmutableFunctionalTerm)m.target.getSubstitutedTerm(isClass ? 2 : 1);
                ImmutableList<Variable> templateVariables = this.extractTemplateVariables(templateAtom);
                ImmutableList<QuotedID> templateColumnIds = MetaMappingExpander.getTemplateColumnNames(metadata.getQuotedIDFactory(), templateVariables);
                ImmutableMap<QuotedID, SelectExpressionItem> queryColumns = this.getQueryColumns(metadata, m.source.getSQLQuery());
                try {
                    templateColumns = (List)templateColumnIds.stream().map(id -> (SelectExpressionItem)queryColumns.get(id)).collect(ImmutableCollectors.toList());
                }
                catch (NullPointerException e) {
                    throw new IllegalArgumentException(templateColumnIds.stream().filter(id -> !queryColumns.containsKey(id)).map(Object::toString).collect(Collectors.joining(", ", "The placeholder(s) ", " in the target do(es) not occur in the body of the mapping")));
                }
                String query = MetaMappingExpander.getTemplateValuesQuery(m.source.getSQLQuery(), templateColumns);
                int size = templateColumns.size();
                Statement st = connection.createStatement();
                Throwable throwable = null;
                try {
                    ResultSet rs = st.executeQuery(query);
                    Throwable throwable2 = null;
                    try {
                        while (rs.next()) {
                            ArrayList values = Lists.newArrayListWithCapacity((int)size);
                            for (int i = 1; i <= size; ++i) {
                                values.add(rs.getString(i));
                            }
                            if (values.contains(null)) continue;
                            String newSourceQuery = MetaMappingExpander.getInstantiatedSQL(m.source.getSQLQuery(), templateColumns, values);
                            IRIConstant predicateTerm = this.termFactory.getConstantIRI(this.rdfFactory.createIRI(MetaMappingExpander.getPredicateName(templateAtom.getTerm(0), values)));
                            Variable predicateVariable = (Variable)m.target.getProjectionAtom().getArguments().get(isClass ? 2 : 1);
                            ImmutableSubstitution newSubstitution = m.target.getSubstitution().composeWith(this.substitutionFactory.getSubstitution(predicateVariable, (ImmutableTerm)predicateTerm));
                            TargetAtom newTarget = m.target.changeSubstitution(newSubstitution);
                            OntopNativeSQLPPTriplesMap newMapping = new OntopNativeSQLPPTriplesMap(IDGenerator.getNextUniqueID((String)(m.id + "#")), MAPPING_FACTORY.getSQLQuery(newSourceQuery), (ImmutableList<TargetAtom>)ImmutableList.of((Object)newTarget));
                            builder.add((Object)newMapping);
                            log.debug("Expanded Mapping: {}", (Object)newMapping);
                        }
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (rs == null) continue;
                        if (throwable2 != null) {
                            try {
                                rs.close();
                            }
                            catch (Throwable throwable4) {
                                throwable2.addSuppressed(throwable4);
                            }
                            continue;
                        }
                        rs.close();
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
                finally {
                    if (st == null) continue;
                    if (throwable != null) {
                        try {
                            st.close();
                        }
                        catch (Throwable throwable6) {
                            throwable.addSuppressed(throwable6);
                        }
                        continue;
                    }
                    st.close();
                }
            }
            catch (Exception e) {
                log.warn("Expanding meta-mappings exception: " + e.getMessage());
                errorMessages.add(e.getMessage());
            }
        }
        if (!errorMessages.isEmpty()) {
            throw new MetaMappingExpansionException(Joiner.on((String)"\n").join(errorMessages));
        }
        return builder.build();
    }

    private ImmutableList<Variable> extractTemplateVariables(ImmutableFunctionalTerm templateAtom) {
        return Optional.of(templateAtom).filter(a -> a.getFunctionSymbol() instanceof RDFTermFunctionSymbol).map(a -> a.getTerm(0)).map(l -> l instanceof ImmutableFunctionalTerm && ((ImmutableFunctionalTerm)l).getFunctionSymbol() instanceof ObjectStringTemplateFunctionSymbol ? ((ImmutableFunctionalTerm)l).getTerms().stream() : Stream.of(l)).map(s -> (ImmutableList)s.map(t -> t instanceof ImmutableFunctionalTerm && ((ImmutableFunctionalTerm)t).getFunctionSymbol() instanceof DBTypeConversionFunctionSymbol ? ((ImmutableFunctionalTerm)t).getTerm(0) : t).filter(t -> t instanceof Variable).map(t -> (Variable)t).collect(ImmutableCollectors.toList())).orElseThrow(() -> new MinorOntopInternalBugException(String.format("Unexpected template atom %s: was expected to a RDF functional term", templateAtom)));
    }

    private ImmutableMap<QuotedID, SelectExpressionItem> getQueryColumns(DBMetadata metadata, String sql) throws InvalidSelectQueryException, UnsupportedSelectQueryException {
        final SelectQueryAttributeExtractor2 sqae = new SelectQueryAttributeExtractor2(metadata, this.termFactory);
        PlainSelect plainSelect = sqae.getParsedSql(sql);
        final ImmutableMap<QualifiedAttributeID, ImmutableTerm> attributes = sqae.getQueryBodyAttributes(plainSelect);
        final ImmutableMap.Builder builder = ImmutableMap.builder();
        for (SelectItem si : plainSelect.getSelectItems()) {
            si.accept(new SelectItemVisitor(){

                public void visit(AllColumns allColumns) {
                    builder.putAll((Map)sqae.expandStar((ImmutableMap<QualifiedAttributeID, ImmutableTerm>)attributes).keySet().stream().collect(ImmutableCollectors.toMap(id -> id.getAttribute(), id -> new SelectExpressionItem((Expression)new Column(id.getAttribute().getSQLRendering())))));
                }

                public void visit(AllTableColumns allTableColumns) {
                    Table table = allTableColumns.getTable();
                    builder.putAll((Map)sqae.expandStar((ImmutableMap<QualifiedAttributeID, ImmutableTerm>)attributes, table).keySet().stream().collect(ImmutableCollectors.toMap(id -> id.getAttribute(), id -> new SelectExpressionItem((Expression)new Column(table, id.getAttribute().getSQLRendering())))));
                }

                public void visit(SelectExpressionItem selectExpressionItem) {
                    builder.put((Object)sqae.getSelectItemAliasedId(selectExpressionItem), (Object)selectExpressionItem);
                }
            });
        }
        return builder.build();
    }

    private static String getTemplateValuesQuery(String sql, List<SelectExpressionItem> templateColumns) throws JSQLParserException {
        Select select = (Select)CCJSqlParserUtil.parse((String)sql);
        PlainSelect plainSelect = (PlainSelect)select.getSelectBody();
        plainSelect.setDistinct(new Distinct());
        plainSelect.setSelectItems((List)ImmutableList.copyOf(templateColumns));
        return select.toString();
    }

    private static String getInstantiatedSQL(String sql, List<SelectExpressionItem> templateColumns, List<String> values) throws JSQLParserException {
        Select select = (Select)CCJSqlParserUtil.parse((String)sql);
        PlainSelect plainSelect = (PlainSelect)select.getSelectBody();
        Expression where = plainSelect.getWhere();
        int size = templateColumns.size();
        for (int i = 0; i < size; ++i) {
            EqualsTo condition = new EqualsTo();
            condition.setLeftExpression(templateColumns.get(i).getExpression());
            condition.setRightExpression((Expression)new StringValue("'" + values.get(i) + "'"));
            where = where == null ? condition : new AndExpression(where, (Expression)condition);
        }
        plainSelect.setWhere(where);
        return select.toString();
    }

    private static boolean isURIRDFType(ImmutableTerm term, TermFactory termFactory, TypeFactory typeFactory) {
        if (term instanceof ImmutableFunctionalTerm) {
            ImmutableFunctionalTerm func = (ImmutableFunctionalTerm)term;
            if (func.getFunctionSymbol() instanceof RDFTermFunctionSymbol) {
                ImmutableTerm lexicalTerm = func.getTerm(0);
                ImmutableTerm typeTerm = func.getTerm(1);
                if (typeTerm.equals(termFactory.getRDFTermTypeConstant((RDFTermType)typeFactory.getIRITermType())) && lexicalTerm instanceof DBConstant) {
                    return ((DBConstant)lexicalTerm).getValue().equals(it.unibz.inf.ontop.model.vocabulary.RDF.TYPE.getIRIString());
                }
            }
        } else if (term instanceof IRIConstant) {
            return ((IRIConstant)term).getIRI().equals((Object)it.unibz.inf.ontop.model.vocabulary.RDF.TYPE);
        }
        return false;
    }

    private static ImmutableList<QuotedID> getTemplateColumnNames(QuotedIDFactory idfac, ImmutableList<Variable> templateVariables) {
        return (ImmutableList)templateVariables.stream().map(v -> QuotedID.createIdFromDatabaseRecord((QuotedIDFactory)idfac, (String)v.getName())).collect(ImmutableCollectors.toList());
    }

    private static String getPredicateName(ImmutableTerm lexicalTerm, List<String> values) {
        if (lexicalTerm instanceof Variable) {
            return values.get(0);
        }
        if (lexicalTerm instanceof ImmutableFunctionalTerm) {
            ImmutableFunctionalTerm functionalLexicalTerm = (ImmutableFunctionalTerm)lexicalTerm;
            FunctionSymbol functionSymbol = functionalLexicalTerm.getFunctionSymbol();
            if (functionSymbol instanceof ObjectStringTemplateFunctionSymbol) {
                String iriTemplate = ((ObjectStringTemplateFunctionSymbol)functionalLexicalTerm.getFunctionSymbol()).getTemplate();
                return Templates.format((String)iriTemplate, values);
            }
            if (functionSymbol instanceof DBTypeConversionFunctionSymbol && ((DBTypeConversionFunctionSymbol)functionSymbol).isTemporary()) {
                return MetaMappingExpander.getPredicateName(functionalLexicalTerm.getTerm(0), values);
            }
        }
        throw new MinorOntopInternalBugException("Unexpected lexical template term: " + lexicalTerm);
    }

    private static final class Expansion {
        private final String id;
        private final OBDASQLQuery source;
        private final TargetAtom target;

        Expansion(String id, OBDASQLQuery source, TargetAtom target) {
            this.id = id;
            this.source = source;
            this.target = target;
        }
    }
}

