/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.spec.dbschema.impl;

import it.unibz.inf.ontop.dbschema.QuotedIDFactory;
import it.unibz.inf.ontop.dbschema.RelationID;
import it.unibz.inf.ontop.spec.mapping.OBDASQLQuery;
import it.unibz.inf.ontop.spec.mapping.pp.SQLPPTriplesMap;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import net.sf.jsqlparser.JSQLParserException;
import net.sf.jsqlparser.expression.AllComparisonExpression;
import net.sf.jsqlparser.expression.AnalyticExpression;
import net.sf.jsqlparser.expression.AnyComparisonExpression;
import net.sf.jsqlparser.expression.BinaryExpression;
import net.sf.jsqlparser.expression.CaseExpression;
import net.sf.jsqlparser.expression.CastExpression;
import net.sf.jsqlparser.expression.DateTimeLiteralExpression;
import net.sf.jsqlparser.expression.DateValue;
import net.sf.jsqlparser.expression.DoubleValue;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.ExpressionVisitor;
import net.sf.jsqlparser.expression.ExtractExpression;
import net.sf.jsqlparser.expression.Function;
import net.sf.jsqlparser.expression.HexValue;
import net.sf.jsqlparser.expression.IntervalExpression;
import net.sf.jsqlparser.expression.JdbcNamedParameter;
import net.sf.jsqlparser.expression.JdbcParameter;
import net.sf.jsqlparser.expression.JsonExpression;
import net.sf.jsqlparser.expression.KeepExpression;
import net.sf.jsqlparser.expression.LongValue;
import net.sf.jsqlparser.expression.MySQLGroupConcat;
import net.sf.jsqlparser.expression.NotExpression;
import net.sf.jsqlparser.expression.NullValue;
import net.sf.jsqlparser.expression.NumericBind;
import net.sf.jsqlparser.expression.OracleHierarchicalExpression;
import net.sf.jsqlparser.expression.OracleHint;
import net.sf.jsqlparser.expression.Parenthesis;
import net.sf.jsqlparser.expression.RowConstructor;
import net.sf.jsqlparser.expression.SignedExpression;
import net.sf.jsqlparser.expression.StringValue;
import net.sf.jsqlparser.expression.TimeKeyExpression;
import net.sf.jsqlparser.expression.TimeValue;
import net.sf.jsqlparser.expression.TimestampValue;
import net.sf.jsqlparser.expression.UserVariable;
import net.sf.jsqlparser.expression.WhenClause;
import net.sf.jsqlparser.expression.WithinGroupExpression;
import net.sf.jsqlparser.expression.operators.arithmetic.Addition;
import net.sf.jsqlparser.expression.operators.arithmetic.BitwiseAnd;
import net.sf.jsqlparser.expression.operators.arithmetic.BitwiseOr;
import net.sf.jsqlparser.expression.operators.arithmetic.BitwiseXor;
import net.sf.jsqlparser.expression.operators.arithmetic.Concat;
import net.sf.jsqlparser.expression.operators.arithmetic.Division;
import net.sf.jsqlparser.expression.operators.arithmetic.Modulo;
import net.sf.jsqlparser.expression.operators.arithmetic.Multiplication;
import net.sf.jsqlparser.expression.operators.arithmetic.Subtraction;
import net.sf.jsqlparser.expression.operators.conditional.AndExpression;
import net.sf.jsqlparser.expression.operators.conditional.OrExpression;
import net.sf.jsqlparser.expression.operators.relational.Between;
import net.sf.jsqlparser.expression.operators.relational.EqualsTo;
import net.sf.jsqlparser.expression.operators.relational.ExistsExpression;
import net.sf.jsqlparser.expression.operators.relational.ExpressionList;
import net.sf.jsqlparser.expression.operators.relational.GreaterThan;
import net.sf.jsqlparser.expression.operators.relational.GreaterThanEquals;
import net.sf.jsqlparser.expression.operators.relational.InExpression;
import net.sf.jsqlparser.expression.operators.relational.IsNullExpression;
import net.sf.jsqlparser.expression.operators.relational.ItemsList;
import net.sf.jsqlparser.expression.operators.relational.ItemsListVisitor;
import net.sf.jsqlparser.expression.operators.relational.JsonOperator;
import net.sf.jsqlparser.expression.operators.relational.LikeExpression;
import net.sf.jsqlparser.expression.operators.relational.Matches;
import net.sf.jsqlparser.expression.operators.relational.MinorThan;
import net.sf.jsqlparser.expression.operators.relational.MinorThanEquals;
import net.sf.jsqlparser.expression.operators.relational.MultiExpressionList;
import net.sf.jsqlparser.expression.operators.relational.NotEqualsTo;
import net.sf.jsqlparser.expression.operators.relational.RegExpMatchOperator;
import net.sf.jsqlparser.expression.operators.relational.RegExpMySQLOperator;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.select.AllColumns;
import net.sf.jsqlparser.statement.select.AllTableColumns;
import net.sf.jsqlparser.statement.select.FromItemVisitor;
import net.sf.jsqlparser.statement.select.Join;
import net.sf.jsqlparser.statement.select.LateralSubSelect;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.select.SelectBody;
import net.sf.jsqlparser.statement.select.SelectExpressionItem;
import net.sf.jsqlparser.statement.select.SelectItem;
import net.sf.jsqlparser.statement.select.SelectItemVisitor;
import net.sf.jsqlparser.statement.select.SelectVisitor;
import net.sf.jsqlparser.statement.select.SetOperationList;
import net.sf.jsqlparser.statement.select.SubJoin;
import net.sf.jsqlparser.statement.select.SubSelect;
import net.sf.jsqlparser.statement.select.TableFunction;
import net.sf.jsqlparser.statement.select.ValuesList;
import net.sf.jsqlparser.statement.select.WithItem;

public class SQLTableNameExtractor {
    public static Set<RelationID> getRealTables(QuotedIDFactory idfac, Collection<SQLPPTriplesMap> mappings) {
        LinkedList<String> errorMessage = new LinkedList<String>();
        HashSet<RelationID> tables = new HashSet<RelationID>();
        for (SQLPPTriplesMap sQLPPTriplesMap : mappings) {
            try {
                if (!(sQLPPTriplesMap.getSourceQuery() instanceof OBDASQLQuery)) {
                    throw new IllegalArgumentException("getRealTables() only works for SQL-* mappings");
                }
                OBDASQLQuery sourceQuery = sQLPPTriplesMap.getSourceQuery();
                Statement statement = CCJSqlParserUtil.parse((String)sourceQuery.toString());
                if (!(statement instanceof Select)) {
                    throw new JSQLParserException("The query is not a SELECT statement");
                }
                Select selectQuery = (Select)statement;
                TableNameVisitor visitor = new TableNameVisitor(selectQuery, idfac);
                List<RelationID> queryTables = visitor.getRelations();
                for (RelationID table : queryTables) {
                    tables.add(table);
                }
            }
            catch (Exception e) {
                errorMessage.add("Error in mapping with id: " + sQLPPTriplesMap.getId() + " \n Description: " + (e.getMessage() != null ? e.getMessage() : e.getCause()) + " \nMapping: [" + sQLPPTriplesMap.toString() + "]");
            }
        }
        if (errorMessage.size() > 0) {
            StringBuilder errors = new StringBuilder();
            for (String error : errorMessage) {
                errors.append(error + "\n");
            }
            String string = "There was an error parsing the following mappings. Please correct the issue(s) to continue.\n" + errors.toString();
            throw new RuntimeException(string);
        }
        return tables;
    }

    private static class TableNameVisitor {
        private final QuotedIDFactory idfac;
        private final List<RelationID> relations = new LinkedList<RelationID>();
        private final Set<String> withTCEs = new HashSet<String>();
        private final SelectVisitor selectVisitor = new SelectVisitor(){

            public void visit(PlainSelect plainSelect) {
                plainSelect.getFromItem().accept(fromItemVisitor);
                if (plainSelect.getJoins() != null) {
                    for (Join join : plainSelect.getJoins()) {
                        join.getRightItem().accept(fromItemVisitor);
                    }
                }
                if (plainSelect.getWhere() != null) {
                    plainSelect.getWhere().accept(expressionVisitor);
                }
                for (SelectItem expr : plainSelect.getSelectItems()) {
                    expr.accept(selectItemVisitor);
                }
            }

            public void visit(SetOperationList list) {
                for (SelectBody plainSelect : list.getSelects()) {
                    plainSelect.accept((SelectVisitor)this);
                }
            }

            public void visit(WithItem withItem) {
                withTCEs.add(withItem.getName().toLowerCase());
                withItem.getSelectBody().accept((SelectVisitor)this);
            }
        };
        private final FromItemVisitor fromItemVisitor = new FromItemVisitor(){

            public void visit(Table table) {
                if (!withTCEs.contains(table.getFullyQualifiedName().toLowerCase())) {
                    RelationID relationId = idfac.createRelationID(table.getSchemaName(), table.getName());
                    relations.add(relationId);
                }
            }

            public void visit(SubSelect subSelect) {
                subSelect.getSelectBody().accept(selectVisitor);
            }

            public void visit(SubJoin subjoin) {
                subjoin.getLeft().accept((FromItemVisitor)this);
                subjoin.getJoin().getRightItem().accept((FromItemVisitor)this);
            }

            public void visit(LateralSubSelect lateralSubSelect) {
                lateralSubSelect.getSubSelect().getSelectBody().accept(selectVisitor);
            }

            public void visit(ValuesList valuesList) {
            }

            public void visit(TableFunction tableFunction) {
            }
        };
        private final SelectItemVisitor selectItemVisitor = new SelectItemVisitor(){

            public void visit(AllColumns expr) {
            }

            public void visit(AllTableColumns arg0) {
            }

            public void visit(SelectExpressionItem expr) {
                expr.getExpression().accept(expressionVisitor);
            }
        };
        private final ExpressionVisitor expressionVisitor = new ExpressionVisitor(){

            public void visit(Addition addition) {
                this.visitBinaryExpression((BinaryExpression)addition);
            }

            public void visit(AndExpression andExpression) {
                this.visitBinaryExpression((BinaryExpression)andExpression);
            }

            public void visit(Between between) {
                between.getLeftExpression().accept((ExpressionVisitor)this);
                between.getBetweenExpressionStart().accept((ExpressionVisitor)this);
                between.getBetweenExpressionEnd().accept((ExpressionVisitor)this);
            }

            public void visit(Column tableColumn) {
            }

            public void visit(Division division) {
                this.visitBinaryExpression((BinaryExpression)division);
            }

            public void visit(DoubleValue doubleValue) {
            }

            public void visit(EqualsTo equalsTo) {
                this.visitBinaryExpression((BinaryExpression)equalsTo);
            }

            public void visit(Function function) {
                if (function.getParameters() != null) {
                    for (Expression ex : function.getParameters().getExpressions()) {
                        ex.accept((ExpressionVisitor)this);
                    }
                }
            }

            public void visit(GreaterThan greaterThan) {
                this.visitBinaryExpression((BinaryExpression)greaterThan);
            }

            public void visit(GreaterThanEquals greaterThanEquals) {
                this.visitBinaryExpression((BinaryExpression)greaterThanEquals);
            }

            public void visit(InExpression inExpression) {
                if (inExpression.getLeftItemsList() != null) {
                    ItemsList leftItemsList = inExpression.getLeftItemsList();
                    leftItemsList.accept(itemsListVisitor);
                } else {
                    inExpression.getLeftExpression().accept((ExpressionVisitor)this);
                }
                inExpression.getRightItemsList().accept(itemsListVisitor);
            }

            public void visit(IsNullExpression isNullExpression) {
            }

            public void visit(JdbcParameter jdbcParameter) {
            }

            public void visit(LikeExpression likeExpression) {
                this.visitBinaryExpression((BinaryExpression)likeExpression);
            }

            public void visit(ExistsExpression existsExpression) {
                existsExpression.getRightExpression().accept((ExpressionVisitor)this);
            }

            public void visit(LongValue longValue) {
            }

            public void visit(HexValue hexValue) {
            }

            public void visit(MinorThan minorThan) {
                this.visitBinaryExpression((BinaryExpression)minorThan);
            }

            public void visit(MinorThanEquals minorThanEquals) {
                this.visitBinaryExpression((BinaryExpression)minorThanEquals);
            }

            public void visit(Multiplication multiplication) {
                this.visitBinaryExpression((BinaryExpression)multiplication);
            }

            public void visit(NotEqualsTo notEqualsTo) {
                this.visitBinaryExpression((BinaryExpression)notEqualsTo);
            }

            public void visit(NullValue nullValue) {
            }

            public void visit(OrExpression orExpression) {
                this.visitBinaryExpression((BinaryExpression)orExpression);
            }

            public void visit(Parenthesis parenthesis) {
                parenthesis.getExpression().accept((ExpressionVisitor)this);
            }

            public void visit(StringValue stringValue) {
            }

            public void visit(Subtraction subtraction) {
                this.visitBinaryExpression((BinaryExpression)subtraction);
            }

            private void visitBinaryExpression(BinaryExpression binaryExpression) {
                binaryExpression.getLeftExpression().accept((ExpressionVisitor)this);
                binaryExpression.getRightExpression().accept((ExpressionVisitor)this);
            }

            public void visit(DateValue dateValue) {
            }

            public void visit(TimestampValue timestampValue) {
            }

            public void visit(TimeValue timeValue) {
            }

            public void visit(CaseExpression caseExpression) {
            }

            public void visit(WhenClause whenClause) {
            }

            public void visit(AllComparisonExpression allComparisonExpression) {
                allComparisonExpression.getSubSelect().getSelectBody().accept(selectVisitor);
            }

            public void visit(AnyComparisonExpression anyComparisonExpression) {
                anyComparisonExpression.getSubSelect().getSelectBody().accept(selectVisitor);
            }

            public void visit(Concat concat) {
                this.visitBinaryExpression((BinaryExpression)concat);
            }

            public void visit(Matches matches) {
                this.visitBinaryExpression((BinaryExpression)matches);
            }

            public void visit(BitwiseAnd bitwiseAnd) {
                this.visitBinaryExpression((BinaryExpression)bitwiseAnd);
            }

            public void visit(BitwiseOr bitwiseOr) {
                this.visitBinaryExpression((BinaryExpression)bitwiseOr);
            }

            public void visit(BitwiseXor bitwiseXor) {
                this.visitBinaryExpression((BinaryExpression)bitwiseXor);
            }

            public void visit(CastExpression cast) {
                cast.getLeftExpression().accept((ExpressionVisitor)this);
            }

            public void visit(Modulo modulo) {
                this.visitBinaryExpression((BinaryExpression)modulo);
            }

            public void visit(AnalyticExpression analytic) {
            }

            public void visit(WithinGroupExpression withinGroupExpression) {
            }

            public void visit(ExtractExpression eexpr) {
            }

            public void visit(IntervalExpression iexpr) {
            }

            public void visit(JdbcNamedParameter jdbcNamedParameter) {
            }

            public void visit(OracleHierarchicalExpression arg0) {
            }

            public void visit(RegExpMatchOperator rexpr) {
            }

            public void visit(SignedExpression arg0) {
            }

            public void visit(JsonExpression arg0) {
            }

            public void visit(JsonOperator jsonOperator) {
            }

            public void visit(RegExpMySQLOperator arg0) {
            }

            public void visit(UserVariable userVariable) {
            }

            public void visit(NumericBind numericBind) {
            }

            public void visit(KeepExpression keepExpression) {
            }

            public void visit(MySQLGroupConcat mySQLGroupConcat) {
            }

            public void visit(RowConstructor rowConstructor) {
            }

            public void visit(OracleHint oracleHint) {
            }

            public void visit(TimeKeyExpression timeKeyExpression) {
            }

            public void visit(DateTimeLiteralExpression dateTimeLiteralExpression) {
            }

            public void visit(NotExpression notExpression) {
            }

            public void visit(SubSelect subSelect) {
                subSelect.getSelectBody().accept(selectVisitor);
            }
        };
        private final ItemsListVisitor itemsListVisitor = new ItemsListVisitor(){

            public void visit(ExpressionList expressionList) {
                for (Expression expression : expressionList.getExpressions()) {
                    expression.accept(expressionVisitor);
                }
            }

            public void visit(MultiExpressionList multiExprList) {
                for (ExpressionList exprList : multiExprList.getExprList()) {
                    exprList.accept((ItemsListVisitor)this);
                }
            }

            public void visit(SubSelect subSelect) {
                subSelect.getSelectBody().accept(selectVisitor);
            }
        };

        public TableNameVisitor(Select select, QuotedIDFactory idfac) throws JSQLParserException {
            this.idfac = idfac;
            if (select.getWithItemsList() != null) {
                for (WithItem withItem : select.getWithItemsList()) {
                    withItem.accept(this.selectVisitor);
                }
            }
            select.getSelectBody().accept(this.selectVisitor);
        }

        public List<RelationID> getRelations() {
            return this.relations;
        }
    }
}

