/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.spec.dbschema.impl;

import it.unibz.inf.ontop.dbschema.DBMetadata;
import it.unibz.inf.ontop.dbschema.RDBMetadata;
import it.unibz.inf.ontop.dbschema.RDBMetadataExtractionTools;
import it.unibz.inf.ontop.dbschema.RelationID;
import it.unibz.inf.ontop.exception.DBMetadataExtractionException;
import it.unibz.inf.ontop.injection.OntopMappingSQLSettings;
import it.unibz.inf.ontop.model.type.TypeFactory;
import it.unibz.inf.ontop.spec.dbschema.PreProcessedImplicitRelationalDBConstraintExtractor;
import it.unibz.inf.ontop.spec.dbschema.PreProcessedImplicitRelationalDBConstraintSet;
import it.unibz.inf.ontop.spec.dbschema.RDBMetadataExtractor;
import it.unibz.inf.ontop.spec.dbschema.impl.SQLTableNameExtractor;
import it.unibz.inf.ontop.spec.mapping.pp.SQLPPMapping;
import it.unibz.inf.ontop.spec.mapping.pp.SQLPPTriplesMap;
import java.io.File;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import javax.inject.Inject;

public class DefaultRDBMetadataExtractor
implements RDBMetadataExtractor {
    private final Boolean obtainFullMetadata;
    private final PreProcessedImplicitRelationalDBConstraintExtractor implicitDBConstraintExtractor;
    private final TypeFactory typeFactory;

    @Inject
    private DefaultRDBMetadataExtractor(OntopMappingSQLSettings settings, PreProcessedImplicitRelationalDBConstraintExtractor implicitDBConstraintExtractor, TypeFactory typeFactory) {
        this.obtainFullMetadata = settings.isFullMetadataExtractionEnabled();
        this.implicitDBConstraintExtractor = implicitDBConstraintExtractor;
        this.typeFactory = typeFactory;
    }

    @Override
    public RDBMetadata extract(SQLPPMapping ppMapping, Connection connection, Optional<File> constraintFile) throws DBMetadataExtractionException {
        try {
            RDBMetadata metadata = RDBMetadataExtractionTools.createMetadata((Connection)connection, (TypeFactory)this.typeFactory);
            return this.extract(ppMapping, connection, (DBMetadata)metadata, constraintFile);
        }
        catch (SQLException e) {
            throw new DBMetadataExtractionException(e.getMessage());
        }
    }

    @Override
    public RDBMetadata extract(SQLPPMapping ppMapping, @Nullable Connection connection, DBMetadata partiallyDefinedMetadata, Optional<File> constraintFile) throws DBMetadataExtractionException {
        if (!(partiallyDefinedMetadata instanceof RDBMetadata)) {
            throw new IllegalArgumentException("Was expecting a DBMetadata");
        }
        Optional<PreProcessedImplicitRelationalDBConstraintSet> implicitConstraints = constraintFile.isPresent() ? Optional.of(this.implicitDBConstraintExtractor.extract(constraintFile.get())) : Optional.empty();
        try {
            RDBMetadata metadata = (RDBMetadata)partiallyDefinedMetadata;
            if (this.obtainFullMetadata.booleanValue()) {
                RDBMetadataExtractionTools.loadMetadata((RDBMetadata)metadata, (Connection)connection, null);
            } else {
                try {
                    Set<RelationID> realTables = SQLTableNameExtractor.getRealTables(metadata.getQuotedIDFactory(), (Collection<SQLPPTriplesMap>)ppMapping.getTripleMaps());
                    implicitConstraints.ifPresent(c -> {
                        Set referredTables = c.getReferredTables(metadata.getQuotedIDFactory());
                        realTables.addAll(referredTables);
                    });
                    RDBMetadataExtractionTools.loadMetadata((RDBMetadata)metadata, (Connection)connection, realTables);
                }
                catch (SQLException e) {
                    System.out.println("Error obtaining the metadata " + e);
                }
            }
            implicitConstraints.ifPresent(c -> {
                c.insertUniqueConstraints((DBMetadata)metadata);
                c.insertForeignKeyConstraints((DBMetadata)metadata);
            });
            return metadata;
        }
        catch (SQLException e) {
            throw new DBMetadataExtractionException(e.getMessage());
        }
    }
}

