/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.injection.impl;

import com.google.common.collect.ImmutableMap;
import com.google.inject.Module;
import it.unibz.inf.ontop.exception.DuplicateMappingException;
import it.unibz.inf.ontop.exception.InvalidMappingException;
import it.unibz.inf.ontop.exception.InvalidOntopConfigurationException;
import it.unibz.inf.ontop.exception.MappingIOException;
import it.unibz.inf.ontop.exception.OBDASpecificationException;
import it.unibz.inf.ontop.injection.OntopMappingSQLConfiguration;
import it.unibz.inf.ontop.injection.OntopMappingSQLSettings;
import it.unibz.inf.ontop.injection.OntopMappingSettings;
import it.unibz.inf.ontop.injection.OntopSQLCoreConfiguration;
import it.unibz.inf.ontop.injection.OntopSQLCredentialConfiguration;
import it.unibz.inf.ontop.injection.OntopSQLCredentialSettings;
import it.unibz.inf.ontop.injection.impl.OntologySupplier;
import it.unibz.inf.ontop.injection.impl.OntopAbstractModule;
import it.unibz.inf.ontop.injection.impl.OntopMappingConfigurationImpl;
import it.unibz.inf.ontop.injection.impl.OntopMappingPostModule;
import it.unibz.inf.ontop.injection.impl.OntopMappingSQLModule;
import it.unibz.inf.ontop.injection.impl.OntopMappingSQLSettingsImpl;
import it.unibz.inf.ontop.injection.impl.OntopOBDAConfigurationImpl;
import it.unibz.inf.ontop.injection.impl.OntopSQLCoreConfigurationImpl;
import it.unibz.inf.ontop.injection.impl.OntopSQLCredentialConfigurationImpl;
import it.unibz.inf.ontop.iq.executor.ProposalExecutor;
import it.unibz.inf.ontop.iq.proposal.QueryOptimizationProposal;
import it.unibz.inf.ontop.spec.OBDASpecification;
import it.unibz.inf.ontop.spec.mapping.parser.SQLMappingParser;
import it.unibz.inf.ontop.spec.mapping.pp.SQLPPMapping;
import java.io.File;
import java.io.Reader;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.apache.commons.rdf.api.Graph;

public class OntopMappingSQLConfigurationImpl
extends OntopMappingConfigurationImpl
implements OntopMappingSQLConfiguration {
    private final OntopMappingSQLSettings settings;
    private final OntopMappingSQLOptions options;
    private final OntopSQLCredentialConfigurationImpl sqlConfiguration;

    OntopMappingSQLConfigurationImpl(OntopMappingSQLSettings settings, OntopMappingSQLOptions options) {
        super((OntopMappingSettings)settings, options.mappingOptions);
        this.settings = settings;
        this.options = options;
        this.sqlConfiguration = new OntopSQLCredentialConfigurationImpl((OntopSQLCredentialSettings)settings, options.sqlOptions, () -> ((OntopMappingSQLConfigurationImpl)this).getInjector());
    }

    boolean isInputMappingDefined() {
        return this.options.ppMapping.isPresent();
    }

    protected Stream<Module> buildGuiceModules() {
        return Stream.concat(Stream.concat(super.buildGuiceModules(), this.sqlConfiguration.buildGuiceModules()), Stream.of(new OntopAbstractModule[]{new OntopMappingSQLModule(this), new OntopMappingPostModule((OntopMappingSettings)this.getSettings())}));
    }

    @Override
    public OntopMappingSQLSettings getSettings() {
        return this.settings;
    }

    protected OBDASpecification loadOBDASpecification() throws OBDASpecificationException {
        return this.loadSpecification(Optional::empty, Optional::empty, Optional::empty, Optional::empty, Optional::empty);
    }

    OBDASpecification loadSpecification(OntologySupplier ontologySupplier, Supplier<Optional<File>> mappingFileSupplier, Supplier<Optional<Reader>> mappingReaderSupplier, Supplier<Optional<Graph>> mappingGraphSupplier, Supplier<Optional<File>> constraintFileSupplier) throws OBDASpecificationException {
        return this.loadSpecification(ontologySupplier, () -> this.options.ppMapping.map(m -> m), mappingFileSupplier, mappingReaderSupplier, mappingGraphSupplier, constraintFileSupplier);
    }

    @Override
    public Optional<SQLPPMapping> loadPPMapping() throws MappingIOException, InvalidMappingException, DuplicateMappingException {
        return this.loadPPMapping(Optional::empty, Optional::empty, Optional::empty);
    }

    Optional<SQLPPMapping> loadPPMapping(Supplier<Optional<File>> mappingFileSupplier, Supplier<Optional<Reader>> mappingReaderSupplier, Supplier<Optional<Graph>> mappingGraphSupplier) throws MappingIOException, InvalidMappingException, DuplicateMappingException {
        if (this.options.ppMapping.isPresent()) {
            return this.options.ppMapping;
        }
        SQLMappingParser parser = (SQLMappingParser)this.getInjector().getInstance(SQLMappingParser.class);
        Optional<File> optionalMappingFile = mappingFileSupplier.get();
        if (optionalMappingFile.isPresent()) {
            return Optional.of(parser.parse(optionalMappingFile.get()));
        }
        Optional<Reader> optionalMappingReader = mappingReaderSupplier.get();
        if (optionalMappingReader.isPresent()) {
            return Optional.of(parser.parse(optionalMappingReader.get()));
        }
        Optional<Graph> optionalMappingGraph = mappingGraphSupplier.get();
        if (optionalMappingGraph.isPresent()) {
            return Optional.of(parser.parse(optionalMappingGraph.get()));
        }
        return Optional.empty();
    }

    protected ImmutableMap<Class<? extends QueryOptimizationProposal>, Class<? extends ProposalExecutor>> generateOptimizationConfigurationMap() {
        ImmutableMap.Builder internalExecutorMapBuilder = ImmutableMap.builder();
        internalExecutorMapBuilder.putAll((Map)super.generateOptimizationConfigurationMap());
        internalExecutorMapBuilder.putAll((Map)this.sqlConfiguration.generateOptimizationConfigurationMap());
        return internalExecutorMapBuilder.build();
    }

    public static class BuilderImpl<B extends OntopMappingSQLConfiguration.Builder<B>>
    extends OntopMappingSQLBuilderMixin<B> {
        @Override
        public OntopMappingSQLConfiguration build() {
            Properties properties = this.generateProperties();
            OntopMappingSQLSettingsImpl settings = new OntopMappingSQLSettingsImpl(properties);
            OntopMappingSQLOptions options = this.generateMappingSQLOptions();
            return new OntopMappingSQLConfigurationImpl(settings, options);
        }
    }

    protected static abstract class OntopMappingSQLBuilderMixin<B extends OntopMappingSQLConfiguration.Builder<B>>
    extends OntopMappingConfigurationImpl.OntopMappingBuilderMixin<B>
    implements OntopMappingSQLConfiguration.Builder<B> {
        private final DefaultMappingSQLBuilderFragment<B> localBuilderFragment;
        private final OntopSQLCoreConfigurationImpl.DefaultOntopSQLCoreBuilderFragment<B> sqlCoreBuilderFragment;
        private final OntopSQLCredentialConfigurationImpl.DefaultOntopSQLCredentialBuilderFragment<B> sqlCredentialBuilderFragment;

        protected OntopMappingSQLBuilderMixin() {
            OntopMappingSQLBuilderMixin builder = this;
            this.localBuilderFragment = new DefaultMappingSQLBuilderFragment<OntopMappingSQLBuilderMixin>(builder, () -> ((OntopMappingSQLBuilderMixin)this).isMappingDefined(), () -> ((OntopMappingSQLBuilderMixin)this).declareMappingDefined());
            this.sqlCoreBuilderFragment = new OntopSQLCoreConfigurationImpl.DefaultOntopSQLCoreBuilderFragment((OntopSQLCoreConfiguration.Builder)builder);
            this.sqlCredentialBuilderFragment = new OntopSQLCredentialConfigurationImpl.DefaultOntopSQLCredentialBuilderFragment((OntopSQLCredentialConfiguration.Builder)builder);
        }

        @Override
        public B ppMapping(@Nonnull SQLPPMapping ppMapping) {
            return this.localBuilderFragment.ppMapping(ppMapping);
        }

        protected Properties generateProperties() {
            Properties properties = super.generateProperties();
            properties.putAll((Map<?, ?>)this.localBuilderFragment.generateProperties());
            properties.putAll((Map<?, ?>)this.sqlCoreBuilderFragment.generateProperties());
            properties.putAll((Map<?, ?>)this.sqlCredentialBuilderFragment.generateProperties());
            return properties;
        }

        final OntopMappingSQLOptions generateMappingSQLOptions() {
            OntopOBDAConfigurationImpl.OntopOBDAOptions obdaOptions = this.generateOBDAOptions();
            OntopSQLCredentialConfigurationImpl.OntopSQLCredentialOptions sqlOptions = this.sqlCredentialBuilderFragment.generateSQLCredentialOptions(this.sqlCoreBuilderFragment.generateSQLCoreOptions(obdaOptions.modelOptions));
            return this.localBuilderFragment.generateMappingSQLOptions(sqlOptions, this.generateMappingOptions(obdaOptions));
        }

        public B jdbcName(String dbName) {
            return (B)((OntopMappingSQLConfiguration.Builder)this.sqlCoreBuilderFragment.jdbcName(dbName));
        }

        public B jdbcUrl(String jdbcUrl) {
            return (B)((OntopMappingSQLConfiguration.Builder)this.sqlCoreBuilderFragment.jdbcUrl(jdbcUrl));
        }

        public B jdbcUser(String username) {
            return (B)((OntopMappingSQLConfiguration.Builder)this.sqlCredentialBuilderFragment.jdbcUser(username));
        }

        public B jdbcPassword(String password) {
            return (B)((OntopMappingSQLConfiguration.Builder)this.sqlCredentialBuilderFragment.jdbcPassword(password));
        }

        public B jdbcDriver(String jdbcDriver) {
            return (B)((OntopMappingSQLConfiguration.Builder)this.sqlCoreBuilderFragment.jdbcDriver(jdbcDriver));
        }
    }

    protected static class DefaultMappingSQLBuilderFragment<B extends OntopMappingSQLConfiguration.Builder<B>>
    implements OntopMappingSQLConfiguration.OntopMappingSQLBuilderFragment<B> {
        private final B builder;
        private final Supplier<Boolean> isMappingDefinedSupplier;
        private final Runnable declareMappingDefinedCB;
        private Optional<SQLPPMapping> ppMapping = Optional.empty();

        protected DefaultMappingSQLBuilderFragment(B builder, Supplier<Boolean> isMappingDefinedSupplier, Runnable declareMappingDefinedCB) {
            this.builder = builder;
            this.isMappingDefinedSupplier = isMappingDefinedSupplier;
            this.declareMappingDefinedCB = declareMappingDefinedCB;
        }

        @Override
        public B ppMapping(@Nonnull SQLPPMapping ppMapping) {
            if (this.isMappingDefinedSupplier.get().booleanValue()) {
                throw new InvalidOntopConfigurationException("OBDA model or mappings already defined!");
            }
            this.declareMappingDefinedCB.run();
            this.ppMapping = Optional.of(ppMapping);
            return this.builder;
        }

        final OntopMappingSQLOptions generateMappingSQLOptions(OntopSQLCredentialConfigurationImpl.OntopSQLCredentialOptions sqlOptions, OntopMappingConfigurationImpl.OntopMappingOptions mappingOptions) {
            return new OntopMappingSQLOptions(this.ppMapping, sqlOptions, mappingOptions);
        }

        Properties generateProperties() {
            return new Properties();
        }
    }

    public static class OntopMappingSQLOptions {
        final OntopSQLCredentialConfigurationImpl.OntopSQLCredentialOptions sqlOptions;
        final OntopMappingConfigurationImpl.OntopMappingOptions mappingOptions;
        final Optional<SQLPPMapping> ppMapping;

        private OntopMappingSQLOptions(Optional<SQLPPMapping> ppMapping, OntopSQLCredentialConfigurationImpl.OntopSQLCredentialOptions sqlOptions, OntopMappingConfigurationImpl.OntopMappingOptions mappingOptions) {
            this.sqlOptions = sqlOptions;
            this.mappingOptions = mappingOptions;
            this.ppMapping = ppMapping;
        }
    }
}

