/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.injection.impl;

import it.unibz.inf.ontop.exception.DuplicateMappingException;
import it.unibz.inf.ontop.exception.InvalidMappingException;
import it.unibz.inf.ontop.exception.InvalidOntopConfigurationException;
import it.unibz.inf.ontop.exception.MappingIOException;
import it.unibz.inf.ontop.exception.OBDASpecificationException;
import it.unibz.inf.ontop.injection.OntopMappingSQLAllConfiguration;
import it.unibz.inf.ontop.injection.OntopMappingSQLAllSettings;
import it.unibz.inf.ontop.injection.OntopMappingSQLSettings;
import it.unibz.inf.ontop.injection.impl.OntologySupplier;
import it.unibz.inf.ontop.injection.impl.OntopMappingSQLAllSettingsImpl;
import it.unibz.inf.ontop.injection.impl.OntopMappingSQLConfigurationImpl;
import it.unibz.inf.ontop.spec.OBDASpecification;
import it.unibz.inf.ontop.spec.mapping.pp.SQLPPMapping;
import java.io.File;
import java.io.Reader;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import javax.annotation.Nonnull;
import org.apache.commons.rdf.api.Graph;

public class OntopMappingSQLAllConfigurationImpl
extends OntopMappingSQLConfigurationImpl
implements OntopMappingSQLAllConfiguration {
    private final OntopMappingSQLAllSettings settings;
    private final OntopMappingSQLAllOptions options;

    OntopMappingSQLAllConfigurationImpl(OntopMappingSQLAllSettings settings, OntopMappingSQLAllOptions options) {
        super((OntopMappingSQLSettings)settings, options.mappingSQLOptions);
        this.settings = settings;
        this.options = options;
    }

    @Override
    public OntopMappingSQLAllSettings getSettings() {
        return this.settings;
    }

    protected OBDASpecification loadOBDASpecification() throws OBDASpecificationException {
        return this.loadSpecification(Optional::empty);
    }

    OBDASpecification loadSpecification(OntologySupplier ontologySupplier) throws OBDASpecificationException {
        return this.loadSpecification(ontologySupplier, () -> this.options.mappingFile, () -> this.options.mappingReader, () -> this.options.mappingGraph, () -> this.options.constraintFile);
    }

    public Optional<SQLPPMapping> loadPPMapping() throws MappingIOException, InvalidMappingException, DuplicateMappingException {
        return this.loadPPMapping(() -> this.options.mappingFile, () -> this.options.mappingReader, () -> this.options.mappingGraph);
    }

    boolean isInputMappingDefined() {
        return super.isInputMappingDefined() || this.options.mappingFile.isPresent() || this.options.mappingGraph.isPresent() || this.options.mappingReader.isPresent();
    }

    public static class BuilderImpl<B extends OntopMappingSQLAllConfiguration.Builder<B>>
    extends OntopMappingSQLAllBuilderMixin<B> {
        @Override
        public OntopMappingSQLAllConfiguration build() {
            OntopMappingSQLAllSettingsImpl settings = new OntopMappingSQLAllSettingsImpl(this.generateProperties(), this.isR2rml());
            OntopMappingSQLAllOptions options = this.generateMappingSQLAllOptions();
            return new OntopMappingSQLAllConfigurationImpl(settings, options);
        }
    }

    protected static abstract class OntopMappingSQLAllBuilderMixin<B extends OntopMappingSQLAllConfiguration.Builder<B>>
    extends OntopMappingSQLConfigurationImpl.OntopMappingSQLBuilderMixin<B>
    implements OntopMappingSQLAllConfiguration.Builder<B> {
        private final StandardMappingSQLAllBuilderFragment<B> localFragmentBuilder;
        private boolean isImplicitConstraintSetDefined = false;

        OntopMappingSQLAllBuilderMixin() {
            OntopMappingSQLAllBuilderMixin builder = this;
            this.localFragmentBuilder = new StandardMappingSQLAllBuilderFragment<OntopMappingSQLAllBuilderMixin>(builder, () -> ((OntopMappingSQLAllBuilderMixin)this).declareMappingDefined(), this::declareImplicitConstraintSetDefined);
        }

        @Override
        public B nativeOntopMappingFile(@Nonnull File mappingFile) {
            return this.localFragmentBuilder.nativeOntopMappingFile(mappingFile);
        }

        @Override
        public B nativeOntopMappingFile(@Nonnull String mappingFilename) {
            return this.localFragmentBuilder.nativeOntopMappingFile(mappingFilename);
        }

        @Override
        public B nativeOntopMappingReader(@Nonnull Reader mappingReader) {
            return this.localFragmentBuilder.nativeOntopMappingReader(mappingReader);
        }

        @Override
        public B r2rmlMappingFile(@Nonnull File mappingFile) {
            return this.localFragmentBuilder.r2rmlMappingFile(mappingFile);
        }

        @Override
        public B r2rmlMappingFile(@Nonnull String mappingFilename) {
            return this.localFragmentBuilder.r2rmlMappingFile(mappingFilename);
        }

        @Override
        public B r2rmlMappingReader(@Nonnull Reader mappingReader) {
            return this.localFragmentBuilder.r2rmlMappingReader(mappingReader);
        }

        @Override
        public B r2rmlMappingGraph(@Nonnull Graph rdfGraph) {
            return this.localFragmentBuilder.r2rmlMappingGraph(rdfGraph);
        }

        @Override
        public B basicImplicitConstraintFile(@Nonnull File constraintFile) {
            return this.localFragmentBuilder.basicImplicitConstraintFile(constraintFile);
        }

        @Override
        public B basicImplicitConstraintFile(@Nonnull String constraintFilename) {
            return this.localFragmentBuilder.basicImplicitConstraintFile(constraintFilename);
        }

        final OntopMappingSQLAllOptions generateMappingSQLAllOptions() {
            OntopMappingSQLConfigurationImpl.OntopMappingSQLOptions sqlMappingOptions = this.generateMappingSQLOptions();
            return this.localFragmentBuilder.generateMappingSQLAllOptions(sqlMappingOptions);
        }

        protected Properties generateProperties() {
            Properties p = super.generateProperties();
            p.putAll((Map<?, ?>)this.localFragmentBuilder.generateProperties());
            return p;
        }

        boolean isR2rml() {
            return this.localFragmentBuilder.isR2rml();
        }

        void declareImplicitConstraintSetDefined() {
            if (this.isImplicitConstraintSetDefined) {
                throw new InvalidOntopConfigurationException("The implicit constraint file is already defined");
            }
            this.isImplicitConstraintSetDefined = true;
        }
    }

    static class StandardMappingSQLAllBuilderFragment<B extends OntopMappingSQLAllConfiguration.Builder<B>>
    implements OntopMappingSQLAllConfiguration.OntopMappingSQLAllBuilderFragment<B> {
        private final B builder;
        private final Runnable declareMappingDefinedCB;
        private final Runnable declareImplicitConstraintSetDefinedCB;
        private Optional<File> mappingFile = Optional.empty();
        private Optional<Reader> mappingReader = Optional.empty();
        private Optional<Graph> mappingGraph = Optional.empty();
        private Optional<File> constraintFile = Optional.empty();
        private boolean useR2rml = false;

        protected StandardMappingSQLAllBuilderFragment(B builder, Runnable declareMappingDefinedCB, Runnable declareImplicitConstraintSetDefinedCB) {
            this.builder = builder;
            this.declareMappingDefinedCB = declareMappingDefinedCB;
            this.declareImplicitConstraintSetDefinedCB = declareImplicitConstraintSetDefinedCB;
        }

        @Override
        public B nativeOntopMappingFile(@Nonnull File mappingFile) {
            this.declareMappingDefinedCB.run();
            this.mappingFile = Optional.of(mappingFile);
            return this.builder;
        }

        @Override
        public B nativeOntopMappingFile(@Nonnull String mappingFilename) {
            this.setMappingFile(mappingFilename);
            return this.builder;
        }

        @Override
        public B nativeOntopMappingReader(@Nonnull Reader mappingReader) {
            this.declareMappingDefinedCB.run();
            this.mappingReader = Optional.of(mappingReader);
            return this.builder;
        }

        @Override
        public B r2rmlMappingFile(@Nonnull File mappingFile) {
            this.declareMappingDefinedCB.run();
            this.useR2rml = true;
            this.mappingFile = Optional.of(mappingFile);
            return this.builder;
        }

        @Override
        public B r2rmlMappingFile(@Nonnull String mappingFilename) {
            this.declareMappingDefinedCB.run();
            this.useR2rml = true;
            try {
                URI fileURI = new URI(mappingFilename);
                String scheme = fileURI.getScheme();
                if (scheme == null) {
                    this.mappingFile = Optional.of(new File(fileURI.getPath()));
                } else if (scheme.equals("file")) {
                    this.mappingFile = Optional.of(new File(fileURI));
                } else {
                    throw new InvalidOntopConfigurationException("Currently only local files are supportedas R2RML mapping files");
                }
                return this.builder;
            }
            catch (URISyntaxException e) {
                throw new InvalidOntopConfigurationException("Invalid mapping file path: " + e.getMessage());
            }
        }

        @Override
        public B r2rmlMappingReader(@Nonnull Reader mappingReader) {
            this.declareMappingDefinedCB.run();
            this.useR2rml = true;
            this.mappingReader = Optional.of(mappingReader);
            return this.builder;
        }

        @Override
        public B r2rmlMappingGraph(@Nonnull Graph rdfGraph) {
            this.declareMappingDefinedCB.run();
            this.useR2rml = true;
            this.mappingGraph = Optional.of(rdfGraph);
            return this.builder;
        }

        @Override
        public B basicImplicitConstraintFile(@Nonnull File constraintFile) {
            this.declareImplicitConstraintSetDefinedCB.run();
            this.constraintFile = Optional.of(constraintFile);
            return this.builder;
        }

        @Override
        public B basicImplicitConstraintFile(@Nonnull String constraintFilename) {
            this.declareImplicitConstraintSetDefinedCB.run();
            try {
                URI fileURI = new URI(constraintFilename);
                String scheme = fileURI.getScheme();
                if (scheme == null) {
                    this.constraintFile = Optional.of(new File(fileURI.getPath()));
                } else if (scheme.equals("file")) {
                    this.constraintFile = Optional.of(new File(fileURI));
                } else {
                    throw new InvalidOntopConfigurationException("Currently only local files are supportedas implicit constraint files");
                }
                return this.builder;
            }
            catch (URISyntaxException e) {
                throw new InvalidOntopConfigurationException("Invalid implicit constraint file path: " + e.getMessage());
            }
        }

        protected Properties generateProperties() {
            Properties p = new Properties();
            return p;
        }

        boolean isR2rml() {
            return this.useR2rml;
        }

        protected final void setMappingFile(String mappingFilename) {
            block4: {
                this.declareMappingDefinedCB.run();
                try {
                    URI fileURI = new URI(mappingFilename);
                    String scheme = fileURI.getScheme();
                    if (scheme == null) {
                        this.mappingFile = Optional.of(new File(fileURI.getPath()));
                        break block4;
                    }
                    if (scheme.equals("file")) {
                        this.mappingFile = Optional.of(new File(fileURI));
                        break block4;
                    }
                    throw new InvalidOntopConfigurationException("Currently only local files are supportedas mapping files");
                }
                catch (URISyntaxException e) {
                    throw new InvalidOntopConfigurationException("Invalid mapping file path: " + e.getMessage());
                }
            }
        }

        final OntopMappingSQLAllOptions generateMappingSQLAllOptions(OntopMappingSQLConfigurationImpl.OntopMappingSQLOptions mappingOptions) {
            return new OntopMappingSQLAllOptions(this.mappingFile, this.mappingReader, this.mappingGraph, this.constraintFile, mappingOptions);
        }
    }

    static class OntopMappingSQLAllOptions {
        private final Optional<File> mappingFile;
        private final Optional<Reader> mappingReader;
        private final Optional<Graph> mappingGraph;
        private final Optional<File> constraintFile;
        final OntopMappingSQLConfigurationImpl.OntopMappingSQLOptions mappingSQLOptions;

        OntopMappingSQLAllOptions(Optional<File> mappingFile, Optional<Reader> mappingReader, Optional<Graph> mappingGraph, Optional<File> constraintFile, OntopMappingSQLConfigurationImpl.OntopMappingSQLOptions mappingSQLOptions) {
            this.mappingFile = mappingFile;
            this.mappingReader = mappingReader;
            this.mappingGraph = mappingGraph;
            this.constraintFile = constraintFile;
            this.mappingSQLOptions = mappingSQLOptions;
        }
    }
}

