/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.spec.mapping.serializer.impl;

import eu.optique.r2rml.api.binding.rdf4j.RDF4JR2RMLMappingManager;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableList;
import it.unibz.inf.ontop.spec.mapping.pp.SQLPPMapping;
import it.unibz.inf.ontop.spec.mapping.serializer.MappingSerializer;
import it.unibz.inf.ontop.spec.mapping.serializer.impl.SQLPPTriplesMapToR2RMLConverter;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import org.apache.commons.rdf.api.RDF;
import org.apache.commons.rdf.rdf4j.RDF4JGraph;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Namespace;
import org.eclipse.rdf4j.model.impl.SimpleNamespace;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.Rio;
import org.eclipse.rdf4j.rio.WriterConfig;
import org.eclipse.rdf4j.rio.helpers.BasicWriterSettings;

public class R2RMLMappingSerializer
implements MappingSerializer {
    private final RDF rdfFactory;
    private final RDF4JR2RMLMappingManager manager = RDF4JR2RMLMappingManager.getInstance();

    public R2RMLMappingSerializer(RDF rdfFactory) {
        this.rdfFactory = rdfFactory;
    }

    public void write(File file, SQLPPMapping ppMapping) throws IOException {
        try (FileOutputStream fos = new FileOutputStream(file);){
            SQLPPTriplesMapToR2RMLConverter transformer = new SQLPPTriplesMapToR2RMLConverter(this.rdfFactory, this.manager.getMappingFactory());
            ImmutableList tripleMaps = (ImmutableList)ppMapping.getTripleMaps().stream().flatMap(transformer::convert).collect(ImmutableCollectors.toList());
            RDF4JGraph rdf4JGraph = this.manager.exportMappings((Collection)tripleMaps);
            Model model = (Model)rdf4JGraph.asModel().get();
            model.setNamespace("rr", "http://www.w3.org/ns/r2rml#");
            ppMapping.getPrefixManager().getPrefixMap().forEach((key, value) -> model.setNamespace((Namespace)new SimpleNamespace(key.substring(0, key.length() - 1), value)));
            WriterConfig settings = new WriterConfig();
            settings.set(BasicWriterSettings.PRETTY_PRINT, (Object)true);
            settings.set(BasicWriterSettings.INLINE_BLANK_NODES, (Object)true);
            Rio.write((Iterable)model, (OutputStream)fos, (RDFFormat)RDFFormat.TURTLE, (WriterConfig)settings);
        }
    }
}

