/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.spec.mapping.parser.impl;

import com.google.inject.Inject;
import eu.optique.r2rml.api.model.LogicalTable;
import eu.optique.r2rml.api.model.ObjectMap;
import eu.optique.r2rml.api.model.PredicateObjectMap;
import eu.optique.r2rml.api.model.RefObjectMap;
import eu.optique.r2rml.api.model.SubjectMap;
import eu.optique.r2rml.api.model.TermMap;
import eu.optique.r2rml.api.model.TriplesMap;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableList;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableMap;
import it.unibz.inf.ontop.com.google.common.collect.Maps;
import it.unibz.inf.ontop.exception.MinorOntopInternalBugException;
import it.unibz.inf.ontop.exception.OntopInternalBugException;
import it.unibz.inf.ontop.model.template.TemplateFactory;
import it.unibz.inf.ontop.model.template.impl.BnodeTemplateFactory;
import it.unibz.inf.ontop.model.template.impl.IRITemplateFactory;
import it.unibz.inf.ontop.model.template.impl.LiteralTemplateFactory;
import it.unibz.inf.ontop.model.term.IRIConstant;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.NonVariableTerm;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.model.type.RDFDatatype;
import it.unibz.inf.ontop.model.type.TypeFactory;
import it.unibz.inf.ontop.model.vocabulary.RDF;
import it.unibz.inf.ontop.spec.mapping.SQLPPSourceQueryFactory;
import it.unibz.inf.ontop.spec.mapping.TargetAtom;
import it.unibz.inf.ontop.spec.mapping.TargetAtomFactory;
import it.unibz.inf.ontop.spec.mapping.parser.impl.R2RMLVocabulary;
import it.unibz.inf.ontop.spec.mapping.pp.SQLPPTriplesMap;
import it.unibz.inf.ontop.spec.mapping.pp.impl.R2RMLSQLPPtriplesMap;
import it.unibz.inf.ontop.substitution.SubstitutionFactory;
import it.unibz.inf.ontop.substitution.Var2VarSubstitution;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.rdf.api.IRI;
import org.apache.commons.rdf.api.Literal;
import org.apache.commons.rdf.api.RDFTerm;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class R2RMLToSQLPPTriplesMapConverter {
    private static final Logger LOGGER = LoggerFactory.getLogger(R2RMLToSQLPPTriplesMapConverter.class);
    private final TermFactory termFactory;
    private final TargetAtomFactory targetAtomFactory;
    private final SQLPPSourceQueryFactory sourceQueryFactory;
    private final SubstitutionFactory substitutionFactory;
    private final IRIConstant rdfType;
    private final String baseIri = "http://example.com/base/";
    private final ImmutableMap<IRI, TermMapFactory<TermMap, ? extends TemplateFactory>> iriTerm;
    private final ImmutableMap<IRI, TermMapFactory<TermMap, ? extends TemplateFactory>> iriOrBnodeTerm;
    private final ImmutableMap<IRI, TermMapFactory<ObjectMap, ? extends TemplateFactory>> iriOrBnodeOrLiteralTerm;
    private static final String TMP_PREFIX = "TMP";
    private static final String CHILD_PREFIX = "CHILD";
    private static final String PARENT_PREFIX = "PARENT";

    @Inject
    private R2RMLToSQLPPTriplesMapConverter(TermFactory termFactory, TypeFactory typeFactory, TargetAtomFactory targetAtomFactory, SQLPPSourceQueryFactory sourceQueryFactory, SubstitutionFactory substitutionFactory) {
        this.termFactory = termFactory;
        this.targetAtomFactory = targetAtomFactory;
        this.sourceQueryFactory = sourceQueryFactory;
        this.substitutionFactory = substitutionFactory;
        this.rdfType = termFactory.getConstantIRI(RDF.TYPE);
        IRITemplateFactory iriTemplateFactory = new IRITemplateFactory(termFactory);
        BnodeTemplateFactory bnodeTemplateFactory = new BnodeTemplateFactory(termFactory);
        LiteralTemplateFactory literalTemplateFactory = new LiteralTemplateFactory(termFactory, typeFactory);
        this.iriTerm = ImmutableMap.of((Object)R2RMLVocabulary.iri, new IriTermMapFactory(iriTemplateFactory));
        this.iriOrBnodeTerm = ImmutableMap.of((Object)R2RMLVocabulary.iri, new IriTermMapFactory(iriTemplateFactory), (Object)R2RMLVocabulary.blankNode, new BnodeTermMapFactory(bnodeTemplateFactory));
        this.iriOrBnodeOrLiteralTerm = ImmutableMap.of((Object)R2RMLVocabulary.iri, new IriTermMapFactory(iriTemplateFactory), (Object)R2RMLVocabulary.blankNode, new BnodeTermMapFactory(bnodeTemplateFactory), (Object)R2RMLVocabulary.literal, new LiteralTermMapFactory(literalTemplateFactory));
    }

    public ImmutableList<SQLPPTriplesMap> convert(Collection<TriplesMap> tripleMaps) {
        ImmutableMap regularMap = (ImmutableMap)tripleMaps.stream().map(tm -> this.getSQLPPTriplesMap((TriplesMap)tm).map(pp -> Maps.immutableEntry((Object)tm, (Object)pp))).filter(Optional::isPresent).map(Optional::get).collect(ImmutableCollectors.toMap());
        return (ImmutableList)Stream.concat(regularMap.values().stream(), tripleMaps.stream().flatMap(tm -> tm.getPredicateObjectMaps().stream().flatMap(pom -> this.getRefSQLPPTriplesMaps((TriplesMap)tm, (PredicateObjectMap)pom, (ImmutableMap<TriplesMap, SQLPPTriplesMap>)regularMap)))).collect(ImmutableCollectors.toList());
    }

    private Optional<SQLPPTriplesMap> getSQLPPTriplesMap(TriplesMap tm) {
        ImmutableList targetAtoms = (ImmutableList)this.getTargetAtoms(tm).collect(ImmutableCollectors.toList());
        if (targetAtoms.isEmpty()) {
            LOGGER.warn("WARNING a triples map without target query will not be introduced : " + tm);
            return Optional.empty();
        }
        String sourceQuery = tm.getLogicalTable().getSQLQuery().trim();
        return Optional.of(new R2RMLSQLPPtriplesMap("mapping-" + tm.hashCode(), this.sourceQueryFactory.createSourceQuery(sourceQuery), (ImmutableList<TargetAtom>)targetAtoms));
    }

    private Stream<TargetAtom> getTargetAtoms(TriplesMap tm) {
        SubjectMap subjectMap = tm.getSubjectMap();
        NonVariableTerm subject = this.extract(this.iriOrBnodeTerm, subjectMap);
        ImmutableList subject_graphs = (ImmutableList)subjectMap.getGraphMaps().stream().map(m -> this.extract(this.iriTerm, m)).collect(ImmutableCollectors.toList());
        return Stream.concat(subjectMap.getClasses().stream().map(arg_0 -> ((TermFactory)this.termFactory).getConstantIRI(arg_0)).flatMap(arg_0 -> this.lambda$getTargetAtoms$5((ImmutableTerm)subject, subject_graphs, arg_0)), tm.getPredicateObjectMaps().stream().flatMap(arg_0 -> this.lambda$getTargetAtoms$6((ImmutableTerm)subject, subject_graphs, arg_0)));
    }

    private Stream<TargetAtom> getTargetAtoms(ImmutableTerm subject, PredicateObjectMap pom, ImmutableList<NonVariableTerm> subject_graphs) {
        Stream<NonVariableTerm> predicates = pom.getPredicateMaps().stream().map(m -> this.extract(this.iriTerm, m));
        List objects = (List)pom.getObjectMaps().stream().map(m -> this.extract(this.iriOrBnodeOrLiteralTerm, m)).collect(ImmutableCollectors.toList());
        ImmutableList subject_graphs_and_predicate_object_graphs = (ImmutableList)Stream.concat(subject_graphs.stream(), pom.getGraphMaps().stream().map(m -> this.extract(this.iriTerm, m))).distinct().collect(ImmutableCollectors.toList());
        return predicates.flatMap(p -> objects.stream().flatMap(o -> this.getTargetAtoms(subject, (ImmutableTerm)p, (ImmutableTerm)o, (ImmutableList<? extends ImmutableTerm>)subject_graphs_and_predicate_object_graphs)));
    }

    private Stream<TargetAtom> getTargetAtoms(ImmutableTerm subject, ImmutableTerm predicate, ImmutableTerm object, ImmutableList<? extends ImmutableTerm> graphs) {
        return graphs.isEmpty() ? Stream.of(this.targetAtomFactory.getTripleTargetAtom(subject, predicate, object)) : graphs.stream().map(g -> R2RMLToSQLPPTriplesMapConverter.isDefaultGraph(g) ? this.targetAtomFactory.getTripleTargetAtom(subject, predicate, object) : this.targetAtomFactory.getQuadTargetAtom(subject, predicate, object, g));
    }

    private static boolean isDefaultGraph(ImmutableTerm graphTerm) {
        return graphTerm instanceof IRIConstant && ((IRIConstant)graphTerm).getIRI().equals((Object)R2RMLVocabulary.defaultGraph);
    }

    private Stream<SQLPPTriplesMap> getRefSQLPPTriplesMaps(TriplesMap tm, PredicateObjectMap pobm, ImmutableMap<TriplesMap, SQLPPTriplesMap> regularTriplesMap) {
        if (pobm.getRefObjectMaps().isEmpty()) {
            return Stream.of(new SQLPPTriplesMap[0]);
        }
        ImmutableList extractedPredicates = (ImmutableList)pobm.getPredicateMaps().stream().map(m -> this.extract(this.iriTerm, m)).collect(ImmutableCollectors.toList());
        ImmutableList subject_graphs_and_predicate_object_graphs = (ImmutableList)Stream.concat(tm.getSubjectMap().getGraphMaps().stream(), pobm.getGraphMaps().stream()).map(m -> this.extract(this.iriTerm, m)).distinct().collect(ImmutableCollectors.toList());
        return pobm.getRefObjectMaps().stream().map(robm -> this.getRefSQLPPTriplesMaps(tm, (RefObjectMap)robm, (ImmutableList<NonVariableTerm>)extractedPredicates, (ImmutableList<NonVariableTerm>)subject_graphs_and_predicate_object_graphs, regularTriplesMap));
    }

    private SQLPPTriplesMap getRefSQLPPTriplesMaps(TriplesMap tm, RefObjectMap robm, ImmutableList<NonVariableTerm> extractedPredicates, ImmutableList<NonVariableTerm> extractedGraphs, ImmutableMap<TriplesMap, SQLPPTriplesMap> regularTriplesMap) {
        String sourceQuery;
        ImmutableMap<Variable, Variable> childMap;
        ImmutableMap<Variable, Variable> parentMap;
        TriplesMap parent = robm.getParentMap();
        ImmutableTerm extractedSubject = this.getSubjectTerm(tm, regularTriplesMap);
        ImmutableTerm extractedObject = this.getSubjectTerm(parent, regularTriplesMap);
        if (robm.getJoinConditions().isEmpty()) {
            if (!parent.getLogicalTable().getSQLQuery().trim().equals(tm.getLogicalTable().getSQLQuery().trim())) {
                throw new IllegalArgumentException("No rr:joinCondition, but the two SQL queries are disitnct: " + tm.getLogicalTable().getSQLQuery() + " and " + parent.getLogicalTable().getSQLQuery());
            }
            childMap = parentMap = Stream.concat(R2RMLToSQLPPTriplesMapConverter.getVariableStreamOf(extractedSubject, extractedPredicates, extractedGraphs), extractedObject.getVariableStream()).collect(this.toVariableRenamingMap(TMP_PREFIX));
            sourceQuery = R2RMLToSQLPPTriplesMapConverter.getSQL(childMap.entrySet().stream().map(e -> Maps.immutableEntry((Object)("TMP." + e.getKey()), e.getValue())), Stream.of(Maps.immutableEntry((Object)tm.getLogicalTable(), (Object)TMP_PREFIX)), Stream.of(new Map.Entry[0]));
        } else {
            childMap = R2RMLToSQLPPTriplesMapConverter.getVariableStreamOf(extractedSubject, extractedPredicates, extractedGraphs).collect(this.toVariableRenamingMap(CHILD_PREFIX));
            parentMap = extractedObject.getVariableStream().collect(this.toVariableRenamingMap(PARENT_PREFIX));
            sourceQuery = R2RMLToSQLPPTriplesMapConverter.getSQL(Stream.concat(childMap.entrySet().stream().map(e -> Maps.immutableEntry((Object)("CHILD." + e.getKey()), e.getValue())), parentMap.entrySet().stream().map(e -> Maps.immutableEntry((Object)("PARENT." + e.getKey()), e.getValue()))), Stream.of(Maps.immutableEntry((Object)tm.getLogicalTable(), (Object)CHILD_PREFIX), Maps.immutableEntry((Object)parent.getLogicalTable(), (Object)PARENT_PREFIX)), robm.getJoinConditions().stream().map(j -> Maps.immutableEntry((Object)("CHILD." + j.getChild()), (Object)("PARENT." + j.getParent()))));
        }
        Var2VarSubstitution sub = this.substitutionFactory.getVar2VarSubstitution(childMap);
        ImmutableTerm subject = sub.apply(extractedSubject);
        ImmutableList graphs = (ImmutableList)extractedGraphs.stream().map(arg_0 -> ((Var2VarSubstitution)sub).apply(arg_0)).collect(ImmutableCollectors.toList());
        Var2VarSubstitution ob = this.substitutionFactory.getVar2VarSubstitution(parentMap);
        ImmutableTerm object = ob.apply(extractedObject);
        ImmutableList targetAtoms = (ImmutableList)extractedPredicates.stream().map(arg_0 -> ((Var2VarSubstitution)sub).apply(arg_0)).flatMap(p -> this.getTargetAtoms(subject, (ImmutableTerm)p, object, (ImmutableList<? extends ImmutableTerm>)graphs)).collect(ImmutableCollectors.toList());
        R2RMLSQLPPtriplesMap ppTriplesMap = new R2RMLSQLPPtriplesMap("tm-join-" + robm.hashCode(), this.sourceQueryFactory.createSourceQuery(sourceQuery), (ImmutableList<TargetAtom>)targetAtoms);
        LOGGER.info("Join \"triples map\" introduced: " + (Object)((Object)ppTriplesMap));
        return ppTriplesMap;
    }

    private static String getSQL(Stream<Map.Entry<String, Variable>> selectItems, Stream<Map.Entry<LogicalTable, String>> fromItems, Stream<Map.Entry<String, String>> whereClause) {
        String condition = whereClause.map(e -> (String)e.getKey() + " = " + (String)e.getValue()).collect(Collectors.joining(" AND "));
        return "SELECT " + selectItems.map(e -> (String)e.getKey() + " AS " + ((Variable)e.getValue()).getName()).collect(Collectors.joining(", ")) + " FROM " + fromItems.map(e -> "(" + ((LogicalTable)e.getKey()).getSQLQuery().trim() + ") " + (String)e.getValue()).collect(Collectors.joining(", ")) + (condition.isEmpty() ? "" : " WHERE " + condition);
    }

    private ImmutableTerm getSubjectTerm(TriplesMap tm, ImmutableMap<TriplesMap, SQLPPTriplesMap> regularTriplesMap) {
        return Optional.ofNullable(regularTriplesMap.get((Object)tm)).map(pp -> pp.getTargetAtoms().stream().map(a -> a.getSubstitutedTerm(0)).findAny().orElseThrow(() -> new MinorOntopInternalBugException("All created SQLPPTriplesMaps must have at least one target atom"))).orElseGet(() -> this.extract(this.iriOrBnodeTerm, tm.getSubjectMap()));
    }

    private static Stream<Variable> getVariableStreamOf(ImmutableTerm t, ImmutableList<? extends ImmutableTerm> l1, ImmutableList<? extends ImmutableTerm> l2) {
        return Stream.concat(t.getVariableStream(), Stream.concat(l1.stream(), l2.stream()).flatMap(ImmutableTerm::getVariableStream));
    }

    private Collector<Variable, ?, ImmutableMap<Variable, Variable>> toVariableRenamingMap(String prefix) {
        return ImmutableCollectors.toMap(v -> v, v -> this.prefixAttributeName(prefix + "_", (Variable)v));
    }

    private Variable prefixAttributeName(String prefix, Variable var) {
        String attributeName = var.getName();
        String newAttributeName = attributeName.startsWith("\"") && attributeName.endsWith("\"") || attributeName.startsWith("`") && attributeName.endsWith("`") ? attributeName.substring(0, 1) + prefix + attributeName.substring(1) : prefix + attributeName;
        return this.termFactory.getVariable(newAttributeName);
    }

    private <T extends TermMap> NonVariableTerm extract(ImmutableMap<IRI, TermMapFactory<T, ? extends TemplateFactory>> map, T termMap) {
        TermMapFactory termMapFactory = (TermMapFactory)map.get((Object)termMap.getTermType());
        if (termMapFactory == null) {
            throw new R2RMLParsingBugException("Was expecting one of " + map.keySet() + " when encountered " + termMap);
        }
        return termMapFactory.extract(termMap);
    }

    private /* synthetic */ Stream lambda$getTargetAtoms$6(ImmutableTerm subject, ImmutableList subject_graphs, PredicateObjectMap pom) {
        return this.getTargetAtoms(subject, pom, (ImmutableList<NonVariableTerm>)subject_graphs);
    }

    private /* synthetic */ Stream lambda$getTargetAtoms$5(ImmutableTerm subject, ImmutableList subject_graphs, IRIConstant iri) {
        return this.getTargetAtoms(subject, (ImmutableTerm)this.rdfType, (ImmutableTerm)iri, (ImmutableList<? extends ImmutableTerm>)subject_graphs);
    }

    private static class R2RMLParsingBugException
    extends OntopInternalBugException {
        protected R2RMLParsingBugException(String message) {
            super(message);
        }
    }

    private class LiteralTermMapFactory<T extends ObjectMap>
    extends TermMapFactory<T, LiteralTemplateFactory> {
        public LiteralTermMapFactory(LiteralTemplateFactory templateFactory) {
            super(templateFactory);
        }

        @Override
        protected NonVariableTerm onConstant(RDFTerm constant) {
            if (constant instanceof Literal) {
                return ((LiteralTemplateFactory)this.templateFactory).getConstant(((Literal)constant).getLexicalForm());
            }
            throw new R2RMLParsingBugException("Was expecting a Literal as constant, not a " + constant.getClass());
        }

        @Override
        public NonVariableTerm extract(T om) {
            RDFDatatype datatype = ((LiteralTemplateFactory)this.templateFactory).extractDatatype(Optional.ofNullable(om.getLanguageTag()), Optional.ofNullable(om.getDatatype())).orElseGet(() -> Optional.ofNullable(om.getConstant()).map(c -> (Literal)c).map(Literal::getDatatype).map(arg_0 -> ((LiteralTemplateFactory)((LiteralTemplateFactory)this.templateFactory)).getDatatype(arg_0)).orElseGet(() -> ((LiteralTemplateFactory)((LiteralTemplateFactory)this.templateFactory)).getAbstractRDFSLiteral()));
            return R2RMLToSQLPPTriplesMapConverter.this.termFactory.getRDFLiteralFunctionalTerm((ImmutableTerm)super.extract(om), datatype);
        }
    }

    private static class BnodeTermMapFactory<T extends TermMap>
    extends TermMapFactory<T, BnodeTemplateFactory> {
        public BnodeTermMapFactory(BnodeTemplateFactory templateFactory) {
            super(templateFactory);
        }

        @Override
        protected NonVariableTerm onConstant(RDFTerm constant) {
            throw new R2RMLParsingBugException("Constant blank nodes are not accepted in R2RML (should have been detected earlier)");
        }
    }

    private class IriTermMapFactory<T extends TermMap>
    extends TermMapFactory<T, IRITemplateFactory> {
        public IriTermMapFactory(IRITemplateFactory templateFactory) {
            super(templateFactory);
        }

        @Override
        protected NonVariableTerm onConstant(RDFTerm constant) {
            return ((IRITemplateFactory)this.templateFactory).getConstant(R2RMLVocabulary.resolveIri(((IRI)constant).getIRIString(), "http://example.com/base/"));
        }

        @Override
        protected NonVariableTerm onTemplate(String template) {
            return super.onTemplate(R2RMLVocabulary.resolveIri(template, "http://example.com/base/"));
        }
    }

    private static abstract class TermMapFactory<T extends TermMap, F extends TemplateFactory> {
        protected final F templateFactory;

        public TermMapFactory(F templateFactory) {
            this.templateFactory = templateFactory;
        }

        protected abstract NonVariableTerm onConstant(RDFTerm var1);

        protected NonVariableTerm onColumn(String column) {
            return this.templateFactory.getColumn(column);
        }

        protected NonVariableTerm onTemplate(String template) {
            return this.templateFactory.getTemplateTerm(this.templateFactory.getComponents(template));
        }

        public NonVariableTerm extract(T termMap) {
            if (termMap.getConstant() != null) {
                return this.onConstant(termMap.getConstant());
            }
            if (termMap.getTemplate() != null) {
                return this.onTemplate(termMap.getTemplate().toString());
            }
            if (termMap.getColumn() != null) {
                return this.onColumn(termMap.getColumn());
            }
            throw new R2RMLParsingBugException("A term map is either constant-valued, column-valued or template-valued.");
        }
    }
}

