/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.spec.mapping.parser.impl;

import com.google.inject.Inject;
import eu.optique.r2rml.api.binding.rdf4j.RDF4JR2RMLMappingManager;
import eu.optique.r2rml.api.model.impl.InvalidR2RMLMappingException;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableList;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableMap;
import it.unibz.inf.ontop.exception.InvalidMappingException;
import it.unibz.inf.ontop.exception.MappingIOException;
import it.unibz.inf.ontop.injection.SQLPPMappingFactory;
import it.unibz.inf.ontop.injection.SpecificationFactory;
import it.unibz.inf.ontop.spec.mapping.PrefixManager;
import it.unibz.inf.ontop.spec.mapping.parser.SQLMappingParser;
import it.unibz.inf.ontop.spec.mapping.parser.impl.R2RMLToSQLPPTriplesMapConverter;
import it.unibz.inf.ontop.spec.mapping.pp.SQLPPMapping;
import it.unibz.inf.ontop.spec.mapping.pp.SQLPPTriplesMap;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import java.util.Collection;
import java.util.Comparator;
import java.util.stream.Collectors;
import org.apache.commons.rdf.api.Graph;
import org.apache.commons.rdf.rdf4j.RDF4J;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.impl.LinkedHashModel;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFHandler;
import org.eclipse.rdf4j.rio.RDFHandlerException;
import org.eclipse.rdf4j.rio.RDFParseException;
import org.eclipse.rdf4j.rio.RDFParser;
import org.eclipse.rdf4j.rio.Rio;
import org.eclipse.rdf4j.rio.helpers.StatementCollector;

public class R2RMLMappingParser
implements SQLMappingParser {
    private final SQLPPMappingFactory ppMappingFactory;
    private final SpecificationFactory specificationFactory;
    private final R2RMLToSQLPPTriplesMapConverter transformer;
    private final RDF4JR2RMLMappingManager manager;

    @Inject
    private R2RMLMappingParser(SQLPPMappingFactory ppMappingFactory, SpecificationFactory specificationFactory, R2RMLToSQLPPTriplesMapConverter transformer) {
        this.ppMappingFactory = ppMappingFactory;
        this.specificationFactory = specificationFactory;
        this.transformer = transformer;
        this.manager = RDF4JR2RMLMappingManager.getInstance();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SQLPPMapping parse(File mappingFile) throws InvalidMappingException, MappingIOException {
        LinkedHashModel rdf4jGraph = new LinkedHashModel();
        RDFParser parser = Rio.createParser((RDFFormat)RDFFormat.TURTLE);
        StatementCollector collector = new StatementCollector((Collection)rdf4jGraph);
        parser.setRDFHandler((RDFHandler)collector);
        try (FileInputStream in = new FileInputStream(mappingFile);){
            URL documentUrl = new URL("file://" + mappingFile);
            parser.parse((InputStream)in, documentUrl.toString());
            SQLPPMapping sQLPPMapping = this.parse((Graph)new RDF4J().asGraph((Model)rdf4jGraph));
            return sQLPPMapping;
        }
        catch (IOException e) {
            throw new MappingIOException((Exception)e);
        }
        catch (RDFHandlerException | RDFParseException e) {
            throw new InvalidMappingException(e.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SQLPPMapping parse(Reader reader) throws InvalidMappingException, MappingIOException {
        LinkedHashModel rdf4jGraph = new LinkedHashModel();
        RDFParser parser = Rio.createParser((RDFFormat)RDFFormat.TURTLE);
        StatementCollector collector = new StatementCollector((Collection)rdf4jGraph);
        parser.setRDFHandler((RDFHandler)collector);
        try (Reader r = reader;){
            parser.parse(r, "http://example.org/baseIRI/");
            SQLPPMapping sQLPPMapping = this.parse((Graph)new RDF4J().asGraph((Model)rdf4jGraph));
            return sQLPPMapping;
        }
        catch (IOException e) {
            throw new MappingIOException((Exception)e);
        }
        catch (RDFHandlerException | RDFParseException e) {
            throw new InvalidMappingException(e.getMessage());
        }
    }

    public SQLPPMapping parse(Graph mappingGraph) throws InvalidMappingException {
        try {
            Collection tripleMaps = this.manager.importMappings(mappingGraph);
            tripleMaps = tripleMaps.stream().sorted(Comparator.comparing(Object::toString)).collect(Collectors.toList());
            ImmutableList<SQLPPTriplesMap> sourceMappings = this.transformer.convert(tripleMaps);
            PrefixManager prefixManager = this.specificationFactory.createPrefixManager(ImmutableMap.of());
            return this.ppMappingFactory.createSQLPreProcessedMapping(sourceMappings, prefixManager);
        }
        catch (InvalidR2RMLMappingException e) {
            throw new InvalidMappingException(e.getMessage());
        }
    }
}

