/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.spec.mapping.serializer;

import eu.optique.r2rml.api.binding.rdf4j.RDF4JR2RMLMappingManager;
import eu.optique.r2rml.api.model.TriplesMap;
import it.unibz.inf.ontop.com.google.common.collect.ArrayListMultimap;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableList;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableSet;
import it.unibz.inf.ontop.model.term.ImmutableFunctionalTerm;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.spec.mapping.PrefixManager;
import it.unibz.inf.ontop.spec.mapping.TargetAtom;
import it.unibz.inf.ontop.spec.mapping.pp.SQLPPMapping;
import it.unibz.inf.ontop.spec.mapping.pp.SQLPPTriplesMap;
import it.unibz.inf.ontop.spec.mapping.serializer.OBDAMappingTransformer;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.rdf.api.RDF;
import org.apache.commons.rdf.rdf4j.RDF4JGraph;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Namespace;
import org.eclipse.rdf4j.model.impl.SimpleNamespace;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.Rio;
import org.eclipse.rdf4j.rio.WriterConfig;
import org.eclipse.rdf4j.rio.helpers.BasicWriterSettings;

public class SQLPPMappingToR2RMLConverter {
    private final List<SQLPPTriplesMap> ppMappingAxioms;
    private final PrefixManager prefixManager;
    private final RDF rdfFactory;
    private final TermFactory termFactory;

    public SQLPPMappingToR2RMLConverter(SQLPPMapping ppMapping, RDF rdfFactory, TermFactory termFactory) {
        this.ppMappingAxioms = ppMapping.getTripleMaps();
        this.prefixManager = ppMapping.getPrefixManager();
        this.rdfFactory = rdfFactory;
        this.termFactory = termFactory;
    }

    public Collection<TriplesMap> getTripleMaps() {
        OBDAMappingTransformer transformer = new OBDAMappingTransformer(this.rdfFactory, this.termFactory);
        return this.splitMappingAxioms(this.ppMappingAxioms).stream().flatMap(a -> transformer.getTriplesMaps((SQLPPTriplesMap)a, this.prefixManager)).collect(Collectors.toList());
    }

    private ImmutableSet<SQLPPTriplesMap> splitMappingAxioms(List<SQLPPTriplesMap> mappingAxioms) {
        String delimiterSubstring = this.getSplitMappingAxiomIdDelimiterSubstring(mappingAxioms);
        return (ImmutableSet)mappingAxioms.stream().flatMap(m -> this.splitMappingAxiom((SQLPPTriplesMap)m, delimiterSubstring).stream()).collect(ImmutableCollectors.toSet());
    }

    private String getSplitMappingAxiomIdDelimiterSubstring(List<SQLPPTriplesMap> mappingAxioms) {
        Pattern pattern;
        boolean matched;
        String delimiterSubstring = "";
        do {
            delimiterSubstring = delimiterSubstring + "_";
            pattern = Pattern.compile(delimiterSubstring + "(\\d)*$");
        } while (matched = mappingAxioms.stream().anyMatch(a -> pattern.matcher(a.getId()).matches()));
        return delimiterSubstring;
    }

    private ImmutableList<SQLPPTriplesMap> splitMappingAxiom(SQLPPTriplesMap mappingAxiom, String delimiterSubstring) {
        ArrayListMultimap subjectTermToTargetTriples = ArrayListMultimap.create();
        for (TargetAtom targetTriple : mappingAxiom.getTargetAtoms()) {
            ImmutableFunctionalTerm subjectTerm = this.getFirstFunctionalTerm(targetTriple).orElseThrow(() -> new IllegalStateException("Invalid OBDA mapping"));
            subjectTermToTargetTriples.put((Object)subjectTerm, (Object)targetTriple);
        }
        if (subjectTermToTargetTriples.size() > 1) {
            HashMap<ImmutableFunctionalTerm, String> subjectTermToMappingIndex = new HashMap<ImmutableFunctionalTerm, String>();
            int i = 1;
            for (ImmutableFunctionalTerm subjectTerm : subjectTermToTargetTriples.keySet()) {
                subjectTermToMappingIndex.put(subjectTerm, mappingAxiom.getId() + delimiterSubstring + i);
                ++i;
            }
            return (ImmutableList)subjectTermToTargetTriples.asMap().entrySet().stream().map(e -> mappingAxiom.extractPPMappingAssertions((String)subjectTermToMappingIndex.get(e.getKey()), ImmutableList.copyOf((Collection)((Collection)e.getValue())))).collect(ImmutableCollectors.toList());
        }
        return ImmutableList.of((Object)mappingAxiom);
    }

    private Optional<ImmutableFunctionalTerm> getFirstFunctionalTerm(TargetAtom targetAtom) {
        return targetAtom.getSubstitution().getImmutableMap().values().stream().findFirst().filter(t -> t instanceof ImmutableFunctionalTerm).map(t -> (ImmutableFunctionalTerm)t);
    }

    public void write(File file) throws Exception {
        try {
            FileOutputStream fos = new FileOutputStream(file);
            this.write(fos);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    public void write(OutputStream os) throws Exception {
        Collection<TriplesMap> tripleMaps = this.getTripleMaps();
        try {
            RDF4JR2RMLMappingManager mm = RDF4JR2RMLMappingManager.getInstance();
            RDF4JGraph rdf4JGraph = mm.exportMappings(tripleMaps);
            Model m = (Model)rdf4JGraph.asModel().get();
            m.setNamespace("rr", "http://www.w3.org/ns/r2rml#");
            this.prefixManager.getPrefixMap().forEach((key, value) -> m.setNamespace((Namespace)new SimpleNamespace(key.substring(0, key.length() - 1), value)));
            WriterConfig settings = new WriterConfig();
            settings.set(BasicWriterSettings.PRETTY_PRINT, (Object)true);
            settings.set(BasicWriterSettings.INLINE_BLANK_NODES, (Object)true);
            Rio.write((Iterable)m, (OutputStream)os, (RDFFormat)RDFFormat.TURTLE, (WriterConfig)settings);
            os.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }
}

