/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.spec.mapping.parser.impl;

import com.google.inject.Inject;
import eu.optique.r2rml.api.binding.rdf4j.RDF4JR2RMLMappingManager;
import eu.optique.r2rml.api.model.GraphMap;
import eu.optique.r2rml.api.model.ObjectMap;
import eu.optique.r2rml.api.model.PredicateObjectMap;
import eu.optique.r2rml.api.model.SubjectMap;
import eu.optique.r2rml.api.model.Template;
import eu.optique.r2rml.api.model.TermMap;
import eu.optique.r2rml.api.model.TriplesMap;
import eu.optique.r2rml.api.model.impl.InvalidR2RMLMappingException;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableList;
import it.unibz.inf.ontop.exception.OntopInternalBugException;
import it.unibz.inf.ontop.model.term.ImmutableFunctionalTerm;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.NonVariableTerm;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.functionsymbol.FunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.DBFunctionSymbolFactory;
import it.unibz.inf.ontop.model.type.RDFDatatype;
import it.unibz.inf.ontop.model.type.RDFTermType;
import it.unibz.inf.ontop.model.type.TypeFactory;
import it.unibz.inf.ontop.spec.mapping.parser.impl.R2RMLVocabulary;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.commons.rdf.api.Graph;
import org.apache.commons.rdf.api.IRI;
import org.apache.commons.rdf.api.Literal;
import org.apache.commons.rdf.api.RDF;
import org.apache.commons.rdf.api.RDFTerm;

public class R2RMLParser {
    private final RDF4JR2RMLMappingManager manager;
    private final TermFactory termFactory;
    private final TypeFactory typeFactory;
    private final RDF rdfFactory;
    private final DBFunctionSymbolFactory dbFunctionSymbolFactory;

    @Inject
    private R2RMLParser(TermFactory termFactory, TypeFactory typeFactory, RDF rdfFactory, DBFunctionSymbolFactory dbFunctionSymbolFactory) {
        this.termFactory = termFactory;
        this.typeFactory = typeFactory;
        this.dbFunctionSymbolFactory = dbFunctionSymbolFactory;
        this.manager = RDF4JR2RMLMappingManager.getInstance();
        this.rdfFactory = rdfFactory;
    }

    public Collection<TriplesMap> extractTripleMaps(Graph myGraph) throws InvalidR2RMLMappingException {
        return this.manager.importMappings(myGraph);
    }

    public String extractSQLQuery(TriplesMap tm) {
        return tm.getLogicalTable().getSQLQuery();
    }

    public Stream<IRI> extractClassIRIs(SubjectMap subjectMap) {
        return subjectMap.getClasses().stream();
    }

    public ImmutableList<NonVariableTerm> extractGraphTerms(List<GraphMap> graphMaps) {
        for (GraphMap graphMap : graphMaps) {
            if (graphMap.getTermType().equals((Object)R2RMLVocabulary.iri)) continue;
            throw new R2RMLParsingBugException("The graph map must be an IRI, not " + graphMap.getTermType());
        }
        return (ImmutableList)graphMaps.stream().map(this::extractIRIorBnodeTerm).collect(ImmutableCollectors.toList());
    }

    public ImmutableTerm extractSubjectTerm(SubjectMap subjectMap) {
        return this.extractIRIorBnodeTerm((TermMap)subjectMap);
    }

    public ImmutableList<NonVariableTerm> extractPredicateTerms(PredicateObjectMap pom) {
        return (ImmutableList)pom.getPredicateMaps().stream().map(this::extractIRITerm).collect(ImmutableCollectors.toList());
    }

    private NonVariableTerm extractIRITerm(TermMap termMap) {
        if (!termMap.getTermType().equals((Object)R2RMLVocabulary.iri)) {
            throw new R2RMLParsingBugException("The term map must be an IRI, not " + termMap.getTermType());
        }
        return this.extractIRIorBnodeTerm(termMap);
    }

    private NonVariableTerm extractIRIorBnodeTerm(TermMap termMap) {
        IRI termTypeIRI = termMap.getTermType();
        boolean isIRI = termTypeIRI.equals((Object)R2RMLVocabulary.iri);
        if (!isIRI && !termTypeIRI.equals((Object)R2RMLVocabulary.blankNode)) {
            throw new R2RMLParsingBugException("Was expecting an IRI or a blank node, not a " + termTypeIRI);
        }
        RDFTerm constant = termMap.getConstant();
        if (constant != null) {
            if (!isIRI) {
                throw new R2RMLParsingBugException("Constant blank nodes are not accepted in R2RML (should have been detected earlier)");
            }
            return this.termFactory.getConstantIRI(this.rdfFactory.createIRI(constant.toString()));
        }
        return (NonVariableTerm)Optional.ofNullable(termMap.getTemplate()).map(Object::toString).map(s -> isIRI ? this.extractTemplateLexicalTerm((String)s, RDFCategory.IRI) : this.extractTemplateLexicalTerm((String)s, RDFCategory.BNODE)).map(l -> this.termFactory.getRDFFunctionalTerm((ImmutableTerm)l, (ImmutableTerm)this.termFactory.getRDFTermTypeConstant((RDFTermType)(isIRI ? this.typeFactory.getIRITermType() : this.typeFactory.getBlankNodeType())))).orElseGet(() -> Optional.ofNullable(termMap.getColumn()).map(this::getVariable).map(lex -> this.termFactory.getRDFFunctionalTerm((ImmutableTerm)lex, (ImmutableTerm)this.termFactory.getRDFTermTypeConstant((RDFTermType)(isIRI ? this.typeFactory.getIRITermType() : this.typeFactory.getBlankNodeType())))).orElseThrow(() -> new R2RMLParsingBugException("A term map is either constant-valued, column-valued or template-valued.")));
    }

    public ImmutableList<NonVariableTerm> extractRegularObjectTerms(PredicateObjectMap pom) {
        ImmutableList.Builder termListBuilder = ImmutableList.builder();
        for (ObjectMap om : pom.getObjectMaps()) {
            termListBuilder.add((Object)this.extractRegularObjectTerm(om));
        }
        return termListBuilder.build();
    }

    private NonVariableTerm extractRegularObjectTerm(ObjectMap om) {
        return om.getTermType().equals((Object)R2RMLVocabulary.literal) ? this.extractLiteral(om) : this.extractIRIorBnodeTerm((TermMap)om);
    }

    private NonVariableTerm extractLiteral(ObjectMap om) {
        NonVariableTerm lexicalTerm = this.extractLiteralLexicalTerm(om);
        RDFDatatype datatype = Optional.ofNullable(om.getLanguageTag()).filter(tag -> !tag.isEmpty()).map(arg_0 -> ((TypeFactory)this.typeFactory).getLangTermType(arg_0)).orElseGet(() -> Optional.ofNullable(om.getDatatype()).map(arg_0 -> ((TypeFactory)this.typeFactory).getDatatype(arg_0)).orElseGet(() -> Optional.ofNullable(om.getConstant()).map(c -> (Literal)c).map(Literal::getDatatype).map(arg_0 -> ((TypeFactory)this.typeFactory).getDatatype(arg_0)).orElseGet(() -> ((TypeFactory)this.typeFactory).getAbstractRDFSLiteral())));
        return (NonVariableTerm)this.termFactory.getRDFLiteralFunctionalTerm((ImmutableTerm)lexicalTerm, datatype).simplify();
    }

    private NonVariableTerm extractLiteralLexicalTerm(ObjectMap om) {
        RDFTerm constantObj = om.getConstant();
        if (constantObj != null) {
            if (constantObj instanceof Literal) {
                return this.termFactory.getDBStringConstant(((Literal)constantObj).getLexicalForm());
            }
            throw new R2RMLParsingBugException("Was expecting a Literal as constant, not a " + constantObj.getClass());
        }
        String col = om.getColumn();
        if (col != null) {
            return this.getVariable(col);
        }
        Template t = om.getTemplate();
        if (t != null) {
            return this.extractTemplateLexicalTerm(t.toString(), RDFCategory.LITERAL);
        }
        throw new R2RMLParsingBugException("Was expecting a Constant/Column/Template");
    }

    private NonVariableTerm extractTemplateLexicalTerm(String templateString, RDFCategory type) {
        String string = templateString;
        if (!templateString.contains("{")) {
            return this.termFactory.getDBStringConstant(templateString);
        }
        if (type == RDFCategory.IRI) {
            string = R2RMLVocabulary.prefixUri(templateString);
        }
        String suffix = string;
        string = string.replace("\\{", "[");
        string = string.replace("\\}", "]");
        ImmutableList.Builder termListBuilder = ImmutableList.builder();
        while (string.contains("{")) {
            if (type == RDFCategory.LITERAL) {
                int i = suffix.indexOf("{");
                int j = suffix.indexOf("\\{");
                while (i - 1 == j && j != -1) {
                    i = suffix.indexOf("{", i + 1);
                    j = suffix.indexOf("\\{", j + 1);
                }
                if (i > 0) {
                    String cons = suffix.substring(0, i);
                    termListBuilder.add((Object)this.termFactory.getDBStringConstant(cons));
                    suffix = suffix.substring(suffix.indexOf("}", i) + 1);
                } else {
                    suffix = suffix.substring(suffix.indexOf("}") + 1);
                }
            }
            int end = string.indexOf("}");
            int begin = string.lastIndexOf("{", end);
            String var = string.substring(begin + 1, end);
            termListBuilder.add((Object)this.getVariable(var));
            string = string.substring(0, begin) + "[]" + string.substring(end + 1);
        }
        if (type == RDFCategory.LITERAL && !suffix.isEmpty()) {
            termListBuilder.add((Object)this.termFactory.getDBStringConstant(suffix));
        }
        string = string.replace("[", "{");
        string = string.replace("]", "}");
        ImmutableList terms = termListBuilder.build();
        switch (type) {
            case IRI: {
                return this.termFactory.getImmutableFunctionalTerm((FunctionSymbol)this.dbFunctionSymbolFactory.getIRIStringTemplateFunctionSymbol(string), terms);
            }
            case BNODE: {
                return this.termFactory.getImmutableFunctionalTerm((FunctionSymbol)this.dbFunctionSymbolFactory.getBnodeStringTemplateFunctionSymbol(string), terms);
            }
            case LITERAL: {
                switch (terms.size()) {
                    case 0: {
                        return this.termFactory.getDBStringConstant("");
                    }
                    case 1: {
                        return (NonVariableTerm)terms.get(0);
                    }
                }
                return this.termFactory.getNullRejectingDBConcatFunctionalTerm(terms);
            }
        }
        throw new R2RMLParsingBugException("Unexpected type code: " + (Object)((Object)type));
    }

    private ImmutableFunctionalTerm getVariable(String variableName) {
        return this.termFactory.getPartiallyDefinedToStringCast(this.termFactory.getVariable(variableName));
    }

    private static enum RDFCategory {
        IRI,
        BNODE,
        LITERAL;

    }

    private static class R2RMLParsingBugException
    extends OntopInternalBugException {
        protected R2RMLParsingBugException(String message) {
            super(message);
        }
    }
}

