/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.spec.mapping.parser.impl;

import com.google.inject.Inject;
import eu.optique.r2rml.api.model.PredicateObjectMap;
import eu.optique.r2rml.api.model.RefObjectMap;
import eu.optique.r2rml.api.model.SubjectMap;
import eu.optique.r2rml.api.model.TriplesMap;
import eu.optique.r2rml.api.model.impl.InvalidR2RMLMappingException;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableList;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableMap;
import it.unibz.inf.ontop.com.google.common.collect.Lists;
import it.unibz.inf.ontop.exception.InvalidMappingException;
import it.unibz.inf.ontop.exception.MappingIOException;
import it.unibz.inf.ontop.exception.MinorOntopInternalBugException;
import it.unibz.inf.ontop.injection.SQLPPMappingFactory;
import it.unibz.inf.ontop.injection.SpecificationFactory;
import it.unibz.inf.ontop.model.term.IRIConstant;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.NonVariableTerm;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.spec.mapping.PrefixManager;
import it.unibz.inf.ontop.spec.mapping.SQLPPSourceQueryFactory;
import it.unibz.inf.ontop.spec.mapping.TargetAtom;
import it.unibz.inf.ontop.spec.mapping.TargetAtomFactory;
import it.unibz.inf.ontop.spec.mapping.parser.SQLMappingParser;
import it.unibz.inf.ontop.spec.mapping.parser.impl.R2RMLParser;
import it.unibz.inf.ontop.spec.mapping.parser.impl.R2RMLVocabulary;
import it.unibz.inf.ontop.spec.mapping.pp.SQLPPMapping;
import it.unibz.inf.ontop.spec.mapping.pp.SQLPPTriplesMap;
import it.unibz.inf.ontop.spec.mapping.pp.impl.R2RMLSQLPPtriplesMap;
import it.unibz.inf.ontop.substitution.SubstitutionFactory;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.rdf.api.Graph;
import org.apache.commons.rdf.rdf4j.RDF4J;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.impl.LinkedHashModel;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFHandler;
import org.eclipse.rdf4j.rio.RDFHandlerException;
import org.eclipse.rdf4j.rio.RDFParseException;
import org.eclipse.rdf4j.rio.RDFParser;
import org.eclipse.rdf4j.rio.Rio;
import org.eclipse.rdf4j.rio.helpers.StatementCollector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class R2RMLMappingParser
implements SQLMappingParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(R2RMLMappingParser.class);
    private final SQLPPMappingFactory ppMappingFactory;
    private final SpecificationFactory specificationFactory;
    private final TargetAtomFactory targetAtomFactory;
    private final R2RMLParser r2rmlParser;
    private final SQLPPSourceQueryFactory sourceQueryFactory;
    private final TermFactory termFactory;
    private final SubstitutionFactory substitutionFactory;

    @Inject
    private R2RMLMappingParser(SQLPPMappingFactory ppMappingFactory, SpecificationFactory specificationFactory, TargetAtomFactory targetAtomFactory, R2RMLParser r2rmlParser, SQLPPSourceQueryFactory sourceQueryFactory, TermFactory termFactory, SubstitutionFactory substitutionFactory) {
        this.ppMappingFactory = ppMappingFactory;
        this.specificationFactory = specificationFactory;
        this.targetAtomFactory = targetAtomFactory;
        this.r2rmlParser = r2rmlParser;
        this.sourceQueryFactory = sourceQueryFactory;
        this.termFactory = termFactory;
        this.substitutionFactory = substitutionFactory;
    }

    public SQLPPMapping parse(File mappingFile) throws InvalidMappingException, MappingIOException {
        try {
            LinkedHashModel rdf4jGraph = new LinkedHashModel();
            RDFParser parser = Rio.createParser((RDFFormat)RDFFormat.TURTLE);
            FileInputStream in = new FileInputStream(mappingFile);
            URL documentUrl = new URL("file://" + mappingFile);
            StatementCollector collector = new StatementCollector((Collection)rdf4jGraph);
            parser.setRDFHandler((RDFHandler)collector);
            parser.parse((InputStream)in, documentUrl.toString());
            return this.parse((Graph)new RDF4J().asGraph((Model)rdf4jGraph));
        }
        catch (IOException e) {
            throw new MappingIOException((Exception)e);
        }
        catch (RDFHandlerException | RDFParseException e) {
            throw new InvalidMappingException(e.getMessage());
        }
    }

    public SQLPPMapping parse(Reader reader) {
        throw new UnsupportedOperationException("The R2RMLMappingParser does not supportyet the Reader interface.");
    }

    public SQLPPMapping parse(Graph mappingGraph) throws InvalidMappingException {
        try {
            ImmutableList<SQLPPTriplesMap> sourceMappings = this.extractPPTriplesMaps(mappingGraph);
            PrefixManager prefixManager = this.specificationFactory.createPrefixManager(ImmutableMap.of());
            return this.ppMappingFactory.createSQLPreProcessedMapping(sourceMappings, prefixManager);
        }
        catch (InvalidR2RMLMappingException e) {
            throw new InvalidMappingException(e.getMessage());
        }
    }

    private ImmutableList<SQLPPTriplesMap> extractPPTriplesMaps(Graph mappingGraph) throws InvalidR2RMLMappingException {
        Collection<TriplesMap> tripleMaps = this.r2rmlParser.extractTripleMaps(mappingGraph);
        HashMap regularMap = new HashMap();
        for (TriplesMap tm : tripleMaps) {
            this.extractPPTriplesMap(tm).ifPresent(m -> regularMap.put(tm, m));
        }
        ImmutableMap subjectTermMap = (ImmutableMap)regularMap.entrySet().stream().collect(ImmutableCollectors.toMap(Map.Entry::getKey, e -> this.extractSubjectTerm((SQLPPTriplesMap)e.getValue())));
        ArrayList ppTriplesMaps = Lists.newArrayList();
        ppTriplesMaps.addAll(regularMap.values());
        for (TriplesMap tm : tripleMaps) {
            ppTriplesMaps.addAll(this.extractJoinPPTriplesMaps(tm, (ImmutableMap<TriplesMap, ImmutableTerm>)subjectTermMap));
        }
        return ImmutableList.copyOf((Collection)ppTriplesMaps);
    }

    private ImmutableTerm extractSubjectTerm(SQLPPTriplesMap sqlppTriplesMap) {
        return sqlppTriplesMap.getTargetAtoms().stream().map(a -> a.getSubstitutedTerm(0)).findAny().orElseThrow(() -> new MinorOntopInternalBugException("All created SQLPPTriplesMaps must have at least one target atom"));
    }

    private Optional<SQLPPTriplesMap> extractPPTriplesMap(TriplesMap tm) throws InvalidR2RMLMappingException {
        String sourceQuery = this.r2rmlParser.extractSQLQuery(tm).trim();
        ImmutableList<TargetAtom> targetAtoms = this.extractMappingTargetAtoms(tm);
        if (targetAtoms.isEmpty()) {
            LOGGER.warn("WARNING a triples map without target query will not be introduced : " + tm);
        }
        return Optional.of(targetAtoms).filter(as -> !as.isEmpty()).map(as -> new R2RMLSQLPPtriplesMap("mapping-" + tm.hashCode(), this.sourceQueryFactory.createSourceQuery(sourceQuery), as));
    }

    private ImmutableList<TargetAtom> extractMappingTargetAtoms(TriplesMap tm) {
        ImmutableList.Builder targetAtoms = ImmutableList.builder();
        SubjectMap subjectMap = tm.getSubjectMap();
        ImmutableTerm subjectTerm = this.r2rmlParser.extractSubjectTerm(subjectMap);
        ImmutableList<NonVariableTerm> graphTerms = this.r2rmlParser.extractGraphTerms(subjectMap.getGraphMaps());
        boolean includeDefaultGraph = graphTerms.isEmpty() || graphTerms.stream().anyMatch(R2RMLMappingParser::isDefaultGraph);
        ImmutableList namedGraphTerms = (ImmutableList)graphTerms.stream().filter(t -> !R2RMLMappingParser.isDefaultGraph((ImmutableTerm)t)).collect(ImmutableCollectors.toList());
        this.r2rmlParser.extractClassIRIs(subjectMap).flatMap(i -> {
            Stream<TargetAtom> quads = namedGraphTerms.stream().map(g -> this.targetAtomFactory.getQuadTargetAtom(subjectTerm, i, (ImmutableTerm)g));
            return includeDefaultGraph ? Stream.concat(Stream.of(this.targetAtomFactory.getTripleTargetAtom(subjectTerm, i)), quads) : quads;
        }).forEach(arg_0 -> ((ImmutableList.Builder)targetAtoms).add(arg_0));
        for (PredicateObjectMap pom : tm.getPredicateObjectMaps()) {
            ImmutableList<NonVariableTerm> predicateTerms = this.r2rmlParser.extractPredicateTerms(pom);
            for (ImmutableTerm objectTerm : this.r2rmlParser.extractRegularObjectTerms(pom)) {
                for (NonVariableTerm predicateTerm : predicateTerms) {
                    if (includeDefaultGraph) {
                        targetAtoms.add((Object)this.targetAtomFactory.getTripleTargetAtom(subjectTerm, (ImmutableTerm)predicateTerm, objectTerm));
                    }
                    for (NonVariableTerm graphTerm : namedGraphTerms) {
                        targetAtoms.add((Object)this.targetAtomFactory.getQuadTargetAtom(subjectTerm, (ImmutableTerm)predicateTerm, objectTerm, (ImmutableTerm)graphTerm));
                    }
                }
            }
        }
        return targetAtoms.build();
    }

    private static boolean isDefaultGraph(ImmutableTerm graphTerm) {
        return graphTerm instanceof IRIConstant && ((IRIConstant)graphTerm).getIRI().equals((Object)R2RMLVocabulary.defaultGraph);
    }

    private List<SQLPPTriplesMap> extractJoinPPTriplesMaps(TriplesMap tm, ImmutableMap<TriplesMap, ImmutableTerm> subjectTermMap) {
        ImmutableList.Builder joinPPTriplesMapsBuilder = ImmutableList.builder();
        for (PredicateObjectMap pobm : tm.getPredicateObjectMaps()) {
            List refObjectMaps = pobm.getRefObjectMaps();
            if (refObjectMaps.isEmpty()) continue;
            ImmutableList<NonVariableTerm> predicateTerms = this.r2rmlParser.extractPredicateTerms(pobm);
            SubjectMap subjectMap = tm.getSubjectMap();
            ImmutableList graphTerms = (ImmutableList)Stream.concat(this.r2rmlParser.extractGraphTerms(pobm.getGraphMaps()).stream(), this.r2rmlParser.extractGraphTerms(subjectMap.getGraphMaps()).stream()).distinct().collect(ImmutableCollectors.toList());
            boolean includeDefaultGraph = graphTerms.isEmpty() || graphTerms.stream().anyMatch(R2RMLMappingParser::isDefaultGraph);
            ImmutableList namedGraphTerms = (ImmutableList)graphTerms.stream().filter(t -> !R2RMLMappingParser.isDefaultGraph((ImmutableTerm)t)).collect(ImmutableCollectors.toList());
            for (RefObjectMap robm : refObjectMaps) {
                TriplesMap parent = robm.getParentMap();
                if (robm.getJoinConditions().isEmpty() && !parent.getLogicalTable().getSQLQuery().equals(tm.getLogicalTable().getSQLQuery())) {
                    throw new IllegalArgumentException("No rr:joinCondition, but the two SQL queries are disitnct: " + tm.getLogicalTable().getSQLQuery() + " and " + parent.getLogicalTable().getSQLQuery());
                }
                ImmutableTerm childSubject = Optional.ofNullable(subjectTermMap.get((Object)tm)).orElseGet(() -> this.r2rmlParser.extractSubjectTerm(tm.getSubjectMap()));
                String childPrefix = robm.getJoinConditions().isEmpty() ? "TMP" : "CHILD";
                ImmutableMap childMap = (ImmutableMap)childSubject.getVariableStream().collect(ImmutableCollectors.toMap(Function.identity(), v -> this.prefixAttributeName(childPrefix + "_", (Variable)v)));
                ImmutableTerm childSubject2 = this.substitutionFactory.getVar2VarSubstitution(childMap).apply(childSubject);
                ImmutableTerm parentSubject = Optional.ofNullable(subjectTermMap.get((Object)parent)).orElseGet(() -> this.r2rmlParser.extractSubjectTerm(parent.getSubjectMap()));
                String parentPrefix = robm.getJoinConditions().isEmpty() ? "TMP" : "PARENT";
                ImmutableMap parentMap = (ImmutableMap)parentSubject.getVariableStream().collect(ImmutableCollectors.toMap(Function.identity(), v -> this.prefixAttributeName(parentPrefix + "_", (Variable)v)));
                ImmutableTerm parentSubject2 = this.substitutionFactory.getVar2VarSubstitution(parentMap).apply(parentSubject);
                ImmutableList.Builder targetAtoms = ImmutableList.builder();
                for (NonVariableTerm predicateTerm : predicateTerms) {
                    if (includeDefaultGraph) {
                        targetAtoms.add((Object)this.targetAtomFactory.getTripleTargetAtom(childSubject2, (ImmutableTerm)predicateTerm, parentSubject2));
                    }
                    for (NonVariableTerm graphTerm : namedGraphTerms) {
                        targetAtoms.add((Object)this.targetAtomFactory.getQuadTargetAtom(childSubject2, (ImmutableTerm)predicateTerm, parentSubject2, (ImmutableTerm)graphTerm));
                    }
                }
                String sourceQuery = "SELECT " + Stream.concat(childMap.entrySet().stream().map(e -> childPrefix + "." + e.getKey() + " AS " + e.getValue()), parentMap.entrySet().stream().map(e -> parentPrefix + "." + e.getKey() + " AS " + e.getValue())).collect(Collectors.joining(", ")) + " FROM (" + tm.getLogicalTable().getSQLQuery() + ") " + childPrefix + (robm.getJoinConditions().isEmpty() ? "" : ", (" + parent.getLogicalTable().getSQLQuery() + ") " + parentPrefix + " WHERE " + robm.getJoinConditions().stream().map(j -> childPrefix + "." + j.getChild() + " = " + parentPrefix + "." + j.getParent()).collect(Collectors.joining(",")));
                R2RMLSQLPPtriplesMap ppTriplesMap = new R2RMLSQLPPtriplesMap("tm-join-" + robm.hashCode(), this.sourceQueryFactory.createSourceQuery(sourceQuery), targetAtoms.build());
                LOGGER.info("Join \"triples map\" introduced: " + ppTriplesMap);
                joinPPTriplesMapsBuilder.add((Object)ppTriplesMap);
            }
        }
        return joinPPTriplesMapsBuilder.build();
    }

    private Variable prefixAttributeName(String prefix, Variable var) {
        String attributeName = var.getName();
        String newAttributeName = attributeName.startsWith("\"") && attributeName.endsWith("\"") || attributeName.startsWith("`") && attributeName.endsWith("`") ? attributeName.substring(0, 1) + prefix + attributeName.substring(1) : prefix + attributeName;
        return this.termFactory.getVariable(newAttributeName);
    }
}

