/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.spec.mapping.serializer;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import eu.optique.r2rml.api.binding.jena.JenaR2RMLMappingManager;
import eu.optique.r2rml.api.model.TriplesMap;
import it.unibz.inf.ontop.model.term.ImmutableFunctionalTerm;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.spec.mapping.PrefixManager;
import it.unibz.inf.ontop.spec.mapping.TargetAtom;
import it.unibz.inf.ontop.spec.mapping.pp.SQLPPMapping;
import it.unibz.inf.ontop.spec.mapping.pp.SQLPPTriplesMap;
import it.unibz.inf.ontop.spec.mapping.serializer.OBDAMappingTransformer;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.rdf.api.RDF;
import org.apache.commons.rdf.jena.JenaGraph;
import org.apache.commons.rdf.jena.JenaRDF;
import org.apache.jena.graph.Graph;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFFormat;
import org.apache.jena.riot.RDFWriter;
import org.apache.jena.shared.PrefixMapping;

public class SQLPPMappingToR2RMLConverter {
    private final List<SQLPPTriplesMap> ppMappingAxioms;
    private final PrefixManager prefixManager;
    private final RDF rdfFactory;
    private final TermFactory termFactory;

    public SQLPPMappingToR2RMLConverter(SQLPPMapping ppMapping, RDF rdfFactory, TermFactory termFactory) {
        this.ppMappingAxioms = ppMapping.getTripleMaps();
        this.prefixManager = ppMapping.getPrefixManager();
        this.rdfFactory = rdfFactory;
        this.termFactory = termFactory;
    }

    public Collection<TriplesMap> getTripleMaps() {
        OBDAMappingTransformer transformer = new OBDAMappingTransformer(this.rdfFactory, this.termFactory);
        return this.splitMappingAxioms(this.ppMappingAxioms).stream().flatMap(a -> transformer.getTriplesMaps((SQLPPTriplesMap)a, this.prefixManager)).collect(Collectors.toList());
    }

    private ImmutableSet<SQLPPTriplesMap> splitMappingAxioms(List<SQLPPTriplesMap> mappingAxioms) {
        String delimiterSubstring = this.getSplitMappingAxiomIdDelimiterSubstring(mappingAxioms);
        return (ImmutableSet)mappingAxioms.stream().flatMap(m -> this.splitMappingAxiom((SQLPPTriplesMap)m, delimiterSubstring).stream()).collect(ImmutableCollectors.toSet());
    }

    private String getSplitMappingAxiomIdDelimiterSubstring(List<SQLPPTriplesMap> mappingAxioms) {
        Pattern pattern;
        boolean matched;
        String delimiterSubstring = "";
        do {
            delimiterSubstring = delimiterSubstring + "_";
            pattern = Pattern.compile(delimiterSubstring + "(\\d)*$");
        } while (matched = mappingAxioms.stream().anyMatch(a -> pattern.matcher(a.getId()).matches()));
        return delimiterSubstring;
    }

    private ImmutableList<SQLPPTriplesMap> splitMappingAxiom(SQLPPTriplesMap mappingAxiom, String delimiterSubstring) {
        ArrayListMultimap subjectTermToTargetTriples = ArrayListMultimap.create();
        for (TargetAtom targetTriple : mappingAxiom.getTargetAtoms()) {
            ImmutableFunctionalTerm subjectTerm = this.getFirstFunctionalTerm(targetTriple).orElseThrow(() -> new IllegalStateException("Invalid OBDA mapping"));
            subjectTermToTargetTriples.put((Object)subjectTerm, (Object)targetTriple);
        }
        if (subjectTermToTargetTriples.size() > 1) {
            HashMap<ImmutableFunctionalTerm, String> subjectTermToMappingIndex = new HashMap<ImmutableFunctionalTerm, String>();
            int i = 1;
            for (ImmutableFunctionalTerm subjectTerm : subjectTermToTargetTriples.keySet()) {
                subjectTermToMappingIndex.put(subjectTerm, mappingAxiom.getId() + delimiterSubstring + i);
                ++i;
            }
            return (ImmutableList)subjectTermToTargetTriples.asMap().entrySet().stream().map(e -> mappingAxiom.extractPPMappingAssertions((String)subjectTermToMappingIndex.get(e.getKey()), ImmutableList.copyOf((Collection)((Collection)e.getValue())))).collect(ImmutableCollectors.toList());
        }
        return ImmutableList.of((Object)mappingAxiom);
    }

    private Optional<ImmutableFunctionalTerm> getFirstFunctionalTerm(TargetAtom targetAtom) {
        return targetAtom.getSubstitution().getImmutableMap().values().stream().findFirst().filter(t -> t instanceof ImmutableFunctionalTerm).map(t -> (ImmutableFunctionalTerm)t);
    }

    public void write(File file) throws Exception {
        try {
            FileOutputStream fos = new FileOutputStream(file);
            this.write(fos);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    public void write(OutputStream os) throws Exception {
        try {
            JenaR2RMLMappingManager mm = JenaR2RMLMappingManager.getInstance();
            Collection<TriplesMap> tripleMaps = this.getTripleMaps();
            JenaGraph jenaGraph = mm.exportMappings(tripleMaps);
            Graph graph = new JenaRDF().asJenaGraph((org.apache.commons.rdf.api.Graph)jenaGraph);
            PrefixMapping jenaPrefixMapping = graph.getPrefixMapping();
            this.prefixManager.getPrefixMap().forEach((s, s1) -> jenaPrefixMapping.setNsPrefix(s.substring(0, s.length() - 1), s1));
            jenaPrefixMapping.setNsPrefix("rr", "http://www.w3.org/ns/r2rml#");
            RDFWriter.create().lang(Lang.TTL).format(RDFFormat.TURTLE_PRETTY).source(graph).output(os);
            os.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }
}

