/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.spec.mapping.serializer;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import eu.optique.r2rml.api.MappingFactory;
import eu.optique.r2rml.api.binding.rdf4j.RDF4JR2RMLMappingManager;
import eu.optique.r2rml.api.model.LogicalTable;
import eu.optique.r2rml.api.model.ObjectMap;
import eu.optique.r2rml.api.model.PredicateMap;
import eu.optique.r2rml.api.model.PredicateObjectMap;
import eu.optique.r2rml.api.model.R2RMLView;
import eu.optique.r2rml.api.model.SubjectMap;
import eu.optique.r2rml.api.model.Template;
import eu.optique.r2rml.api.model.TermMap;
import eu.optique.r2rml.api.model.TriplesMap;
import it.unibz.inf.ontop.exception.InvalidPrefixWritingException;
import it.unibz.inf.ontop.exception.MinorOntopInternalBugException;
import it.unibz.inf.ontop.exception.OntopInternalBugException;
import it.unibz.inf.ontop.model.atom.RDFAtomPredicate;
import it.unibz.inf.ontop.model.atom.TargetAtom;
import it.unibz.inf.ontop.model.term.DBConstant;
import it.unibz.inf.ontop.model.term.ImmutableFunctionalTerm;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.NonVariableTerm;
import it.unibz.inf.ontop.model.term.RDFConstant;
import it.unibz.inf.ontop.model.term.RDFTermTypeConstant;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.model.term.functionsymbol.FunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.RDFTermFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.BnodeStringTemplateFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.DBConcatFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.DBTypeConversionFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.IRIStringTemplateFunctionSymbol;
import it.unibz.inf.ontop.model.type.LanguageTag;
import it.unibz.inf.ontop.model.type.ObjectRDFType;
import it.unibz.inf.ontop.model.type.RDFDatatype;
import it.unibz.inf.ontop.model.type.RDFTermType;
import it.unibz.inf.ontop.model.vocabulary.RDFS;
import it.unibz.inf.ontop.spec.mapping.PrefixManager;
import it.unibz.inf.ontop.spec.mapping.impl.SQLQueryImpl;
import it.unibz.inf.ontop.spec.mapping.parser.impl.R2RMLVocabulary;
import it.unibz.inf.ontop.spec.mapping.pp.SQLPPTriplesMap;
import it.unibz.inf.ontop.spec.mapping.serializer.TargetQueryRenderer;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import it.unibz.inf.ontop.utils.Templates;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;
import org.apache.commons.rdf.api.BlankNode;
import org.apache.commons.rdf.api.BlankNodeOrIRI;
import org.apache.commons.rdf.api.IRI;
import org.apache.commons.rdf.api.Literal;
import org.apache.commons.rdf.api.RDF;

public class OBDAMappingTransformer {
    private final RDF rdfFactory;
    private final TermFactory termFactory;
    private String baseIRIString;
    private final MappingFactory mappingFactory;

    OBDAMappingTransformer(RDF rdfFactory, TermFactory termFactory) {
        this("urn:", rdfFactory, termFactory);
    }

    OBDAMappingTransformer(String baseIRIString, RDF rdfFactory, TermFactory termFactory) {
        this.baseIRIString = baseIRIString;
        this.rdfFactory = rdfFactory;
        this.termFactory = termFactory;
        this.mappingFactory = RDF4JR2RMLMappingManager.getInstance().getMappingFactory();
    }

    public Stream<TriplesMap> getTriplesMaps(SQLPPTriplesMap triplesMap, PrefixManager prefixManager) {
        SQLQueryImpl squery = (SQLQueryImpl)triplesMap.getSourceQuery();
        ImmutableList targetAtoms = triplesMap.getTargetAtoms();
        String mapping_id = triplesMap.getId();
        if (!mapping_id.contains(":")) {
            mapping_id = this.baseIRIString + mapping_id;
        }
        IRI mainNode = this.rdfFactory.createIRI(mapping_id);
        R2RMLView logicalTable = this.mappingFactory.createR2RMLView(squery.getSQLQuery());
        ImmutableMultimap targetAtomMultimap = (ImmutableMultimap)targetAtoms.stream().collect(ImmutableCollectors.toMultimap(a -> a.getSubstitutedTerm(0), a -> a));
        return targetAtomMultimap.asMap().entrySet().stream().map(arg_0 -> this.lambda$getTriplesMaps$2((LogicalTable)logicalTable, (BlankNodeOrIRI)mainNode, prefixManager, arg_0));
    }

    private TriplesMap extractTriplesMap(LogicalTable logicalTable, ImmutableTerm substitutedTerm, Collection<TargetAtom> targetAtoms, BlankNodeOrIRI mainNode, PrefixManager prefixManager) {
        SubjectMap sm = this.extractSubjectMap(substitutedTerm, prefixManager);
        TriplesMap tm = this.mappingFactory.createTriplesMap(logicalTable, sm, mainNode);
        ImmutableMap targetAtomClassification = (ImmutableMap)targetAtoms.stream().collect(ImmutableCollectors.partitioningBy(OBDAMappingTransformer::isConstantClassTargetAtom));
        Optional.ofNullable(targetAtomClassification.get((Object)true)).map(Collection::stream).orElse(Stream.empty()).map(this::extractClassIRIFromConstantClassTargetAtom).forEach(arg_0 -> ((SubjectMap)sm).addClass(arg_0));
        Optional.ofNullable(targetAtomClassification.get((Object)false)).map(Collection::stream).orElse(Stream.empty()).map(a -> this.convertIntoPredicateObjectMap((TargetAtom)a, prefixManager)).forEach(arg_0 -> ((TriplesMap)tm).addPredicateObjectMap(arg_0));
        return tm;
    }

    private static boolean isConstantClassTargetAtom(TargetAtom targetAtom) {
        return Optional.of(targetAtom.getProjectionAtom()).filter(a -> a.getPredicate() instanceof RDFAtomPredicate).flatMap(a -> ((RDFAtomPredicate)a.getPredicate()).getClassIRI(targetAtom.getSubstitutedTerms())).isPresent();
    }

    private IRI extractClassIRIFromConstantClassTargetAtom(TargetAtom targetAtom) {
        return (IRI)Optional.of(targetAtom.getProjectionAtom()).filter(a -> a.getPredicate() instanceof RDFAtomPredicate).flatMap(a -> ((RDFAtomPredicate)a.getPredicate()).getClassIRI(targetAtom.getSubstitutedTerms())).orElseThrow(() -> new IllegalArgumentException("The target atom is expected to have a constant class"));
    }

    private PredicateObjectMap convertIntoPredicateObjectMap(TargetAtom targetAtom, PrefixManager prefixManager) {
        return this.mappingFactory.createPredicateObjectMap(this.extractPredicateMap(targetAtom, prefixManager), this.extractObjectMap(targetAtom, prefixManager));
    }

    private SubjectMap extractSubjectMap(ImmutableTerm substitutedTerm, PrefixManager prefixManager) {
        return this.extractTermMap(substitutedTerm, true, false, arg_0 -> ((MappingFactory)this.mappingFactory).createSubjectMap(arg_0), arg_0 -> ((MappingFactory)this.mappingFactory).createSubjectMap(arg_0), arg_0 -> ((MappingFactory)this.mappingFactory).createSubjectMap(arg_0), l -> {
            throw new UnsupportedOperationException();
        }, l -> {
            throw new UnsupportedOperationException();
        }, prefixManager);
    }

    private PredicateMap extractPredicateMap(TargetAtom targetAtom, PrefixManager prefixManager) {
        return this.extractTermMap(targetAtom.getSubstitutedTerm(1), false, false, arg_0 -> ((MappingFactory)this.mappingFactory).createPredicateMap(arg_0), arg_0 -> ((MappingFactory)this.mappingFactory).createPredicateMap(arg_0), arg_0 -> ((MappingFactory)this.mappingFactory).createPredicateMap(arg_0), l -> {
            throw new UnsupportedOperationException();
        }, l -> {
            throw new UnsupportedOperationException();
        }, prefixManager);
    }

    private ObjectMap extractObjectMap(TargetAtom targetAtom, PrefixManager prefixManager) {
        return this.extractTermMap(targetAtom.getSubstitutedTerm(2), true, true, arg_0 -> ((MappingFactory)this.mappingFactory).createObjectMap(arg_0), arg_0 -> ((MappingFactory)this.mappingFactory).createObjectMap(arg_0), arg_0 -> ((MappingFactory)this.mappingFactory).createObjectMap(arg_0), arg_0 -> ((MappingFactory)this.mappingFactory).createObjectMap(arg_0), arg_0 -> ((MappingFactory)this.mappingFactory).createObjectMap(arg_0), prefixManager);
    }

    private <T extends TermMap> T extractTermMap(ImmutableTerm substitutedTerm, boolean acceptBNode, boolean acceptLiterals, Function<Template, T> templateFct, Function<String, T> columnFct, Function<IRI, T> iriFct, Function<BlankNode, T> bNodeFct, Function<Literal, T> literalFct, PrefixManager prefixManager) {
        ImmutableFunctionalTerm rdfFunctionalTerm = Optional.of(substitutedTerm).filter(t -> t instanceof ImmutableFunctionalTerm || t instanceof RDFConstant).map(t -> this.convertIntoRDFFunctionalTerm((NonVariableTerm)t)).filter(t -> t.getFunctionSymbol() instanceof RDFTermFunctionSymbol).orElseThrow(() -> new R2RMLSerializationException("Was expecting a RDFTerm functional or constant term, not " + substitutedTerm));
        ImmutableTerm lexicalTerm = this.uncast(rdfFunctionalTerm.getTerm(0));
        RDFTermType termType = Optional.of(rdfFunctionalTerm.getTerm(1)).filter(t -> t instanceof RDFTermTypeConstant).map(t -> (RDFTermTypeConstant)t).map(RDFTermTypeConstant::getRDFTermType).orElseThrow(() -> new R2RMLSerializationException("Was expecting a RDFTermTypeConstant in the mapping assertion, not " + rdfFunctionalTerm.getTerm(1)));
        if (termType instanceof ObjectRDFType) {
            return this.extractIriOrBnodeTermMap(lexicalTerm, (ObjectRDFType)termType, acceptBNode, templateFct, columnFct, iriFct, bNodeFct, prefixManager);
        }
        if (termType instanceof RDFDatatype) {
            if (acceptLiterals) {
                return this.extractLiteralTermMap(lexicalTerm, (RDFDatatype)termType, templateFct, columnFct, literalFct);
            }
            throw new MinorOntopInternalBugException("A literal term map has been found in an unexpected area: " + substitutedTerm);
        }
        throw new MinorOntopInternalBugException("An RDF termType must be either an object type or a datatype");
    }

    private ImmutableFunctionalTerm convertIntoRDFFunctionalTerm(NonVariableTerm term) {
        if (term instanceof RDFConstant) {
            RDFConstant constant = (RDFConstant)term;
            return this.termFactory.getRDFFunctionalTerm((ImmutableTerm)this.termFactory.getDBStringConstant(constant.getValue()), (ImmutableTerm)this.termFactory.getRDFTermTypeConstant(constant.getType()));
        }
        return (ImmutableFunctionalTerm)term;
    }

    private <T extends TermMap> T extractIriOrBnodeTermMap(ImmutableTerm lexicalTerm, ObjectRDFType termType, boolean acceptBNode, Function<Template, T> templateFct, Function<String, T> columnFct, Function<IRI, T> iriFct, Function<BlankNode, T> bNodeFct, PrefixManager prefixManager) {
        TermMap termMap;
        if (!acceptBNode && termType.isBlankNode()) {
            throw new MinorOntopInternalBugException("Bnode term map found in an unexpected area: " + lexicalTerm);
        }
        if (lexicalTerm instanceof DBConstant) {
            String lexicalString = ((DBConstant)lexicalTerm).getValue();
            termMap = termType.isBlankNode() ? (TermMap)bNodeFct.apply(this.rdfFactory.createBlankNode(lexicalString)) : (TermMap)iriFct.apply(this.rdfFactory.createIRI(lexicalString));
        } else if (lexicalTerm instanceof Variable) {
            termMap = (TermMap)columnFct.apply(((Variable)lexicalTerm).getName());
        } else if (lexicalTerm instanceof ImmutableFunctionalTerm) {
            String templateString = this.getTemplate((ImmutableFunctionalTerm)lexicalTerm, prefixManager);
            termMap = (TermMap)templateFct.apply(this.mappingFactory.createTemplate(templateString));
        } else {
            throw new MinorOntopInternalBugException("Unexpected lexical term for an IRI/Bnode: " + lexicalTerm);
        }
        termMap.setTermType(termType.isBlankNode() ? R2RMLVocabulary.blankNode : R2RMLVocabulary.iri);
        return (T)termMap;
    }

    private String getTemplate(ImmutableFunctionalTerm lexicalTerm, PrefixManager prefixManager) {
        FunctionSymbol functionSymbol = lexicalTerm.getFunctionSymbol();
        if (functionSymbol instanceof BnodeStringTemplateFunctionSymbol) {
            return "_:" + Templates.getTemplateString((ImmutableFunctionalTerm)lexicalTerm);
        }
        if (functionSymbol instanceof IRIStringTemplateFunctionSymbol) {
            return this.expandPrefix(Templates.getTemplateString((ImmutableFunctionalTerm)lexicalTerm), prefixManager);
        }
        if (functionSymbol instanceof DBConcatFunctionSymbol) {
            return Templates.getDBConcatTemplateString((ImmutableFunctionalTerm)lexicalTerm);
        }
        throw new R2RMLSerializationException("Unexpected function symbol " + functionSymbol + " in term " + lexicalTerm);
    }

    private String expandPrefix(String prefixedTemplate, PrefixManager prefixManager) {
        String expandedTemplate = prefixedTemplate;
        try {
            expandedTemplate = prefixManager.getExpandForm(prefixedTemplate);
        }
        catch (InvalidPrefixWritingException invalidPrefixWritingException) {
            // empty catch block
        }
        return expandedTemplate;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private <T extends TermMap> T extractLiteralTermMap(ImmutableTerm lexicalTerm, RDFDatatype datatype, Function<Template, T> templateFct, Function<String, T> columnFct, Function<Literal, T> literalFct) {
        TermMap termMap;
        if (lexicalTerm instanceof Variable) {
            termMap = (TermMap)columnFct.apply(((Variable)lexicalTerm).getName());
        } else if (lexicalTerm instanceof DBConstant) {
            String lexicalString = ((DBConstant)lexicalTerm).getValue();
            Literal literal = datatype.getLanguageTag().map(lang -> this.rdfFactory.createLiteral(lexicalString, lang.getFullString())).orElseGet(() -> this.rdfFactory.createLiteral(lexicalString, datatype.getIRI()));
            termMap = (TermMap)literalFct.apply(literal);
        } else {
            if (!(lexicalTerm instanceof ImmutableFunctionalTerm)) throw new MinorOntopInternalBugException("Unexpected lexical term for a literal: " + lexicalTerm);
            ImmutableFunctionalTerm functionalLexicalTerm = (ImmutableFunctionalTerm)lexicalTerm;
            FunctionSymbol functionSymbol = functionalLexicalTerm.getFunctionSymbol();
            if (!(functionSymbol instanceof DBConcatFunctionSymbol)) throw new R2RMLSerializationException("Unexpected function symbol: " + functionSymbol);
            termMap = (TermMap)templateFct.apply(this.mappingFactory.createTemplate(TargetQueryRenderer.displayConcat((ImmutableFunctionalTerm)functionalLexicalTerm)));
        }
        termMap.setTermType(R2RMLVocabulary.literal);
        if (!(termMap instanceof ObjectMap)) {
            throw new MinorOntopInternalBugException("The termMap was expected to be an ObjectMap");
        }
        ObjectMap objectMap = (ObjectMap)termMap;
        Optional optionalLangTag = datatype.getLanguageTag();
        if (optionalLangTag.isPresent()) {
            objectMap.setLanguageTag(((LanguageTag)optionalLangTag.get()).getFullString());
            return (T)termMap;
        } else {
            if (datatype.isAbstract() || this.isOntopInternalRDFLiteral(datatype, lexicalTerm)) return (T)termMap;
            objectMap.setDatatype(datatype.getIRI());
        }
        return (T)termMap;
    }

    private boolean isOntopInternalRDFLiteral(RDFDatatype datatype, ImmutableTerm lexicalTerm) {
        FunctionSymbol fs;
        if (!datatype.equals(RDFS.LITERAL)) {
            return false;
        }
        if (lexicalTerm instanceof Variable) {
            return true;
        }
        return lexicalTerm instanceof ImmutableFunctionalTerm && ((fs = ((ImmutableFunctionalTerm)lexicalTerm).getFunctionSymbol()) instanceof BnodeStringTemplateFunctionSymbol || fs instanceof IRIStringTemplateFunctionSymbol);
    }

    private ImmutableTerm uncast(ImmutableTerm lexicalTerm) {
        return Optional.of(lexicalTerm).filter(t -> t instanceof ImmutableFunctionalTerm).map(t -> (ImmutableFunctionalTerm)t).map(t -> this.uncastFunction((ImmutableFunctionalTerm)t)).orElse(lexicalTerm);
    }

    private ImmutableTerm uncastFunction(ImmutableFunctionalTerm fun) {
        ImmutableList unCastArgs = (ImmutableList)fun.getTerms().stream().map(t -> this.uncast((ImmutableTerm)t)).collect(ImmutableCollectors.toList());
        FunctionSymbol fs = fun.getFunctionSymbol();
        if (fs instanceof DBTypeConversionFunctionSymbol && ((DBTypeConversionFunctionSymbol)fs).isTemporary() && fs.getArity() == 1) {
            return (ImmutableTerm)unCastArgs.iterator().next();
        }
        return this.termFactory.getImmutableFunctionalTerm(fs, unCastArgs);
    }

    private /* synthetic */ TriplesMap lambda$getTriplesMaps$2(LogicalTable logicalTable, BlankNodeOrIRI mainNode, PrefixManager prefixManager, Map.Entry e) {
        return this.extractTriplesMap(logicalTable, (ImmutableTerm)e.getKey(), (Collection)e.getValue(), mainNode, prefixManager);
    }

    static class R2RMLSerializationException
    extends OntopInternalBugException {
        private R2RMLSerializationException(String message) {
            super(message);
        }
    }
}

