/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.spec.mapping.parser.impl;

import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import eu.optique.r2rml.api.binding.rdf4j.RDF4JR2RMLMappingManager;
import eu.optique.r2rml.api.model.ObjectMap;
import eu.optique.r2rml.api.model.PredicateObjectMap;
import eu.optique.r2rml.api.model.SubjectMap;
import eu.optique.r2rml.api.model.Template;
import eu.optique.r2rml.api.model.TermMap;
import eu.optique.r2rml.api.model.TriplesMap;
import eu.optique.r2rml.api.model.impl.InvalidR2RMLMappingException;
import it.unibz.inf.ontop.exception.OntopInternalBugException;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.NonVariableTerm;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.functionsymbol.FunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.DBFunctionSymbolFactory;
import it.unibz.inf.ontop.model.term.functionsymbol.db.IRIStringTemplateFunctionSymbol;
import it.unibz.inf.ontop.model.type.RDFDatatype;
import it.unibz.inf.ontop.model.type.RDFTermType;
import it.unibz.inf.ontop.model.type.TypeFactory;
import it.unibz.inf.ontop.spec.mapping.parser.impl.R2RMLVocabulary;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import java.util.Collection;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.commons.rdf.api.Graph;
import org.apache.commons.rdf.api.IRI;
import org.apache.commons.rdf.api.Literal;
import org.apache.commons.rdf.api.RDF;
import org.apache.commons.rdf.api.RDFTerm;

public class R2RMLParser {
    private final RDF4JR2RMLMappingManager manager;
    private final TermFactory termFactory;
    private final TypeFactory typeFactory;
    private final RDF rdfFactory;
    private final DBFunctionSymbolFactory dbFunctionSymbolFactory;

    @Inject
    private R2RMLParser(TermFactory termFactory, TypeFactory typeFactory, RDF rdfFactory, DBFunctionSymbolFactory dbFunctionSymbolFactory) {
        this.termFactory = termFactory;
        this.typeFactory = typeFactory;
        this.dbFunctionSymbolFactory = dbFunctionSymbolFactory;
        this.manager = RDF4JR2RMLMappingManager.getInstance();
        this.rdfFactory = rdfFactory;
    }

    public Collection<TriplesMap> extractTripleMaps(Graph myGraph) throws InvalidR2RMLMappingException {
        return this.manager.importMappings(myGraph);
    }

    public String extractSQLQuery(TriplesMap tm) {
        return tm.getLogicalTable().getSQLQuery();
    }

    public Stream<IRI> extractClassIRIs(SubjectMap subjectMap) {
        return subjectMap.getClasses().stream();
    }

    public ImmutableTerm extractSubjectTerm(SubjectMap subjectMap) {
        return this.extractSubjectTerm(subjectMap, "");
    }

    private ImmutableTerm extractSubjectTerm(SubjectMap subjectMap, String joinCond) {
        return this.extractIRIorBnodeTerm((TermMap)subjectMap, joinCond);
    }

    public ImmutableList<NonVariableTerm> extractPredicateTerms(PredicateObjectMap pom) {
        return (ImmutableList)pom.getPredicateMaps().stream().map(this::extractIRITerm).collect(ImmutableCollectors.toList());
    }

    private NonVariableTerm extractIRITerm(TermMap termMap) {
        if (!termMap.getTermType().equals((Object)R2RMLVocabulary.iri)) {
            throw new R2RMLParsingBugException("The term map must be an IRI, not " + termMap.getTermType());
        }
        return this.extractIRIorBnodeTerm(termMap, "");
    }

    private NonVariableTerm extractIRIorBnodeTerm(TermMap termMap, String joinCond) {
        IRI termTypeIRI = termMap.getTermType();
        boolean isIRI = termTypeIRI.equals((Object)R2RMLVocabulary.iri);
        if (!isIRI && !termTypeIRI.equals((Object)R2RMLVocabulary.blankNode)) {
            throw new R2RMLParsingBugException("Was expecting an IRI or a blank node, not a " + termTypeIRI);
        }
        RDFTerm constant = termMap.getConstant();
        if (constant != null) {
            if (!isIRI) {
                throw new R2RMLParsingBugException("Constant blank nodes are not accepted in R2RML (should have been detected earlier)");
            }
            return this.termFactory.getConstantIRI(this.rdfFactory.createIRI(constant.toString()));
        }
        return (NonVariableTerm)Optional.ofNullable(termMap.getTemplate()).map(Object::toString).map(s -> isIRI ? this.extractTemplateLexicalTerm((String)s, RDFCategory.IRI, joinCond) : this.extractTemplateLexicalTerm((String)s, RDFCategory.BNODE, joinCond)).map(l -> this.termFactory.getRDFFunctionalTerm((ImmutableTerm)l, (ImmutableTerm)this.termFactory.getRDFTermTypeConstant((RDFTermType)(isIRI ? this.typeFactory.getIRITermType() : this.typeFactory.getBlankNodeType())))).orElseGet(() -> Optional.ofNullable(termMap.getColumn()).map(column -> this.termFactory.getPartiallyDefinedToStringCast(this.termFactory.getVariable(column))).map(lex -> this.termFactory.getRDFFunctionalTerm((ImmutableTerm)lex, (ImmutableTerm)this.termFactory.getRDFTermTypeConstant((RDFTermType)(isIRI ? this.typeFactory.getIRITermType() : this.typeFactory.getBlankNodeType())))).orElseThrow(() -> new R2RMLParsingBugException("A term map is either constant-valued, column-valued or template-valued.")));
    }

    public ImmutableList<NonVariableTerm> extractRegularObjectTerms(PredicateObjectMap pom) {
        return this.extractRegularObjectTerms(pom, "");
    }

    private ImmutableList<NonVariableTerm> extractRegularObjectTerms(PredicateObjectMap pom, String joinCond) {
        ImmutableList.Builder termListBuilder = ImmutableList.builder();
        for (ObjectMap om : pom.getObjectMaps()) {
            termListBuilder.add((Object)this.extractRegularObjectTerm(om, joinCond));
        }
        return termListBuilder.build();
    }

    private NonVariableTerm extractRegularObjectTerm(ObjectMap om, String joinCond) {
        return om.getTermType().equals((Object)R2RMLVocabulary.literal) ? this.extractLiteral(om, joinCond) : this.extractIRIorBnodeTerm((TermMap)om, joinCond);
    }

    private NonVariableTerm extractLiteral(ObjectMap om, String joinCond) {
        NonVariableTerm lexicalTerm = this.extractLiteralLexicalTerm(om, joinCond);
        RDFDatatype datatype = Optional.ofNullable(om.getLanguageTag()).filter(tag -> !tag.isEmpty()).map(arg_0 -> ((TypeFactory)this.typeFactory).getLangTermType(arg_0)).orElseGet(() -> Optional.ofNullable(om.getDatatype()).map(arg_0 -> ((TypeFactory)this.typeFactory).getDatatype(arg_0)).orElseGet(() -> Optional.ofNullable(om.getConstant()).map(c -> (Literal)c).map(Literal::getDatatype).map(arg_0 -> ((TypeFactory)this.typeFactory).getDatatype(arg_0)).orElseGet(() -> ((TypeFactory)this.typeFactory).getAbstractRDFSLiteral())));
        return (NonVariableTerm)this.termFactory.getRDFLiteralFunctionalTerm((ImmutableTerm)lexicalTerm, datatype).simplify();
    }

    private NonVariableTerm extractLiteralLexicalTerm(ObjectMap om, String joinCond) {
        RDFTerm constantObj = om.getConstant();
        if (constantObj != null) {
            if (constantObj instanceof Literal) {
                return this.termFactory.getDBStringConstant(((Literal)constantObj).getLexicalForm());
            }
            throw new R2RMLParsingBugException("Was expecting a Literal as constant, not a " + constantObj.getClass());
        }
        String col = om.getColumn();
        if (col != null) {
            col = this.trim(col);
            if (!joinCond.isEmpty()) {
                col = joinCond + col;
            }
            return this.termFactory.getPartiallyDefinedToStringCast(this.termFactory.getVariable(col));
        }
        Template t = om.getTemplate();
        if (t != null) {
            return this.extractTemplateLexicalTerm(t.toString(), RDFCategory.LITERAL, joinCond);
        }
        throw new R2RMLParsingBugException("Was expecting a Constant/Column/Template");
    }

    private int getIndexOfCurlyB(String str) {
        int i = str.indexOf("{");
        int j = str.indexOf("\\{");
        while (i - 1 == j && j != -1) {
            i = str.indexOf("{", i + 1);
            j = str.indexOf("\\{", j + 1);
        }
        return i;
    }

    private NonVariableTerm extractTemplateLexicalTerm(String templateString, RDFCategory type, String joinCond) {
        String cons;
        String string = templateString;
        if (!string.contains("{")) {
            return this.termFactory.getDBStringConstant(templateString);
        }
        if (type == RDFCategory.IRI) {
            string = R2RMLVocabulary.prefixUri(string);
        }
        String str = string;
        string = string.replace("\\{", "[");
        string = string.replace("\\}", "]");
        ImmutableList.Builder termListBuilder = ImmutableList.builder();
        while (string.contains("{")) {
            int end = string.indexOf("}");
            int begin = string.lastIndexOf("{", end);
            if (type == RDFCategory.LITERAL) {
                int i = this.getIndexOfCurlyB(str);
                if (i > 0) {
                    cons = str.substring(0, i);
                    str = str.substring(str.indexOf("}", i) + 1);
                    termListBuilder.add((Object)this.termFactory.getDBStringConstant(cons));
                } else {
                    str = str.substring(str.indexOf("}") + 1);
                }
            }
            String var = this.trim(string.substring(begin + 1, end));
            termListBuilder.add((Object)this.termFactory.getPartiallyDefinedToStringCast(this.termFactory.getVariable(joinCond + var)));
            string = string.replaceFirst("\\{\"" + var + "\"\\}", "[]");
            string = string.replaceFirst("\\{" + var + "\\}", "[]");
        }
        if (type == RDFCategory.LITERAL && !str.equals("")) {
            cons = str;
            termListBuilder.add((Object)this.termFactory.getDBStringConstant(cons));
        }
        string = string.replace("[", "{");
        string = string.replace("]", "}");
        ImmutableList terms = termListBuilder.build();
        switch (type) {
            case IRI: {
                IRIStringTemplateFunctionSymbol templateFunctionSymbol = this.dbFunctionSymbolFactory.getIRIStringTemplateFunctionSymbol(string);
                return this.termFactory.getImmutableFunctionalTerm((FunctionSymbol)templateFunctionSymbol, terms);
            }
            case BNODE: {
                return this.termFactory.getImmutableFunctionalTerm((FunctionSymbol)this.dbFunctionSymbolFactory.getBnodeStringTemplateFunctionSymbol(string), terms);
            }
            case LITERAL: {
                switch (terms.size()) {
                    case 0: {
                        return this.termFactory.getDBStringConstant("");
                    }
                    case 1: {
                        return (NonVariableTerm)terms.get(0);
                    }
                }
                return this.termFactory.getNullRejectingDBConcatFunctionalTerm(terms);
            }
        }
        throw new R2RMLParsingBugException("Unexpected type code: " + (Object)((Object)type));
    }

    private String trim(String string) {
        while (string.startsWith("\"") && string.endsWith("\"")) {
            string = string.substring(1, string.length() - 1);
        }
        return string;
    }

    private static enum RDFCategory {
        IRI,
        BNODE,
        LITERAL;

    }

    private static class R2RMLParsingBugException
    extends OntopInternalBugException {
        protected R2RMLParsingBugException(String message) {
            super(message);
        }
    }
}

