/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.spec.mapping.parser.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import eu.optique.r2rml.api.model.PredicateObjectMap;
import eu.optique.r2rml.api.model.RefObjectMap;
import eu.optique.r2rml.api.model.SubjectMap;
import eu.optique.r2rml.api.model.TriplesMap;
import eu.optique.r2rml.api.model.impl.InvalidR2RMLMappingException;
import it.unibz.inf.ontop.exception.DuplicateMappingException;
import it.unibz.inf.ontop.exception.InvalidMappingException;
import it.unibz.inf.ontop.exception.MappingIOException;
import it.unibz.inf.ontop.exception.MinorOntopInternalBugException;
import it.unibz.inf.ontop.injection.SQLPPMappingFactory;
import it.unibz.inf.ontop.injection.SpecificationFactory;
import it.unibz.inf.ontop.model.atom.TargetAtom;
import it.unibz.inf.ontop.model.atom.TargetAtomFactory;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.NonVariableTerm;
import it.unibz.inf.ontop.spec.mapping.MappingMetadata;
import it.unibz.inf.ontop.spec.mapping.PrefixManager;
import it.unibz.inf.ontop.spec.mapping.SQLMappingFactory;
import it.unibz.inf.ontop.spec.mapping.impl.SQLMappingFactoryImpl;
import it.unibz.inf.ontop.spec.mapping.parser.SQLMappingParser;
import it.unibz.inf.ontop.spec.mapping.parser.impl.R2RMLParser;
import it.unibz.inf.ontop.spec.mapping.pp.SQLPPMapping;
import it.unibz.inf.ontop.spec.mapping.pp.SQLPPTriplesMap;
import it.unibz.inf.ontop.spec.mapping.pp.impl.OntopNativeSQLPPTriplesMap;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.rdf.api.Graph;
import org.apache.commons.rdf.rdf4j.RDF4J;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.impl.LinkedHashModel;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFHandler;
import org.eclipse.rdf4j.rio.RDFHandlerException;
import org.eclipse.rdf4j.rio.RDFParseException;
import org.eclipse.rdf4j.rio.RDFParser;
import org.eclipse.rdf4j.rio.Rio;
import org.eclipse.rdf4j.rio.helpers.StatementCollector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class R2RMLMappingParser
implements SQLMappingParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(R2RMLMappingParser.class);
    private static final SQLMappingFactory MAPPING_FACTORY = SQLMappingFactoryImpl.getInstance();
    private final SQLPPMappingFactory ppMappingFactory;
    private final SpecificationFactory specificationFactory;
    private final TargetAtomFactory targetAtomFactory;
    private final R2RMLParser r2rmlParser;

    @Inject
    private R2RMLMappingParser(SQLPPMappingFactory ppMappingFactory, SpecificationFactory specificationFactory, TargetAtomFactory targetAtomFactory, R2RMLParser r2rmlParser) {
        this.ppMappingFactory = ppMappingFactory;
        this.specificationFactory = specificationFactory;
        this.targetAtomFactory = targetAtomFactory;
        this.r2rmlParser = r2rmlParser;
    }

    public SQLPPMapping parse(File mappingFile) throws InvalidMappingException, MappingIOException, DuplicateMappingException {
        try {
            LinkedHashModel rdf4jGraph = new LinkedHashModel();
            RDFParser parser = Rio.createParser((RDFFormat)RDFFormat.TURTLE);
            FileInputStream in = new FileInputStream(mappingFile);
            URL documentUrl = new URL("file://" + mappingFile);
            StatementCollector collector = new StatementCollector((Collection)rdf4jGraph);
            parser.setRDFHandler((RDFHandler)collector);
            parser.parse((InputStream)in, documentUrl.toString());
            return this.parse((Graph)new RDF4J().asGraph((Model)rdf4jGraph));
        }
        catch (IOException e) {
            throw new MappingIOException((Exception)e);
        }
        catch (RDFHandlerException | RDFParseException e) {
            throw new InvalidMappingException(e.getMessage());
        }
    }

    public SQLPPMapping parse(Reader reader) throws InvalidMappingException, MappingIOException, DuplicateMappingException {
        throw new UnsupportedOperationException("The R2RMLMappingParser does not supportyet the Reader interface.");
    }

    public SQLPPMapping parse(Graph mappingGraph) throws InvalidMappingException, DuplicateMappingException {
        try {
            ImmutableList<SQLPPTriplesMap> sourceMappings = this.extractPPTriplesMaps(mappingGraph);
            PrefixManager prefixManager = this.specificationFactory.createPrefixManager(ImmutableMap.of());
            MappingMetadata mappingMetadata = this.specificationFactory.createMetadata(prefixManager);
            return this.ppMappingFactory.createSQLPreProcessedMapping(sourceMappings, mappingMetadata);
        }
        catch (InvalidR2RMLMappingException e) {
            throw new InvalidMappingException(e.getMessage());
        }
    }

    private ImmutableList<SQLPPTriplesMap> extractPPTriplesMaps(Graph mappingGraph) throws InvalidR2RMLMappingException {
        Collection<TriplesMap> tripleMaps = this.r2rmlParser.extractTripleMaps(mappingGraph);
        HashMap regularMap = new HashMap();
        for (TriplesMap tm : tripleMaps) {
            this.extractPPTriplesMap(tm).ifPresent(m -> regularMap.put(tm, m));
        }
        ImmutableMap subjectTermMap = (ImmutableMap)regularMap.entrySet().stream().collect(ImmutableCollectors.toMap(Map.Entry::getKey, e -> this.extractSubjectTerm((SQLPPTriplesMap)e.getValue())));
        ArrayList ppTriplesMaps = Lists.newArrayList();
        ppTriplesMaps.addAll(regularMap.values());
        for (TriplesMap tm : tripleMaps) {
            ppTriplesMaps.addAll(this.extractJoinPPTriplesMaps(tm, (ImmutableMap<TriplesMap, ImmutableTerm>)subjectTermMap));
        }
        return ImmutableList.copyOf((Collection)ppTriplesMaps);
    }

    private ImmutableTerm extractSubjectTerm(SQLPPTriplesMap sqlppTriplesMap) {
        return sqlppTriplesMap.getTargetAtoms().stream().map(a -> a.getSubstitutedTerm(0)).findAny().orElseThrow(() -> new MinorOntopInternalBugException("All created SQLPPTriplesMaps must have at least one target atom"));
    }

    private Optional<SQLPPTriplesMap> extractPPTriplesMap(TriplesMap tm) throws InvalidR2RMLMappingException {
        String sourceQuery = this.r2rmlParser.extractSQLQuery(tm).trim();
        ImmutableList<TargetAtom> targetAtoms = this.extractMappingTargetAtoms(tm);
        if (targetAtoms.isEmpty()) {
            LOGGER.warn("WARNING a triples map without target query will not be introduced : " + tm);
        }
        return Optional.of(targetAtoms).filter(as -> !as.isEmpty()).map(as -> new OntopNativeSQLPPTriplesMap("mapping-" + tm.hashCode(), MAPPING_FACTORY.getSQLQuery(sourceQuery), as));
    }

    private ImmutableList<TargetAtom> extractMappingTargetAtoms(TriplesMap tm) throws InvalidR2RMLMappingException {
        ImmutableList.Builder targetAtoms = ImmutableList.builder();
        SubjectMap subjectMap = tm.getSubjectMap();
        ImmutableTerm subjectTerm = this.r2rmlParser.extractSubjectTerm(subjectMap);
        this.r2rmlParser.extractClassIRIs(subjectMap).map(i -> this.targetAtomFactory.getTripleTargetAtom(subjectTerm, i)).forEach(arg_0 -> ((ImmutableList.Builder)targetAtoms).add(arg_0));
        for (PredicateObjectMap pom : tm.getPredicateObjectMaps()) {
            ImmutableList<NonVariableTerm> predicateTerms = this.r2rmlParser.extractPredicateTerms(pom);
            for (ImmutableTerm objectTerm : this.r2rmlParser.extractRegularObjectTerms(pom)) {
                for (NonVariableTerm predicateTerm : predicateTerms) {
                    targetAtoms.add((Object)this.targetAtomFactory.getTripleTargetAtom(subjectTerm, (ImmutableTerm)predicateTerm, objectTerm));
                }
            }
        }
        return targetAtoms.build();
    }

    private List<SQLPPTriplesMap> extractJoinPPTriplesMaps(TriplesMap tm, ImmutableMap<TriplesMap, ImmutableTerm> subjectTermMap) throws InvalidR2RMLMappingException {
        ImmutableList.Builder joinPPTriplesMapsBuilder = ImmutableList.builder();
        for (PredicateObjectMap pobm : tm.getPredicateObjectMaps()) {
            List refObjectMaps = pobm.getRefObjectMaps();
            if (refObjectMaps.isEmpty()) continue;
            ImmutableList<NonVariableTerm> predicateTerms = this.r2rmlParser.extractPredicateTerms(pobm);
            for (RefObjectMap robm : refObjectMaps) {
                String sourceQuery = robm.getJointQuery();
                if (sourceQuery.isEmpty()) {
                    throw new InvalidR2RMLMappingException("Could not create source query for join in " + tm);
                }
                ImmutableTerm childSubject = Optional.ofNullable(subjectTermMap.get((Object)tm)).orElseGet(() -> this.r2rmlParser.extractSubjectTerm(tm.getSubjectMap()));
                TriplesMap parent = robm.getParentMap();
                ImmutableTerm parentSubject = Optional.ofNullable(subjectTermMap.get((Object)parent)).orElseGet(() -> this.r2rmlParser.extractSubjectTerm(parent.getSubjectMap()));
                ImmutableList targetAtoms = (ImmutableList)predicateTerms.stream().map(p -> this.targetAtomFactory.getTripleTargetAtom(childSubject, (ImmutableTerm)p, parentSubject)).collect(ImmutableCollectors.toList());
                OntopNativeSQLPPTriplesMap ppTriplesMap = new OntopNativeSQLPPTriplesMap("tm-join-" + robm.hashCode(), MAPPING_FACTORY.getSQLQuery(sourceQuery), targetAtoms);
                LOGGER.info("Join \"triples map\" introduced: " + ppTriplesMap);
                joinPPTriplesMapsBuilder.add((Object)ppTriplesMap);
            }
        }
        return joinPPTriplesMapsBuilder.build();
    }
}

