/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.injection.impl;

import it.unibz.inf.ontop.injection.OntopMappingOntologyConfiguration;
import it.unibz.inf.ontop.injection.impl.OntopMappingConfigurationImpl;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Optional;
import javax.annotation.Nonnull;

public class OntopMappingOntologyBuilders {

    static class StandardMappingOntologyBuilderFragment<B extends OntopMappingOntologyConfiguration.Builder<B>>
    implements OntopMappingOntologyConfiguration.OntopMappingOntologyBuilderFragment<B> {
        private final B builder;
        private final Runnable declareOntologyDefinedCB;
        private Optional<File> ontologyFile = Optional.empty();
        private Optional<URL> ontologyURL = Optional.empty();
        private Optional<String> xmlCatalogFile = Optional.empty();

        StandardMappingOntologyBuilderFragment(B builder, Runnable declareOntologyDefinedCB) {
            this.builder = builder;
            this.declareOntologyDefinedCB = declareOntologyDefinedCB;
        }

        @Override
        public B ontologyFile(@Nonnull String urlOrPath) {
            try {
                URL url = new URL(urlOrPath);
                String protocol = url.getProtocol();
                if (protocol == null) {
                    return this.ontologyFile(new File(urlOrPath));
                }
                if (protocol.equals("file")) {
                    return this.ontologyFile(new File(url.getPath()));
                }
                return this.ontologyFile(url);
            }
            catch (MalformedURLException e) {
                return this.ontologyFile(new File(urlOrPath));
            }
        }

        @Override
        public B xmlCatalogFile(@Nonnull String xmlCatalogFile) {
            this.xmlCatalogFile = Optional.of(xmlCatalogFile);
            return this.builder;
        }

        @Override
        public B ontologyFile(@Nonnull URL url) {
            this.declareOntologyDefinedCB.run();
            this.ontologyURL = Optional.of(url);
            return this.builder;
        }

        @Override
        public B ontologyFile(@Nonnull File owlFile) {
            this.declareOntologyDefinedCB.run();
            this.ontologyFile = Optional.of(owlFile);
            return this.builder;
        }

        OntopMappingOntologyOptions generateMappingOntologyOptions(OntopMappingConfigurationImpl.OntopMappingOptions mappingOptions) {
            return new OntopMappingOntologyOptions(this.ontologyFile, this.ontologyURL, this.xmlCatalogFile, mappingOptions);
        }
    }

    static class OntopMappingOntologyOptions {
        final Optional<File> ontologyFile;
        final Optional<URL> ontologyURL;
        final Optional<String> xmlCatalogFile;
        final OntopMappingConfigurationImpl.OntopMappingOptions mappingOptions;

        private OntopMappingOntologyOptions(Optional<File> ontologyFile, Optional<URL> ontologyURL, Optional<String> xmlCatalogFile, OntopMappingConfigurationImpl.OntopMappingOptions mappingOptions) {
            this.ontologyFile = ontologyFile;
            this.xmlCatalogFile = xmlCatalogFile;
            this.ontologyURL = ontologyURL;
            this.mappingOptions = mappingOptions;
        }
    }
}

