/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.injection.impl;

import it.unibz.inf.ontop.exception.OntologyException;
import it.unibz.inf.ontop.injection.OntopMappingOWLAPIConfiguration;
import it.unibz.inf.ontop.injection.OntopMappingSettings;
import it.unibz.inf.ontop.injection.impl.OntopMappingConfigurationImpl;
import it.unibz.inf.ontop.injection.impl.OntopMappingOntologyBuilders;
import it.unibz.inf.ontop.spec.ontology.Ontology;
import it.unibz.inf.ontop.spec.ontology.owlapi.OWLAPITranslatorOWL2QL;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Optional;
import java.util.Properties;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.apibinding.OWLManager;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;
import org.semanticweb.owlapi.model.OWLOntologyManager;

public class OntopMappingOWLAPIConfigurationImpl
extends OntopMappingConfigurationImpl
implements OntopMappingOWLAPIConfiguration {
    private final OntopMappingOWLAPIOptions options;
    private Optional<OWLOntology> owlOntology;

    protected OntopMappingOWLAPIConfigurationImpl(OntopMappingSettings settings, OntopMappingOWLAPIOptions options) {
        super(settings, options.mappingOntologyOptions.mappingOptions);
        this.options = options;
        this.owlOntology = Optional.empty();
    }

    public Optional<OWLOntology> loadInputOntology() throws OWLOntologyCreationException {
        if (this.options.ontology.isPresent()) {
            return this.options.ontology;
        }
        if (this.owlOntology.isPresent()) {
            return this.owlOntology;
        }
        return this.loadOntologyFromFile();
    }

    private Optional<OWLOntology> loadOntologyFromFile() throws OWLOntologyCreationException {
        OWLOntologyManager manager = OWLManager.createOWLOntologyManager();
        if (this.options.mappingOntologyOptions.ontologyFile.isPresent()) {
            this.owlOntology = Optional.of(manager.loadOntologyFromOntologyDocument(this.options.mappingOntologyOptions.ontologyFile.get()));
        }
        try {
            Optional<URL> optionalURL = this.options.mappingOntologyOptions.ontologyURL;
            if (optionalURL.isPresent()) {
                this.owlOntology = Optional.of(manager.loadOntologyFromOntologyDocument(optionalURL.get().openStream()));
            }
        }
        catch (MalformedURLException e) {
            throw new OWLOntologyCreationException("Invalid URI: " + e.getMessage());
        }
        catch (IOException e) {
            throw new OWLOntologyCreationException(e.getMessage());
        }
        return this.owlOntology;
    }

    Optional<Ontology> loadOntology() throws OntologyException {
        OWLAPITranslatorOWL2QL translator = (OWLAPITranslatorOWL2QL)this.getInjector().getInstance(OWLAPITranslatorOWL2QL.class);
        try {
            return this.loadInputOntology().map(o -> translator.translateAndClassify(o));
        }
        catch (OWLOntologyCreationException e) {
            throw new OntologyException(e.getMessage());
        }
    }

    protected static class StandardMappingOWLAPIBuilderFragment<B extends OntopMappingOWLAPIConfiguration.Builder<B>>
    implements OntopMappingOWLAPIConfiguration.OntopMappingOWLAPIBuilderFragment<B> {
        private final B builder;
        private final Runnable declareOntologyDefinedCB;
        private Optional<OWLOntology> ontology = Optional.empty();

        StandardMappingOWLAPIBuilderFragment(B builder, Runnable declareOntologyDefinedCB) {
            this.builder = builder;
            this.declareOntologyDefinedCB = declareOntologyDefinedCB;
        }

        @Override
        public B ontology(@Nonnull OWLOntology ontology) {
            this.declareOntologyDefinedCB.run();
            this.ontology = Optional.of(ontology);
            return this.builder;
        }

        protected final OntopMappingOWLAPIOptions generateOntologyOWLAPIOptions(OntopMappingOntologyBuilders.OntopMappingOntologyOptions mappingOntologyOptions) {
            return new OntopMappingOWLAPIOptions(this.ontology, mappingOntologyOptions);
        }

        protected Properties generateProperties() {
            Properties p = new Properties();
            return p;
        }
    }

    static class OntopMappingOWLAPIOptions {
        private final Optional<OWLOntology> ontology;
        final OntopMappingOntologyBuilders.OntopMappingOntologyOptions mappingOntologyOptions;

        OntopMappingOWLAPIOptions(Optional<OWLOntology> ontology, OntopMappingOntologyBuilders.OntopMappingOntologyOptions mappingOntologyOptions) {
            this.ontology = ontology;
            this.mappingOntologyOptions = mappingOntologyOptions;
        }
    }
}

