/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.spec.mapping.serializer.impl;

import it.unibz.inf.ontop.com.google.common.collect.ImmutableList;
import it.unibz.inf.ontop.com.google.common.collect.Maps;
import it.unibz.inf.ontop.exception.MinorOntopInternalBugException;
import it.unibz.inf.ontop.model.atom.QuadPredicate;
import it.unibz.inf.ontop.model.atom.RDFAtomPredicate;
import it.unibz.inf.ontop.model.atom.TriplePredicate;
import it.unibz.inf.ontop.model.template.impl.BnodeTemplateFactory;
import it.unibz.inf.ontop.model.template.impl.IRITemplateFactory;
import it.unibz.inf.ontop.model.template.impl.LiteralTemplateFactory;
import it.unibz.inf.ontop.model.term.BNode;
import it.unibz.inf.ontop.model.term.DBConstant;
import it.unibz.inf.ontop.model.term.IRIConstant;
import it.unibz.inf.ontop.model.term.ImmutableFunctionalTerm;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.RDFLiteralConstant;
import it.unibz.inf.ontop.model.term.RDFTermTypeConstant;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.model.term.functionsymbol.FunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.RDFTermFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.BnodeStringTemplateFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.DBConcatFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.DBTypeConversionFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.IRIStringTemplateFunctionSymbol;
import it.unibz.inf.ontop.model.type.RDFDatatype;
import it.unibz.inf.ontop.model.type.RDFTermType;
import it.unibz.inf.ontop.model.type.TermTypeInference;
import it.unibz.inf.ontop.model.type.impl.BlankNodeTermType;
import it.unibz.inf.ontop.model.type.impl.IRITermType;
import it.unibz.inf.ontop.model.vocabulary.RDF;
import it.unibz.inf.ontop.model.vocabulary.RDFS;
import it.unibz.inf.ontop.model.vocabulary.XSD;
import it.unibz.inf.ontop.spec.mapping.PrefixManager;
import it.unibz.inf.ontop.spec.mapping.TargetAtom;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.rdf4j.rio.turtle.TurtleUtil;

public class TargetQueryRenderer {
    private final PrefixManager prefixManager;
    private final IRITemplateFactory iriTemplateFactory;
    private final BnodeTemplateFactory bnodeTemplateFactory;
    private final LiteralTemplateFactory literalTemplateFactory;
    private final String rdfType;

    public TargetQueryRenderer(PrefixManager prefixManager) {
        this.prefixManager = prefixManager;
        this.rdfType = prefixManager.getShortForm(RDF.TYPE.getIRIString());
        this.iriTemplateFactory = new IRITemplateFactory(null);
        this.bnodeTemplateFactory = new BnodeTemplateFactory(null);
        this.literalTemplateFactory = new LiteralTemplateFactory(null, null);
    }

    public String encode(ImmutableList<TargetAtom> body) {
        LinkedHashMap<Optional, Map> store = new LinkedHashMap<Optional, Map>();
        for (TargetAtom atom : body) {
            Optional<Object> graph;
            RDFAtomPredicate pred = (RDFAtomPredicate)atom.getProjectionAtom().getPredicate();
            if (pred instanceof TriplePredicate) {
                graph = Optional.empty();
            } else if (pred instanceof QuadPredicate) {
                graph = pred.getGraph(atom.getSubstitutedTerms()).map(this::renderTerm);
            } else {
                throw new UnsupportedOperationException("unsupported predicate! " + pred);
            }
            String subject = this.renderTerm(pred.getSubject(atom.getSubstitutedTerms()));
            String predicate = this.renderTerm(pred.getProperty(atom.getSubstitutedTerms()));
            String object = this.renderTerm(pred.getObject(atom.getSubstitutedTerms()));
            store.computeIfAbsent(graph, g -> new LinkedHashMap()).computeIfAbsent(subject, s -> new LinkedHashMap()).computeIfAbsent(predicate, p -> new LinkedHashSet()).add(object);
        }
        return store.entrySet().stream().map(e -> ((Optional)e.getKey()).isPresent() ? "GRAPH " + (String)((Optional)e.getKey()).get() + " { " + this.getSubjectPredicateObjects((Map)e.getValue()) + "}" : this.getSubjectPredicateObjects((Map)e.getValue())).collect(Collectors.joining(" "));
    }

    private String getPredicateObjects(Map<String, Set<String>> predicateObjects) {
        Set<String> type = predicateObjects.get(this.rdfType);
        Stream stream = type != null ? Stream.concat(Stream.of(Maps.immutableEntry((Object)"a", type)), predicateObjects.entrySet().stream().filter(e -> !((String)e.getKey()).equals(this.rdfType))) : predicateObjects.entrySet().stream();
        return stream.map(e -> (String)e.getKey() + " " + String.join((CharSequence)" , ", (Iterable)e.getValue())).collect(Collectors.joining(" ; "));
    }

    private String getSubjectPredicateObjects(Map<String, Map<String, Set<String>>> map) {
        return map.entrySet().stream().map(e -> (String)e.getKey() + " " + this.getPredicateObjects((Map)e.getValue()) + " . ").collect(Collectors.joining(""));
    }

    private String renderTerm(ImmutableTerm term) {
        if (term instanceof ImmutableFunctionalTerm) {
            ImmutableFunctionalTerm ift = (ImmutableFunctionalTerm)term;
            ImmutableTerm uncast = DBTypeConversionFunctionSymbol.uncast((ImmutableTerm)ift);
            if (uncast instanceof Variable) {
                return TargetQueryRenderer.renderVariable((Variable)uncast);
            }
            if (uncast != ift) {
                throw new MinorOntopInternalBugException("Unexpected type " + term.getClass() + " for term: " + term);
            }
            FunctionSymbol fs = ift.getFunctionSymbol();
            if (fs instanceof RDFTermFunctionSymbol) {
                return this.renderRDFFunction(ift);
            }
            if (fs instanceof DBConcatFunctionSymbol) {
                return "\"" + TurtleUtil.encodeString((String)this.literalTemplateFactory.serializeTemplateTerm(ift)) + "\"";
            }
            return ift.getFunctionSymbol().getName() + "(" + ift.getTerms().stream().map(this::renderTerm).collect(Collectors.joining(", ")) + ")";
        }
        if (term instanceof Variable) {
            return TargetQueryRenderer.renderVariable((Variable)term);
        }
        if (term instanceof IRIConstant) {
            return this.renderIRI(((IRIConstant)term).getIRI().getIRIString());
        }
        if (term instanceof RDFLiteralConstant) {
            return ((RDFLiteralConstant)term).toString();
        }
        if (term instanceof BNode) {
            return ((BNode)term).getInternalLabel();
        }
        throw new MinorOntopInternalBugException("Unexpected type " + term.getClass() + " for term: " + term);
    }

    private static String renderVariable(Variable term) {
        return "{" + term.getName() + "}";
    }

    private String renderRDFFunction(ImmutableFunctionalTerm function) {
        ImmutableTerm lexicalTerm = function.getTerm(0);
        Optional<RDFDatatype> optionalDatatype = function.inferType().flatMap(TermTypeInference::getTermType).filter(t -> t instanceof RDFDatatype).map(t -> (RDFDatatype)t);
        if (optionalDatatype.isPresent()) {
            return this.renderRDFLiteral(lexicalTerm, optionalDatatype.get());
        }
        ImmutableTerm termType = function.getTerm(1);
        if (termType instanceof RDFTermTypeConstant) {
            RDFTermType rdfTermType = ((RDFTermTypeConstant)termType).getRDFTermType();
            if (rdfTermType instanceof BlankNodeTermType) {
                String identifier = lexicalTerm instanceof ImmutableFunctionalTerm && ((ImmutableFunctionalTerm)lexicalTerm).getFunctionSymbol() instanceof BnodeStringTemplateFunctionSymbol ? this.bnodeTemplateFactory.serializeTemplateTerm((ImmutableFunctionalTerm)lexicalTerm) : this.renderTerm(lexicalTerm);
                return "_:" + identifier;
            }
            if (rdfTermType instanceof IRITermType) {
                String identifier = lexicalTerm instanceof ImmutableFunctionalTerm && ((ImmutableFunctionalTerm)lexicalTerm).getFunctionSymbol() instanceof IRIStringTemplateFunctionSymbol ? this.iriTemplateFactory.serializeTemplateTerm((ImmutableFunctionalTerm)lexicalTerm) : this.renderTerm(lexicalTerm);
                return this.renderIRI(identifier);
            }
        }
        throw new MinorOntopInternalBugException("unsupported function " + function);
    }

    private String renderRDFLiteral(ImmutableTerm lexicalTerm, RDFDatatype datatype) {
        String lexicalString = lexicalTerm instanceof DBConstant ? "\"" + ((DBConstant)lexicalTerm).getValue() + "\"" : this.renderTerm(lexicalTerm);
        String suffix = datatype.getLanguageTag().map(tag -> "@" + tag.getFullString()).orElseGet(() -> datatype.getIRI().equals((Object)XSD.STRING) && lexicalTerm instanceof RDFLiteralConstant || datatype.getIRI().equals((Object)RDFS.LITERAL) && !(lexicalTerm instanceof RDFLiteralConstant) ? "" : "^^" + this.prefixManager.getShortForm(datatype.getIRI().getIRIString()));
        return lexicalString + suffix;
    }

    private String renderIRI(String iri) {
        String shortenedIri = this.prefixManager.getShortForm(iri);
        if (!shortenedIri.equals(iri)) {
            return shortenedIri;
        }
        return "<" + iri + ">";
    }
}

