/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.spec.mapping.parser.impl;

import com.google.inject.Inject;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableList;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableMap;
import it.unibz.inf.ontop.exception.Indicator;
import it.unibz.inf.ontop.exception.InvalidMappingException;
import it.unibz.inf.ontop.exception.InvalidMappingExceptionWithIndicator;
import it.unibz.inf.ontop.exception.MappingIOException;
import it.unibz.inf.ontop.exception.TargetQueryParserException;
import it.unibz.inf.ontop.injection.SQLPPMappingFactory;
import it.unibz.inf.ontop.injection.SpecificationFactory;
import it.unibz.inf.ontop.injection.TargetQueryParserFactory;
import it.unibz.inf.ontop.spec.mapping.PrefixManager;
import it.unibz.inf.ontop.spec.mapping.SQLPPSourceQueryFactory;
import it.unibz.inf.ontop.spec.mapping.TargetAtom;
import it.unibz.inf.ontop.spec.mapping.parser.SQLMappingParser;
import it.unibz.inf.ontop.spec.mapping.parser.TargetQueryParser;
import it.unibz.inf.ontop.spec.mapping.pp.SQLPPMapping;
import it.unibz.inf.ontop.spec.mapping.pp.SQLPPTriplesMap;
import it.unibz.inf.ontop.spec.mapping.pp.impl.OntopNativeSQLPPTriplesMap;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import org.apache.commons.rdf.api.Graph;

public class OntopNativeMappingParser
implements SQLMappingParser {
    public static final String MAPPING_ID_LABEL = "mappingId";
    public static final String TARGET_LABEL = "target";
    public static final String SOURCE_LABEL = "source";
    public static final String PREFIX_DECLARATION_TAG = "[PrefixDeclaration]";
    private static final ImmutableList<String> DEPRECATED_TAGS = ImmutableList.of((Object)"[ClassDeclaration]", (Object)"[ObjectPropertyDeclaration]", (Object)"[DataPropertyDeclaration]");
    protected static final String SOURCE_DECLARATION_TAG = "[SourceDeclaration]";
    public static final String MAPPING_DECLARATION_TAG = "[MappingDeclaration]";
    public static final String START_COLLECTION_SYMBOL = "@collection [[";
    public static final String END_COLLECTION_SYMBOL = "]]";
    protected static final String COMMENT_SYMBOL = ";";
    private final TargetQueryParserFactory targetQueryParserFactory;
    private final SQLPPMappingFactory ppMappingFactory;
    private final SpecificationFactory specificationFactory;
    private final SQLPPSourceQueryFactory sourceQueryFactory;

    @Inject
    private OntopNativeMappingParser(SpecificationFactory specificationFactory, TargetQueryParserFactory targetQueryParserFactory, SQLPPMappingFactory ppMappingFactory, SQLPPSourceQueryFactory sourceQueryFactory) {
        this.targetQueryParserFactory = targetQueryParserFactory;
        this.ppMappingFactory = ppMappingFactory;
        this.specificationFactory = specificationFactory;
        this.sourceQueryFactory = sourceQueryFactory;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SQLPPMapping parse(File file) throws InvalidMappingException, MappingIOException {
        if (!file.exists()) {
            throw new MappingIOException("WARNING: Cannot locate OBDA file at: " + file.getPath());
        }
        if (!file.canRead()) {
            throw new MappingIOException(String.format("Error while reading the file located at %s.\nMake sure you have the read permission at the location specified.", file.getAbsolutePath()));
        }
        try (FileReader reader = new FileReader(file);){
            SQLPPMapping sQLPPMapping = this.load(reader, this.specificationFactory, this.ppMappingFactory, file.getName());
            return sQLPPMapping;
        }
        catch (IOException e) {
            throw new MappingIOException((Exception)e);
        }
    }

    public SQLPPMapping parse(Reader reader) throws InvalidMappingException, MappingIOException {
        return this.load(reader, this.specificationFactory, this.ppMappingFactory, ".obda file");
    }

    public SQLPPMapping parse(Graph mappingGraph) {
        throw new IllegalArgumentException("The Ontop native mapping language has no RDF serialization. Passing a RDF graphto the OntopNativeMappingParser is thus invalid.");
    }

    private SQLPPMapping load(Reader reader, SpecificationFactory specificationFactory, SQLPPMappingFactory ppMappingFactory, String fileName) throws MappingIOException, InvalidMappingExceptionWithIndicator {
        ImmutableMap.Builder prefixes = ImmutableMap.builder();
        ImmutableList.Builder mappings = ImmutableList.builder();
        ArrayList<Indicator> invalidMappingIndicators = new ArrayList<Indicator>();
        try (LineNumberReader lineNumberReader = new LineNumberReader(reader);){
            try {
                String line;
                while ((line = lineNumberReader.readLine()) != null) {
                    if (line.isEmpty() || line.trim().indexOf(COMMENT_SYMBOL) == 0) continue;
                    if (line.contains(PREFIX_DECLARATION_TAG)) {
                        prefixes.putAll(OntopNativeMappingParser.readPrefixDeclaration(lineNumberReader));
                        continue;
                    }
                    if (line.contains(MAPPING_DECLARATION_TAG)) {
                        TargetQueryParser parser = this.targetQueryParserFactory.createParser(specificationFactory.createPrefixManager(prefixes.build()));
                        mappings.addAll(this.readMappingDeclaration(lineNumberReader, parser, invalidMappingIndicators));
                        continue;
                    }
                    DEPRECATED_TAGS.stream().filter(line::contains).forEach(tag -> {
                        throw new RuntimeException("The tag " + tag + " is no longer supported. You may safely remove the content from the file.");
                    });
                    if (line.contains(SOURCE_DECLARATION_TAG)) {
                        throw new RuntimeException("Source declaration is not supported anymore (since 3.0). Please give this information with the Ontop configuration.");
                    }
                    throw new RuntimeException("Unknown syntax: " + line);
                }
            }
            catch (Exception e) {
                throw new IOException(String.format("ERROR reading %s at line: %d\nMESSAGE: %s", fileName, lineNumberReader.getLineNumber(), e.getMessage()), e);
            }
        }
        catch (IOException e) {
            throw new MappingIOException((Exception)e);
        }
        if (!invalidMappingIndicators.isEmpty()) {
            throw new InvalidMappingExceptionWithIndicator(invalidMappingIndicators);
        }
        PrefixManager prefixManager = specificationFactory.createPrefixManager(prefixes.build());
        return ppMappingFactory.createSQLPreProcessedMapping(mappings.build(), prefixManager);
    }

    private static ImmutableMap<String, String> readPrefixDeclaration(BufferedReader reader) throws IOException {
        String line;
        ImmutableMap.Builder prefixes = ImmutableMap.builder();
        while (!(line = reader.readLine()).isEmpty()) {
            String[] tokens = line.split("[\t| ]+");
            prefixes.put((Object)tokens[0], (Object)tokens[1]);
        }
        return prefixes.build();
    }

    private ImmutableList<SQLPPTriplesMap> readMappingDeclaration(LineNumberReader reader, TargetQueryParser parser, List<Indicator> invalidMappingIndicators) throws IOException {
        String line;
        ImmutableList.Builder mappings = ImmutableList.builder();
        MappingBuilder current = new MappingBuilder(invalidMappingIndicators);
        String currentLabel = "";
        block10: while ((line = reader.readLine()) != null) {
            String label;
            if (line.trim().equals(END_COLLECTION_SYMBOL)) {
                current.build().ifPresent(arg_0 -> ((ImmutableList.Builder)mappings).add(arg_0));
                return mappings.build();
            }
            if (line.isEmpty()) {
                current.build().ifPresent(arg_0 -> ((ImmutableList.Builder)mappings).add(arg_0));
                current = new MappingBuilder(invalidMappingIndicators);
                continue;
            }
            if (line.trim().indexOf(COMMENT_SYMBOL) == 0 || !current.isValid()) continue;
            String[] tokens = line.split("[\t| ]+", 2);
            String value = tokens[tokens.length - 1].trim();
            if (tokens.length > 1 && !(label = tokens[0].trim()).isEmpty()) {
                currentLabel = label;
            }
            switch (currentLabel) {
                case "mappingId": {
                    current.setMappingId(value, reader::getLineNumber);
                    continue block10;
                }
                case "target": {
                    current.setTarget(value, parser, reader::getLineNumber);
                    continue block10;
                }
                case "source": {
                    current.setSource(value, reader::getLineNumber);
                    continue block10;
                }
            }
            throw new IOException(String.format("Unknown parameter name \"%s\" at line: %d.", tokens[0], reader.getLineNumber()));
        }
        throw new IOException(String.format("End collection symbol %s is missing.", END_COLLECTION_SYMBOL));
    }

    private final class MappingBuilder {
        private final List<Indicator> invalidMappingIndicators;
        private String mappingId = "";
        private final ImmutableList.Builder<String> sourceQuery = ImmutableList.builder();
        private String targetString = null;
        private ImmutableList<TargetAtom> targetQuery = null;
        boolean isMappingValid = true;

        MappingBuilder(List<Indicator> invalidMappingIndicators) {
            this.invalidMappingIndicators = invalidMappingIndicators;
        }

        private void fail(Supplier<Integer> line, Object hint, int reason) {
            this.invalidMappingIndicators.add(new Indicator(line.get().intValue(), hint, reason));
            this.isMappingValid = false;
        }

        boolean isValid() {
            return this.isMappingValid;
        }

        Optional<OntopNativeSQLPPTriplesMap> build() {
            return !this.mappingId.isEmpty() && this.isMappingValid ? Optional.of(new OntopNativeSQLPPTriplesMap(this.mappingId, OntopNativeMappingParser.this.sourceQueryFactory.createSourceQuery(String.join((CharSequence)"\n", (Iterable<? extends CharSequence>)this.sourceQuery.build())), this.targetString, this.targetQuery)) : Optional.empty();
        }

        void setMappingId(String value, Supplier<Integer> line) {
            this.mappingId = value;
            if (this.mappingId.isEmpty()) {
                this.fail(line, OntopNativeMappingParser.MAPPING_ID_LABEL, 1);
            }
        }

        void setTarget(String value, TargetQueryParser parser, Supplier<Integer> line) {
            this.targetString = value;
            if (!this.targetString.isEmpty()) {
                try {
                    this.targetQuery = parser.parse(this.targetString);
                }
                catch (TargetQueryParserException e) {
                    this.fail(line, new String[]{this.mappingId, this.targetString, e.getMessage()}, 5);
                }
            } else {
                this.fail(line, this.mappingId, 2);
            }
        }

        void setSource(String value, Supplier<Integer> line) {
            if (!value.isEmpty()) {
                this.sourceQuery.add((Object)value);
            } else {
                this.fail(line, this.mappingId, 3);
            }
        }
    }
}

