/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.spec.mapping.serializer.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import it.unibz.inf.ontop.spec.mapping.PrefixManager;
import it.unibz.inf.ontop.spec.mapping.SQLPPSourceQuery;
import it.unibz.inf.ontop.spec.mapping.TargetAtom;
import it.unibz.inf.ontop.spec.mapping.parser.impl.OntopNativeMappingParser;
import it.unibz.inf.ontop.spec.mapping.pp.SQLPPMapping;
import it.unibz.inf.ontop.spec.mapping.pp.SQLPPTriplesMap;
import it.unibz.inf.ontop.spec.mapping.serializer.SourceQueryRenderer;
import it.unibz.inf.ontop.spec.mapping.serializer.TargetQueryRenderer;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;

public class OntopNativeMappingSerializer {
    private final SQLPPMapping ppMapping;

    public OntopNativeMappingSerializer(SQLPPMapping ppMapping) {
        this.ppMapping = ppMapping;
    }

    public void save(Writer writer) throws IOException {
        BufferedWriter bufferWriter = new BufferedWriter(writer);
        this.writePrefixDeclaration(bufferWriter);
        this.writeMappingDeclaration(bufferWriter);
        bufferWriter.flush();
        bufferWriter.close();
    }

    public void save(File file) throws IOException {
        try {
            this.save(new FileWriter(file));
        }
        catch (IOException e) {
            throw new IOException(String.format("Error while saving the OBDA model to the file located at %s.\nMake sure you have the write permission at the location specified.", file.getAbsolutePath()));
        }
    }

    private void writePrefixDeclaration(BufferedWriter writer) throws IOException {
        ImmutableMap prefixMap = this.ppMapping.getPrefixManager().getPrefixMap();
        if (prefixMap.size() == 0) {
            return;
        }
        writer.write("[PrefixDeclaration]");
        writer.write("\n");
        for (String prefix : prefixMap.keySet()) {
            String uri = (String)prefixMap.get((Object)prefix);
            writer.write(prefix + (prefix.length() >= 9 ? "\t" : "\t\t") + uri + "\n");
        }
        writer.write("\n");
    }

    private void writeMappingDeclaration(BufferedWriter writer) throws IOException {
        writer.write("[MappingDeclaration] @collection [[");
        writer.write("\n");
        boolean needLineBreak = false;
        for (SQLPPTriplesMap axiom : this.ppMapping.getTripleMaps()) {
            if (needLineBreak) {
                writer.write("\n");
            }
            writer.write(OntopNativeMappingParser.Label.mappingId.name() + "\t" + axiom.getId() + "\n");
            ImmutableList targetQuery = axiom.getTargetAtoms();
            writer.write(OntopNativeMappingParser.Label.target.name() + "\t\t" + this.printTargetQuery((ImmutableList<TargetAtom>)targetQuery) + "\n");
            SQLPPSourceQuery sourceQuery = axiom.getSourceQuery();
            writer.write(OntopNativeMappingParser.Label.source.name() + "\t\t" + this.printSourceQuery(sourceQuery) + "\n");
            needLineBreak = true;
        }
        writer.write("]]");
        writer.write("\n\n");
    }

    private String printTargetQuery(ImmutableList<TargetAtom> query) {
        return TargetQueryRenderer.encode(query, (PrefixManager)this.ppMapping.getPrefixManager());
    }

    private String printSourceQuery(SQLPPSourceQuery query) {
        String sourceString = SourceQueryRenderer.encode((SQLPPSourceQuery)query);
        String toReturn = this.convertTabToSpaces(sourceString);
        return toReturn.replaceAll("\n", "\n\t\t\t");
    }

    private String convertTabToSpaces(String input) {
        return input.replaceAll("\t", "   ");
    }
}

