/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.spec.mapping.parser.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Inject;
import it.unibz.inf.ontop.exception.Indicator;
import it.unibz.inf.ontop.exception.InvalidMappingException;
import it.unibz.inf.ontop.exception.InvalidMappingExceptionWithIndicator;
import it.unibz.inf.ontop.exception.MappingIOException;
import it.unibz.inf.ontop.exception.TargetQueryParserException;
import it.unibz.inf.ontop.injection.SQLPPMappingFactory;
import it.unibz.inf.ontop.injection.SpecificationFactory;
import it.unibz.inf.ontop.injection.TargetQueryParserFactory;
import it.unibz.inf.ontop.spec.mapping.SQLPPSourceQueryFactory;
import it.unibz.inf.ontop.spec.mapping.TargetAtom;
import it.unibz.inf.ontop.spec.mapping.parser.SQLMappingParser;
import it.unibz.inf.ontop.spec.mapping.parser.TargetQueryParser;
import it.unibz.inf.ontop.spec.mapping.parser.exception.UnparsableTargetQueryException;
import it.unibz.inf.ontop.spec.mapping.pp.SQLPPMapping;
import it.unibz.inf.ontop.spec.mapping.pp.SQLPPTriplesMap;
import it.unibz.inf.ontop.spec.mapping.pp.impl.OntopNativeSQLPPTriplesMap;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.rdf.api.Graph;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OntopNativeMappingParser
implements SQLMappingParser {
    public static final String PREFIX_DECLARATION_TAG = "[PrefixDeclaration]";
    protected static final String CLASS_DECLARATION_TAG = "[ClassDeclaration]";
    protected static final String OBJECT_PROPERTY_DECLARATION_TAG = "[ObjectPropertyDeclaration]";
    protected static final String DATA_PROPERTY_DECLARATION_TAG = "[DataPropertyDeclaration]";
    protected static final String SOURCE_DECLARATION_TAG = "[SourceDeclaration]";
    public static final String MAPPING_DECLARATION_TAG = "[MappingDeclaration]";
    public static final String START_COLLECTION_SYMBOL = "@collection [[";
    public static final String END_COLLECTION_SYMBOL = "]]";
    protected static final String COMMENT_SYMBOL = ";";
    private static final Logger LOG = LoggerFactory.getLogger(OntopNativeMappingParser.class);
    private final TargetQueryParserFactory targetQueryParserFactory;
    private final SQLPPMappingFactory ppMappingFactory;
    private final SpecificationFactory specificationFactory;
    private final SQLPPSourceQueryFactory sourceQueryFactory;

    @Inject
    private OntopNativeMappingParser(SpecificationFactory specificationFactory, TargetQueryParserFactory targetQueryParserFactory, SQLPPMappingFactory ppMappingFactory, SQLPPSourceQueryFactory sourceQueryFactory) {
        this.targetQueryParserFactory = targetQueryParserFactory;
        this.ppMappingFactory = ppMappingFactory;
        this.specificationFactory = specificationFactory;
        this.sourceQueryFactory = sourceQueryFactory;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SQLPPMapping parse(File file) throws InvalidMappingException, MappingIOException {
        OntopNativeMappingParser.checkFile(file);
        try (FileReader reader = new FileReader(file);){
            SQLPPMapping sQLPPMapping = this.load(reader, this.specificationFactory, this.ppMappingFactory, file.getName());
            return sQLPPMapping;
        }
        catch (IOException e) {
            throw new MappingIOException((Exception)e);
        }
    }

    public SQLPPMapping parse(Reader reader) throws InvalidMappingException, MappingIOException {
        return this.load(reader, this.specificationFactory, this.ppMappingFactory, ".obda file");
    }

    public SQLPPMapping parse(Graph mappingGraph) {
        throw new IllegalArgumentException("The Ontop native mapping language has no RDF serialization. Passing a RDF graphto the OntopNativeMappingParser is thus invalid.");
    }

    private static void checkFile(File file) throws MappingIOException {
        if (!file.exists()) {
            throw new MappingIOException("WARNING: Cannot locate OBDA file at: " + file.getPath());
        }
        if (!file.canRead()) {
            throw new MappingIOException(String.format("Error while reading the file located at %s.\nMake sure you have the read permission at the location specified.", file.getAbsolutePath()));
        }
    }

    /*
     * Exception decompiling
     */
    private SQLPPMapping load(Reader reader, SpecificationFactory specificationFactory, SQLPPMappingFactory ppMappingFactory, String fileName) throws MappingIOException, InvalidMappingExceptionWithIndicator {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [13[UNCONDITIONALDOLOOP]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static Map<String, String> readPrefixDeclaration(BufferedReader reader) throws IOException {
        String line;
        HashMap<String, String> prefixes = new HashMap<String, String>();
        while (!(line = reader.readLine()).isEmpty()) {
            String[] tokens = line.split("[\t| ]+");
            prefixes.put(tokens[0], tokens[1]);
        }
        return prefixes;
    }

    private List<SQLPPTriplesMap> readMappingDeclaration(LineNumberReader reader, List<TargetQueryParser> parsers, List<Indicator> invalidMappingIndicators) throws IOException {
        List<SQLPPTriplesMap> currentSourceMappings = new ArrayList<SQLPPTriplesMap>();
        String mappingId = "";
        String currentLabel = "";
        StringBuffer sourceQuery = null;
        String targetString = null;
        ImmutableList<TargetAtom> targetQuery = null;
        boolean wsCount = false;
        boolean isMappingValid = true;
        String line = reader.readLine();
        while (line != null && !line.trim().equals(END_COLLECTION_SYMBOL)) {
            int lineNumber = reader.getLineNumber();
            if (line.isEmpty()) {
                if (!mappingId.isEmpty()) {
                    if (isMappingValid) {
                        currentSourceMappings = this.addNewMapping(mappingId, sourceQuery.toString(), targetString, targetQuery, currentSourceMappings);
                        mappingId = "";
                        sourceQuery = null;
                        targetQuery = null;
                    }
                } else {
                    isMappingValid = true;
                }
            } else if (!OntopNativeMappingParser.isCommentLine(line) && isMappingValid) {
                String value;
                String label;
                String[] tokens = line.split("[\t| ]+", 2);
                if (tokens.length > 1) {
                    label = tokens[0].trim();
                    value = tokens[1].trim();
                } else {
                    value = tokens[0];
                    label = "";
                }
                if (!label.isEmpty()) {
                    currentLabel = tokens[0];
                }
                if (currentLabel.equals(Label.mappingId.name())) {
                    mappingId = value;
                    if (mappingId.isEmpty()) {
                        invalidMappingIndicators.add(new Indicator(lineNumber, (Object)Label.mappingId, 1));
                        isMappingValid = false;
                    }
                } else if (currentLabel.equals(Label.target.name())) {
                    targetString = value;
                    if (targetString.isEmpty()) {
                        invalidMappingIndicators.add(new Indicator(lineNumber, (Object)mappingId, 2));
                        isMappingValid = false;
                    } else {
                        try {
                            targetQuery = OntopNativeMappingParser.loadTargetQuery(targetString, parsers);
                        }
                        catch (UnparsableTargetQueryException e) {
                            invalidMappingIndicators.add(new Indicator(lineNumber, (Object)new String[]{mappingId, targetString, e.getMessage()}, 5));
                            isMappingValid = false;
                        }
                    }
                } else if (currentLabel.equals(Label.source.name())) {
                    String sourceString = value;
                    if (sourceString.isEmpty()) {
                        invalidMappingIndicators.add(new Indicator(lineNumber, (Object)mappingId, 3));
                        isMappingValid = false;
                    } else if (sourceQuery == null) {
                        sourceQuery = new StringBuffer();
                        sourceQuery.append(sourceString);
                    } else {
                        sourceQuery.append("\n");
                        sourceQuery.append(sourceString);
                    }
                } else {
                    String msg = String.format("Unknown parameter name \"%s\" at line: %d.", tokens[0], lineNumber);
                    throw new IOException(msg);
                }
            }
            line = reader.readLine();
        }
        if (line == null) {
            throw new IOException(String.format("End collection symbol %s is missing.", END_COLLECTION_SYMBOL));
        }
        if (!mappingId.isEmpty() && isMappingValid) {
            currentSourceMappings = this.addNewMapping(mappingId, sourceQuery.toString(), targetString, targetQuery, currentSourceMappings);
        }
        return currentSourceMappings;
    }

    private static ImmutableList<TargetAtom> loadTargetQuery(String targetString, List<TargetQueryParser> parsers) throws UnparsableTargetQueryException {
        HashMap<TargetQueryParser, TargetQueryParserException> exceptions = new HashMap<TargetQueryParser, TargetQueryParserException>();
        for (TargetQueryParser parser : parsers) {
            try {
                ImmutableList parse = parser.parse(targetString);
                return parse;
            }
            catch (TargetQueryParserException e) {
                exceptions.put(parser, e);
            }
        }
        throw new UnparsableTargetQueryException(exceptions);
    }

    private List<SQLPPTriplesMap> addNewMapping(String mappingId, String sourceQuery, String targetString, ImmutableList<TargetAtom> targetQuery, List<SQLPPTriplesMap> currentSourceMappings) {
        OntopNativeSQLPPTriplesMap mapping = new OntopNativeSQLPPTriplesMap(mappingId, this.sourceQueryFactory.createSourceQuery(sourceQuery), targetString, targetQuery);
        if (!currentSourceMappings.contains(mapping)) {
            currentSourceMappings.add((SQLPPTriplesMap)mapping);
        } else {
            LOG.warn("Duplicate mapping {}", (Object)mappingId);
        }
        return currentSourceMappings;
    }

    private static boolean isCommentLine(String line) {
        return line.contains(COMMENT_SYMBOL) && line.trim().indexOf(COMMENT_SYMBOL) == 0;
    }

    private List<TargetQueryParser> createParsers(ImmutableMap<String, String> prefixes) {
        return ImmutableList.of((Object)this.targetQueryParserFactory.createParser(prefixes));
    }

    public static enum Label {
        sourceUri,
        connectionUrl,
        username,
        password,
        driverClass,
        mappingId,
        target,
        source;

    }
}

