/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.spec.mapping.validation.impl;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableList;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableMultimap;
import it.unibz.inf.ontop.com.google.common.collect.Maps;
import it.unibz.inf.ontop.com.google.common.collect.UnmodifiableIterator;
import it.unibz.inf.ontop.exception.MappingOntologyMismatchException;
import it.unibz.inf.ontop.exception.OntopInternalBugException;
import it.unibz.inf.ontop.iq.IQ;
import it.unibz.inf.ontop.model.term.ImmutableFunctionalTerm;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.RDFConstant;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.model.type.ObjectRDFType;
import it.unibz.inf.ontop.model.type.RDFDatatype;
import it.unibz.inf.ontop.model.type.RDFTermType;
import it.unibz.inf.ontop.model.type.TermType;
import it.unibz.inf.ontop.model.type.TermTypeInference;
import it.unibz.inf.ontop.model.type.TypeFactory;
import it.unibz.inf.ontop.model.vocabulary.RDFS;
import it.unibz.inf.ontop.spec.mapping.MappingAssertion;
import it.unibz.inf.ontop.spec.mapping.validation.MappingOntologyComplianceValidator;
import it.unibz.inf.ontop.spec.ontology.ClassifiedTBox;
import it.unibz.inf.ontop.spec.ontology.DataPropertyRangeExpression;
import it.unibz.inf.ontop.spec.ontology.DataRangeExpression;
import it.unibz.inf.ontop.spec.ontology.Datatype;
import it.unibz.inf.ontop.spec.ontology.Equivalences;
import it.unibz.inf.ontop.spec.ontology.EquivalencesDAG;
import it.unibz.inf.ontop.spec.ontology.Ontology;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.commons.rdf.api.IRI;

@Singleton
public class MappingOntologyComplianceValidatorImpl
implements MappingOntologyComplianceValidator {
    private static final String DATA_PROPERTY_STR = "a data property";
    private static final String OBJECT_PROPERTY_STR = "an object property";
    private static final String ANNOTATION_PROPERTY_STR = "an annotation property";
    private static final String CLASS_STR = "a class";
    private final TypeFactory typeFactory;

    @Inject
    private MappingOntologyComplianceValidatorImpl(TypeFactory typeFactory) {
        this.typeFactory = typeFactory;
    }

    @Override
    public void validate(ImmutableList<MappingAssertion> mapping, Ontology ontology) throws MappingOntologyMismatchException {
        ImmutableMultimap<IRI, Datatype> datatypeMap = MappingOntologyComplianceValidatorImpl.computeDataTypeMap(ontology.tbox());
        for (MappingAssertion a : mapping) {
            this.validateAssertion(a, ontology, datatypeMap);
        }
    }

    private void validateAssertion(MappingAssertion assertion, Ontology ontology, ImmutableMultimap<IRI, Datatype> datatypeMap) throws MappingOntologyMismatchException {
        Optional<RDFTermType> tripleObjectType = assertion.getIndex().isClass() ? Optional.empty() : this.extractTripleObjectType(assertion);
        try {
            this.checkTripleObject(assertion.getIndex().getIri(), tripleObjectType, ontology, datatypeMap);
        }
        catch (MappingOntologyMismatchException e) {
            throw new MappingOntologyMismatchException(e, "\n[\n" + assertion.getProvenance().getProvenanceInfo() + "\n]");
        }
    }

    private Optional<RDFTermType> extractTripleObjectType(MappingAssertion assertion) throws TripleObjectTypeInferenceException {
        Variable objectVariable = (Variable)assertion.getRDFAtomPredicate().getObject(assertion.getProjectionAtom().getArguments());
        ImmutableTerm constructionTerm = assertion.getTopSubstitution().get(objectVariable);
        if (constructionTerm instanceof ImmutableFunctionalTerm) {
            ImmutableFunctionalTerm constructionFunctionalTerm = (ImmutableFunctionalTerm)constructionTerm;
            Optional<RDFTermType> optionalType = constructionFunctionalTerm.inferType().flatMap(TermTypeInference::getTermType).filter(t -> t instanceof RDFTermType).map(t -> (RDFTermType)t);
            if (!optionalType.isPresent()) {
                throw new TripleObjectTypeInferenceException(assertion.getQuery(), objectVariable, "Not defined in the root node (expected for a mapping assertion)");
            }
            return optionalType;
        }
        if (constructionTerm instanceof RDFConstant) {
            return Optional.of(((RDFConstant)constructionTerm).getType());
        }
        throw new TripleObjectTypeInferenceException(assertion.getQuery(), objectVariable, "Was expecting a functional or constant term (variables are not yet supported). \nTerm definition: " + constructionTerm);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void checkTripleObject(IRI predicateIRI, Optional<RDFTermType> optionalTripleObjectType, Ontology ontology, ImmutableMultimap<IRI, Datatype> datatypeMap) throws MappingOntologyMismatchException {
        if (optionalTripleObjectType.isPresent()) {
            RDFTermType tripleObjectType = optionalTripleObjectType.get();
            if (tripleObjectType.isAbstract()) {
                throw new AbstractTripleObjectTypeException(predicateIRI, (TermType)tripleObjectType);
            }
            if (tripleObjectType instanceof ObjectRDFType) {
                this.checkObjectOrAnnotationProperty(predicateIRI, ontology);
                return;
            } else {
                if (!(tripleObjectType instanceof RDFDatatype)) throw new UndeterminedTripleObjectTypeException(predicateIRI, (TermType)tripleObjectType);
                this.checkDataOrAnnotationProperty((RDFDatatype)tripleObjectType, predicateIRI, ontology, datatypeMap);
            }
            return;
        } else {
            this.checkClass(predicateIRI, ontology);
        }
    }

    private void checkObjectOrAnnotationProperty(IRI predicateIRI, Ontology ontology) throws MappingOntologyMismatchException {
        if (ontology.tbox().dataProperties().contains(predicateIRI)) {
            throw new MappingOntologyMismatchException(predicateIRI, DATA_PROPERTY_STR, OBJECT_PROPERTY_STR);
        }
        if (ontology.tbox().classes().contains(predicateIRI)) {
            throw new MappingOntologyMismatchException(predicateIRI, CLASS_STR, OBJECT_PROPERTY_STR);
        }
    }

    private void checkDataOrAnnotationProperty(RDFDatatype tripleObjectType, IRI predicateIRI, Ontology ontology, ImmutableMultimap<IRI, Datatype> datatypeMap) throws MappingOntologyMismatchException {
        Datatype declaredDatatype;
        if (ontology.tbox().objectProperties().contains(predicateIRI)) {
            throw new MappingOntologyMismatchException(predicateIRI, OBJECT_PROPERTY_STR, DATA_PROPERTY_STR);
        }
        if (ontology.tbox().classes().contains(predicateIRI)) {
            throw new MappingOntologyMismatchException(predicateIRI, CLASS_STR, DATA_PROPERTY_STR);
        }
        UnmodifiableIterator unmodifiableIterator = datatypeMap.get((Object)predicateIRI).iterator();
        while (unmodifiableIterator.hasNext() && !(declaredDatatype = (Datatype)unmodifiableIterator.next()).getIRI().equals((Object)RDFS.LITERAL)) {
            RDFDatatype declaredTermType = this.typeFactory.getDatatype(declaredDatatype.getIRI());
            if (tripleObjectType.isA((TermType)declaredTermType)) continue;
            throw new MappingOntologyMismatchException(predicateIRI, declaredDatatype.toString(), tripleObjectType.getIRI().toString());
        }
    }

    private void checkClass(IRI predicateIRI, Ontology ontology) throws MappingOntologyMismatchException {
        if (ontology.tbox().objectProperties().contains(predicateIRI)) {
            throw new MappingOntologyMismatchException(predicateIRI, OBJECT_PROPERTY_STR, CLASS_STR);
        }
        if (ontology.tbox().dataProperties().contains(predicateIRI)) {
            throw new MappingOntologyMismatchException(predicateIRI, DATA_PROPERTY_STR, CLASS_STR);
        }
        if (ontology.annotationProperties().contains(predicateIRI)) {
            throw new MappingOntologyMismatchException(predicateIRI, ANNOTATION_PROPERTY_STR, DATA_PROPERTY_STR);
        }
    }

    private static ImmutableMultimap<IRI, Datatype> computeDataTypeMap(ClassifiedTBox reasoner) {
        return (ImmutableMultimap)reasoner.dataRangesDAG().stream().flatMap(n -> MappingOntologyComplianceValidatorImpl.getPartialPredicateToDatatypeMap((Equivalences<DataRangeExpression>)n, (EquivalencesDAG<DataRangeExpression>)reasoner.dataRangesDAG())).collect(ImmutableCollectors.toMultimap());
    }

    private static Stream<Map.Entry<IRI, Datatype>> getPartialPredicateToDatatypeMap(Equivalences<DataRangeExpression> nodeSet, EquivalencesDAG<DataRangeExpression> dag) {
        return Stream.concat(MappingOntologyComplianceValidatorImpl.getSub(dag.getSub(nodeSet).stream().map(Equivalences::getRepresentative), (DataRangeExpression)nodeSet.getRepresentative()), MappingOntologyComplianceValidatorImpl.getEquivalentNodesPartialMap(nodeSet));
    }

    private static Stream<Map.Entry<IRI, Datatype>> getEquivalentNodesPartialMap(Equivalences<DataRangeExpression> nodeSet) {
        DataRangeExpression node = (DataRangeExpression)nodeSet.getRepresentative();
        return Stream.concat(MappingOntologyComplianceValidatorImpl.getPredicateIRI(node).map(i -> nodeSet.stream().filter(e -> e != node).filter(e -> e instanceof Datatype).map(e -> (Datatype)e).map(e -> Maps.immutableEntry((Object)i, (Object)e))).orElse(Stream.of(new Map.Entry[0])), MappingOntologyComplianceValidatorImpl.getSub(nodeSet.stream(), node));
    }

    private static Stream<Map.Entry<IRI, Datatype>> getSub(Stream<DataRangeExpression> stream, DataRangeExpression node) {
        return Optional.of(node).filter(n -> n instanceof Datatype).map(n -> (Datatype)n).map(n -> stream.filter(e -> e != n).map(MappingOntologyComplianceValidatorImpl::getPredicateIRI).filter(Optional::isPresent).map(Optional::get).map(i -> Maps.immutableEntry((Object)i, (Object)n))).orElse(Stream.of(new Map.Entry[0]));
    }

    private static Optional<IRI> getPredicateIRI(DataRangeExpression expression) {
        if (expression instanceof Datatype) {
            return Optional.of(((Datatype)expression).getIRI());
        }
        if (expression instanceof DataPropertyRangeExpression) {
            return Optional.of(((DataPropertyRangeExpression)expression).getProperty().getIRI());
        }
        return Optional.empty();
    }

    private static class AbstractTripleObjectTypeException
    extends OntopInternalBugException {
        AbstractTripleObjectTypeException(IRI iri, TermType tripleObjectType) {
            super("Internal bug: abstract type (" + tripleObjectType + ") for " + iri + ". Should have been detected earlier.");
        }
    }

    private static class UndeterminedTripleObjectTypeException
    extends OntopInternalBugException {
        UndeterminedTripleObjectTypeException(IRI iri, TermType tripleObjectType) {
            super("Internal bug: undetermined type (" + tripleObjectType + ") for " + iri);
        }
    }

    private static class TripleObjectTypeInferenceException
    extends OntopInternalBugException {
        TripleObjectTypeInferenceException(IQ mappingAssertion, Variable tripleObjectVariable, String reason) {
            super("Internal bug: cannot infer the type of " + tripleObjectVariable + " in: \n" + mappingAssertion + "\n Reason: " + reason);
        }
    }
}

