/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.spec.mapping.transformer.impl;

import com.google.inject.Inject;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableList;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableMap;
import it.unibz.inf.ontop.exception.MinorOntopInternalBugException;
import it.unibz.inf.ontop.injection.CoreSingletons;
import it.unibz.inf.ontop.injection.IntermediateQueryFactory;
import it.unibz.inf.ontop.iq.IQTree;
import it.unibz.inf.ontop.iq.node.ConstructionNode;
import it.unibz.inf.ontop.iq.node.UnaryOperatorNode;
import it.unibz.inf.ontop.iq.type.UniqueTermTypeExtractor;
import it.unibz.inf.ontop.model.term.ImmutableFunctionalTerm;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.RDFConstant;
import it.unibz.inf.ontop.model.term.RDFTermTypeConstant;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.model.term.functionsymbol.FunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.FunctionSymbolFactory;
import it.unibz.inf.ontop.model.term.functionsymbol.RDFTermFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.DBTypeConversionFunctionSymbol;
import it.unibz.inf.ontop.model.type.DBTermType;
import it.unibz.inf.ontop.model.type.RDFTermType;
import it.unibz.inf.ontop.model.type.TermType;
import it.unibz.inf.ontop.spec.mapping.MappingAssertion;
import it.unibz.inf.ontop.spec.mapping.transformer.MappingCaster;
import it.unibz.inf.ontop.substitution.ImmutableSubstitution;
import it.unibz.inf.ontop.substitution.SubstitutionFactory;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import java.util.Map;
import java.util.Optional;

public class UniqueTermTypeMappingCaster
implements MappingCaster {
    private final FunctionSymbolFactory functionSymbolFactory;
    private final IntermediateQueryFactory iqFactory;
    private final SubstitutionFactory substitutionFactory;
    private final UniqueTermTypeExtractor typeExtractor;
    private final TermFactory termFactory;
    private final DBTermType dBStringType;

    @Inject
    private UniqueTermTypeMappingCaster(FunctionSymbolFactory functionSymbolFactory, CoreSingletons coreSingletons, UniqueTermTypeExtractor typeExtractor) {
        this.functionSymbolFactory = functionSymbolFactory;
        this.iqFactory = coreSingletons.getIQFactory();
        this.substitutionFactory = coreSingletons.getSubstitutionFactory();
        this.typeExtractor = typeExtractor;
        this.termFactory = coreSingletons.getTermFactory();
        this.dBStringType = coreSingletons.getTypeFactory().getDBTypeFactory().getDBStringType();
    }

    @Override
    public MappingAssertion transform(MappingAssertion assertion) {
        RDFTermFunctionSymbol rdfTermFunctionSymbol = this.functionSymbolFactory.getRDFTermFunctionSymbol();
        if (!assertion.getTerms().stream().allMatch(t -> t instanceof ImmutableFunctionalTerm && ((ImmutableFunctionalTerm)t).getFunctionSymbol().equals(rdfTermFunctionSymbol) || t instanceof RDFConstant)) {
            throw new MinorOntopInternalBugException("The root construction node is not defining all the variables with a RDF functional or constant term\n" + assertion);
        }
        IQTree childTree = assertion.getTopChild();
        ImmutableSubstitution<ImmutableTerm> newSubstitution = this.transformTopSubstitution((ImmutableMap<Variable, ImmutableTerm>)assertion.getTopSubstitution().getImmutableMap(), childTree);
        ConstructionNode newRootNode = this.iqFactory.createConstructionNode(assertion.getProjectedVariables(), newSubstitution);
        return assertion.copyOf((IQTree)this.iqFactory.createUnaryIQTree((UnaryOperatorNode)newRootNode, childTree), this.iqFactory);
    }

    private ImmutableSubstitution<ImmutableTerm> transformTopSubstitution(ImmutableMap<Variable, ImmutableTerm> substitutionMap, IQTree childTree) {
        return this.substitutionFactory.getSubstitution((ImmutableMap)substitutionMap.entrySet().stream().collect(ImmutableCollectors.toMap(Map.Entry::getKey, e -> this.transformDefinition((ImmutableTerm)e.getValue(), childTree))));
    }

    private ImmutableTerm transformDefinition(ImmutableTerm rdfTerm, IQTree childTree) {
        if (rdfTerm instanceof ImmutableFunctionalTerm) {
            ImmutableFunctionalTerm rdfTermDefinition = (ImmutableFunctionalTerm)rdfTerm;
            ImmutableTerm uncastLexicalTerm = DBTypeConversionFunctionSymbol.uncast((ImmutableTerm)rdfTermDefinition.getTerm(0));
            ImmutableTerm rdfTypeTerm = rdfTermDefinition.getTerm(1);
            Optional<DBTermType> dbType = this.extractInputDBType(uncastLexicalTerm, childTree);
            RDFTermType rdfType = this.extractRDFTermType(rdfTypeTerm);
            ImmutableTerm newLexicalTerm = this.transformNestedTemporaryCasts(this.transformTopOfLexicalTerm(uncastLexicalTerm, dbType, rdfType), childTree);
            return this.termFactory.getRDFFunctionalTerm(newLexicalTerm, rdfTypeTerm).simplify();
        }
        if (rdfTerm instanceof RDFConstant) {
            return rdfTerm;
        }
        throw new IllegalArgumentException("Was expecting an ImmutableFunctionalTerm or a Constant");
    }

    private Optional<DBTermType> extractInputDBType(ImmutableTerm uncastLexicalTerm, IQTree childTree) {
        Optional type = this.typeExtractor.extractUniqueTermType(uncastLexicalTerm, childTree);
        if (type.filter(t -> !(t instanceof DBTermType)).isPresent()) {
            throw new MinorOntopInternalBugException("Was expecting to get a DBTermType, not a " + ((TermType)type.get()).getClass() + " (" + type.get() + ")");
        }
        return type.map(t -> (DBTermType)t);
    }

    private RDFTermType extractRDFTermType(ImmutableTerm rdfTypeTerm) {
        if (rdfTypeTerm instanceof RDFTermTypeConstant) {
            return ((RDFTermTypeConstant)rdfTypeTerm).getRDFTermType();
        }
        throw new MinorOntopInternalBugException("Was expecting a RDFTermTypeConstant in the RDF term function, not " + rdfTypeTerm);
    }

    private ImmutableTerm transformTopOfLexicalTerm(ImmutableTerm uncastLexicalTerm, Optional<DBTermType> dbType, RDFTermType rdfType) {
        return dbType.map(i -> i.equals(this.dBStringType) ? uncastLexicalTerm : this.termFactory.getConversion2RDFLexical(i, uncastLexicalTerm, rdfType)).orElseGet(() -> this.termFactory.getDBCastFunctionalTerm(this.dBStringType, uncastLexicalTerm));
    }

    private ImmutableTerm transformNestedTemporaryCasts(ImmutableTerm term, IQTree childTree) {
        if (term instanceof ImmutableFunctionalTerm) {
            ImmutableFunctionalTerm functionalTerm = (ImmutableFunctionalTerm)term;
            FunctionSymbol functionSymbol = functionalTerm.getFunctionSymbol();
            if (DBTypeConversionFunctionSymbol.isTemporary((FunctionSymbol)functionSymbol)) {
                DBTypeConversionFunctionSymbol castFunctionSymbol = (DBTypeConversionFunctionSymbol)functionSymbol;
                if (functionSymbol.getArity() != 1) {
                    throw new MinorOntopInternalBugException("The casting function was expected to be unary");
                }
                ImmutableTerm childTerm = functionalTerm.getTerm(0);
                Optional<DBTermType> inputType = this.extractInputDBType(childTerm, childTree);
                return Optional.of(castFunctionSymbol.getTargetType()).filter(targetType -> !inputType.filter(targetType::equals).isPresent()).map(targetType -> inputType.map(i -> this.termFactory.getDBCastFunctionalTerm(i, targetType, childTerm)).orElseGet(() -> this.termFactory.getDBCastFunctionalTerm(targetType, childTerm))).map(t -> t).orElse(childTerm);
            }
            return this.termFactory.getImmutableFunctionalTerm(functionSymbol, (ImmutableList)functionalTerm.getTerms().stream().map(t -> this.transformNestedTemporaryCasts((ImmutableTerm)t, childTree)).collect(ImmutableCollectors.toList()));
        }
        return term;
    }
}

