/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.spec.mapping.transformer.impl;

import it.unibz.inf.ontop.com.google.common.collect.ImmutableList;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableSet;
import it.unibz.inf.ontop.constraints.ImmutableHomomorphism;
import it.unibz.inf.ontop.constraints.ImmutableHomomorphismIterator;
import it.unibz.inf.ontop.constraints.impl.ImmutableCQContainmentCheckUnderLIDs;
import it.unibz.inf.ontop.injection.CoreSingletons;
import it.unibz.inf.ontop.iq.tools.impl.IQ2CQ;
import it.unibz.inf.ontop.model.atom.RelationPredicate;
import it.unibz.inf.ontop.model.term.ImmutableExpression;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.spec.mapping.transformer.impl.TMappingRule;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collector;
import java.util.stream.Stream;

public class TMappingEntry {
    private final List<TMappingRule> rules = new ArrayList<TMappingRule>();
    private final ImmutableCQContainmentCheckUnderLIDs<RelationPredicate> cqc;
    private final TermFactory termFactory;
    private final CoreSingletons coreSingletons;

    public static Collector<TMappingRule, TMappingEntry, ImmutableList<TMappingRule>> toTMappingEntry(ImmutableCQContainmentCheckUnderLIDs<RelationPredicate> cqc, CoreSingletons coreSingletons) {
        return Collector.of(() -> new TMappingEntry(cqc, coreSingletons), TMappingEntry::add, (b1, b2) -> b1.addAll((Iterator<TMappingRule>)b2.build().iterator()), TMappingEntry::build, Collector.Characteristics.UNORDERED);
    }

    public TMappingEntry(ImmutableCQContainmentCheckUnderLIDs<RelationPredicate> cqc, CoreSingletons coreSingletons) {
        this.cqc = cqc;
        this.termFactory = coreSingletons.getTermFactory();
        this.coreSingletons = coreSingletons;
    }

    public TMappingEntry add(TMappingRule rule) {
        this.mergeMappingsWithCQC(rule);
        return this;
    }

    public TMappingEntry addAll(Iterator<TMappingRule> rs) {
        while (rs.hasNext()) {
            this.mergeMappingsWithCQC(rs.next());
        }
        return this;
    }

    public ImmutableList<TMappingRule> build() {
        return ImmutableList.copyOf(this.rules);
    }

    private void mergeMappingsWithCQC(TMappingRule assertion) {
        if (this.rules.contains(assertion)) {
            return;
        }
        if (assertion.getDatabaseAtoms().isEmpty() && assertion.getConditions().isEmpty()) {
            this.rules.add(assertion);
            return;
        }
        Iterator<TMappingRule> mappingIterator = this.rules.iterator();
        while (mappingIterator.hasNext()) {
            Optional<ImmutableHomomorphism> from;
            TMappingRule current = mappingIterator.next();
            boolean couldIgnore = false;
            Optional<ImmutableHomomorphism> to = this.getHomomorphismIterator(current, assertion).filter(ImmutableHomomorphismIterator::hasNext).map(ImmutableHomomorphismIterator::next);
            if (to.isPresent() && (current.getConditions().isEmpty() || current.getConditions().size() == 1 && assertion.getConditions().size() == 1 && ((ImmutableList)current.getConditions().get(0)).stream().map(atom -> ((ImmutableHomomorphism)to.get()).applyToBooleanExpression(atom, this.termFactory)).allMatch(atom -> ((ImmutableList)assertion.getConditions().get(0)).contains(atom)))) {
                if (assertion.getDatabaseAtoms().size() < current.getDatabaseAtoms().size()) {
                    couldIgnore = true;
                } else {
                    return;
                }
            }
            if ((from = this.getHomomorphismIterator(assertion, current).filter(ImmutableHomomorphismIterator::hasNext).map(ImmutableHomomorphismIterator::next)).isPresent() && (assertion.getConditions().isEmpty() || assertion.getConditions().size() == 1 && current.getConditions().size() == 1 && ((ImmutableList)assertion.getConditions().get(0)).stream().map(atom -> ((ImmutableHomomorphism)from.get()).applyToBooleanExpression(atom, this.termFactory)).allMatch(atom -> ((ImmutableList)current.getConditions().get(0)).contains(atom)))) {
                mappingIterator.remove();
                continue;
            }
            if (couldIgnore) {
                return;
            }
            if (!to.isPresent() || !from.isPresent()) continue;
            ImmutableList newf = (ImmutableList)((ImmutableList)assertion.getConditions().get(0)).stream().map(atom -> ((ImmutableHomomorphism)from.get()).applyToBooleanExpression(atom, this.termFactory)).collect(ImmutableCollectors.toList());
            ImmutableSet newfVars = (ImmutableSet)newf.stream().flatMap(ImmutableTerm::getVariableStream).collect(ImmutableCollectors.toSet());
            ImmutableSet ccVars = (ImmutableSet)current.getDatabaseAtoms().stream().flatMap(a -> a.getVariables().stream()).collect(ImmutableCollectors.toSet());
            if (!ccVars.containsAll((Collection)newfVars)) continue;
            if (current.getConditions().stream().anyMatch(arg_0 -> newf.containsAll(arg_0))) {
                return;
            }
            mappingIterator.remove();
            this.rules.add(new TMappingRule(current, (ImmutableList<ImmutableList<ImmutableExpression>>)((ImmutableList)Stream.concat(current.getConditions().stream().filter(f -> !f.containsAll((Collection)newf)), Stream.of(newf)).collect(ImmutableCollectors.toList()))));
            return;
        }
        this.rules.add(assertion);
    }

    private Optional<ImmutableHomomorphismIterator<RelationPredicate>> getHomomorphismIterator(TMappingRule from, TMappingRule to) {
        ImmutableHomomorphism.Builder builder = ImmutableHomomorphism.builder();
        for (int i = 0; i < from.getHeadTerms().size(); ++i) {
            if (builder.extend((ImmutableTerm)from.getHeadTerms().get(i), (ImmutableTerm)to.getHeadTerms().get(i)).isValid()) continue;
            return Optional.empty();
        }
        ImmutableHomomorphism h = builder.build();
        return Optional.of(this.cqc.homomorphismIterator(h, IQ2CQ.toDataAtoms(from.getDatabaseAtoms(), (CoreSingletons)this.coreSingletons), IQ2CQ.toDataAtoms(to.getDatabaseAtoms(), (CoreSingletons)this.coreSingletons)));
    }
}

