/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.spec.mapping.transformer.impl;

import com.google.inject.Inject;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableList;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableSet;
import it.unibz.inf.ontop.injection.CoreSingletons;
import it.unibz.inf.ontop.injection.IntermediateQueryFactory;
import it.unibz.inf.ontop.iq.IQ;
import it.unibz.inf.ontop.iq.IQTree;
import it.unibz.inf.ontop.iq.UnaryIQTree;
import it.unibz.inf.ontop.iq.node.ConstructionNode;
import it.unibz.inf.ontop.iq.node.UnaryOperatorNode;
import it.unibz.inf.ontop.model.atom.DistinctVariableOnlyDataAtom;
import it.unibz.inf.ontop.model.atom.RDFAtomPredicate;
import it.unibz.inf.ontop.model.term.IRIConstant;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.ObjectConstant;
import it.unibz.inf.ontop.spec.mapping.MappingAssertion;
import it.unibz.inf.ontop.spec.mapping.MappingAssertionIndex;
import it.unibz.inf.ontop.spec.mapping.pp.PPMappingAssertionProvenance;
import it.unibz.inf.ontop.spec.mapping.transformer.ABoxFactIntoMappingConverter;
import it.unibz.inf.ontop.spec.ontology.RDFFact;
import it.unibz.inf.ontop.substitution.SubstitutionFactory;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import it.unibz.inf.ontop.utils.VariableGenerator;
import java.util.Collection;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LegacyABoxFactIntoMappingConverter
implements ABoxFactIntoMappingConverter {
    private static final Logger LOGGER = LoggerFactory.getLogger(LegacyABoxFactIntoMappingConverter.class);
    private final IntermediateQueryFactory iqFactory;
    private final SubstitutionFactory substitutionFactory;
    private final DistinctVariableOnlyDataAtom tripleAtom;
    private final DistinctVariableOnlyDataAtom quadAtom;
    private final RDFAtomPredicate rdfAtomPredicate;

    @Inject
    public LegacyABoxFactIntoMappingConverter(CoreSingletons coreSingletons) {
        this.iqFactory = coreSingletons.getIQFactory();
        this.substitutionFactory = coreSingletons.getSubstitutionFactory();
        VariableGenerator projectedVariableGenerator = coreSingletons.getCoreUtilsFactory().createVariableGenerator((Collection)ImmutableSet.of());
        this.tripleAtom = coreSingletons.getAtomFactory().getDistinctTripleAtom(projectedVariableGenerator.generateNewVariable(), projectedVariableGenerator.generateNewVariable(), projectedVariableGenerator.generateNewVariable());
        this.quadAtom = coreSingletons.getAtomFactory().getDistinctQuadAtom(projectedVariableGenerator.generateNewVariable(), projectedVariableGenerator.generateNewVariable(), projectedVariableGenerator.generateNewVariable(), projectedVariableGenerator.generateNewVariable());
        this.rdfAtomPredicate = (RDFAtomPredicate)this.tripleAtom.getPredicate();
    }

    @Override
    public ImmutableList<MappingAssertion> convert(ImmutableSet<RDFFact> facts, boolean isOntologyAnnotationQueryingEnabled) {
        ImmutableList assertions = (ImmutableList)facts.stream().map(fact -> new MappingAssertion(fact.isClassAssertion() ? MappingAssertionIndex.ofClass(this.rdfAtomPredicate, Optional.of(fact.getClassOrProperty()).filter(c -> c instanceof IRIConstant).map(c -> ((IRIConstant)c).getIRI()).orElseThrow(() -> new RuntimeException("TODO: support bnode for classes as mapping assertion index"))) : MappingAssertionIndex.ofProperty(this.rdfAtomPredicate, fact.getProperty().getIRI()), this.createIQ((RDFFact)fact), new ABoxFactProvenance((RDFFact)fact))).collect(ImmutableCollectors.toList());
        LOGGER.debug("Appended {} assertions as fact rules", (Object)facts.size());
        return assertions;
    }

    private IQ createIQ(RDFFact rdfFact) {
        return rdfFact.getGraph().map(g -> this.createQuad(rdfFact, (ObjectConstant)g)).orElseGet(() -> this.createTriple(rdfFact));
    }

    private IQ createTriple(RDFFact rdfFact) {
        ConstructionNode topConstructionNode = this.iqFactory.createConstructionNode(this.tripleAtom.getVariables(), this.substitutionFactory.getSubstitution(this.tripleAtom.getTerm(0), (ImmutableTerm)rdfFact.getSubject(), this.tripleAtom.getTerm(1), (ImmutableTerm)rdfFact.getProperty(), this.tripleAtom.getTerm(2), (ImmutableTerm)rdfFact.getObject()));
        UnaryIQTree constructionTree = this.iqFactory.createUnaryIQTree((UnaryOperatorNode)topConstructionNode, (IQTree)this.iqFactory.createTrueNode());
        return this.iqFactory.createIQ(this.tripleAtom, (IQTree)constructionTree);
    }

    private IQ createQuad(RDFFact rdfFact, ObjectConstant graph) {
        ConstructionNode topConstructionNode = this.iqFactory.createConstructionNode(this.tripleAtom.getVariables(), this.substitutionFactory.getSubstitution(this.tripleAtom.getTerm(0), (ImmutableTerm)rdfFact.getSubject(), this.tripleAtom.getTerm(1), (ImmutableTerm)rdfFact.getProperty(), this.tripleAtom.getTerm(2), (ImmutableTerm)rdfFact.getObject(), this.tripleAtom.getTerm(3), (ImmutableTerm)graph));
        UnaryIQTree constructionTree = this.iqFactory.createUnaryIQTree((UnaryOperatorNode)topConstructionNode, (IQTree)this.iqFactory.createTrueNode());
        return this.iqFactory.createIQ(this.quadAtom, (IQTree)constructionTree);
    }

    private class ABoxFactProvenance
    implements PPMappingAssertionProvenance {
        private final String provenance;

        private ABoxFactProvenance(RDFFact a) {
            this.provenance = a.toString();
        }

        @Override
        public String getProvenanceInfo() {
            return this.provenance;
        }
    }
}

