/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.spec.mapping.transformer.impl;

import com.google.inject.Inject;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableList;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableSet;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableTable;
import it.unibz.inf.ontop.com.google.common.collect.Table;
import it.unibz.inf.ontop.com.google.common.collect.Tables;
import it.unibz.inf.ontop.dbschema.DBParameters;
import it.unibz.inf.ontop.injection.OntopMappingSettings;
import it.unibz.inf.ontop.injection.OntopModelSettings;
import it.unibz.inf.ontop.injection.SpecificationFactory;
import it.unibz.inf.ontop.iq.IQ;
import it.unibz.inf.ontop.model.atom.RDFAtomPredicate;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.spec.OBDASpecification;
import it.unibz.inf.ontop.spec.mapping.Mapping;
import it.unibz.inf.ontop.spec.mapping.MappingAssertion;
import it.unibz.inf.ontop.spec.mapping.MappingAssertionIndex;
import it.unibz.inf.ontop.spec.mapping.impl.MappingImpl;
import it.unibz.inf.ontop.spec.mapping.transformer.ABoxFactIntoMappingConverter;
import it.unibz.inf.ontop.spec.mapping.transformer.MappingDistinctTransformer;
import it.unibz.inf.ontop.spec.mapping.transformer.MappingSameAsInverseRewriter;
import it.unibz.inf.ontop.spec.mapping.transformer.MappingSaturator;
import it.unibz.inf.ontop.spec.mapping.transformer.MappingTransformer;
import it.unibz.inf.ontop.spec.mapping.transformer.MappingVariableNameNormalizer;
import it.unibz.inf.ontop.spec.ontology.ClassifiedTBox;
import it.unibz.inf.ontop.spec.ontology.Ontology;
import it.unibz.inf.ontop.spec.ontology.OntologyVocabularyCategory;
import it.unibz.inf.ontop.spec.ontology.RDFFact;
import it.unibz.inf.ontop.spec.ontology.impl.OntologyBuilderImpl;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.commons.rdf.api.IRI;
import org.apache.commons.rdf.api.RDF;

public class DefaultMappingTransformer
implements MappingTransformer {
    private final MappingVariableNameNormalizer mappingNormalizer;
    private final MappingSaturator mappingSaturator;
    private final ABoxFactIntoMappingConverter factConverter;
    private final OntopMappingSettings settings;
    private final MappingSameAsInverseRewriter sameAsInverseRewriter;
    private final SpecificationFactory specificationFactory;
    private final RDF rdfFactory;
    private MappingDistinctTransformer mappingDistinctTransformer;
    private final TermFactory termFactory;

    @Inject
    private DefaultMappingTransformer(MappingVariableNameNormalizer mappingNormalizer, MappingSaturator mappingSaturator, ABoxFactIntoMappingConverter inserter, OntopMappingSettings settings, MappingSameAsInverseRewriter sameAsInverseRewriter, SpecificationFactory specificationFactory, RDF rdfFactory, MappingDistinctTransformer mappingDistinctTransformer, TermFactory termFactory) {
        this.mappingNormalizer = mappingNormalizer;
        this.mappingSaturator = mappingSaturator;
        this.factConverter = inserter;
        this.settings = settings;
        this.sameAsInverseRewriter = sameAsInverseRewriter;
        this.specificationFactory = specificationFactory;
        this.rdfFactory = rdfFactory;
        this.mappingDistinctTransformer = mappingDistinctTransformer;
        this.termFactory = termFactory;
    }

    @Override
    public OBDASpecification transform(ImmutableList<MappingAssertion> mapping, DBParameters dbParameters, Optional<Ontology> ontology) {
        if (ontology.isPresent()) {
            ImmutableList<MappingAssertion> factsAsMapping = this.factConverter.convert(this.extractAboxFacts(ontology.get()), true);
            ImmutableList mappingWithFacts = (ImmutableList)Stream.concat(mapping.stream(), factsAsMapping.stream()).collect(ImmutableCollectors.toList());
            return this.createSpecification((ImmutableList<MappingAssertion>)mappingWithFacts, dbParameters, ontology.get().tbox());
        }
        ClassifiedTBox emptyTBox = OntologyBuilderImpl.builder((RDF)this.rdfFactory, (TermFactory)this.termFactory).build().tbox();
        return this.createSpecification(mapping, dbParameters, emptyTBox);
    }

    protected ImmutableSet<RDFFact> extractAboxFacts(Ontology ontology) {
        if (this.settings.isOntologyAnnotationQueryingEnabled()) {
            return ontology.abox();
        }
        OntologyVocabularyCategory annotationProperties = ontology.annotationProperties();
        return (ImmutableSet)ontology.abox().stream().filter(f -> !annotationProperties.contains(f.getProperty().getIRI())).collect(ImmutableCollectors.toSet());
    }

    private OBDASpecification createSpecification(ImmutableList<MappingAssertion> mapping, DBParameters dbParameters, ClassifiedTBox tbox) {
        ImmutableList<MappingAssertion> sameAsOptimizedMapping = this.sameAsInverseRewriter.rewrite(mapping);
        ImmutableList<MappingAssertion> saturatedMapping = this.mappingSaturator.saturate(sameAsOptimizedMapping, tbox);
        ImmutableList<MappingAssertion> normalizedMapping = this.mappingNormalizer.normalize(saturatedMapping);
        ImmutableList<MappingAssertion> finalMapping = this.settings.getCardinalityPreservationMode() == OntopModelSettings.CardinalityPreservationMode.LOOSE ? normalizedMapping : this.mappingDistinctTransformer.addDistinct(normalizedMapping);
        return this.specificationFactory.createSpecification(this.getMapping(finalMapping), dbParameters, tbox);
    }

    private Mapping getMapping(ImmutableList<MappingAssertion> assertions) {
        ImmutableTable propertyDefinitions = (ImmutableTable)assertions.stream().filter(e -> !e.getIndex().isClass()).map(DefaultMappingTransformer::asCell).collect(ImmutableCollectors.toTable());
        ImmutableTable classDefinitions = (ImmutableTable)assertions.stream().filter(e -> e.getIndex().isClass()).map(DefaultMappingTransformer::asCell).collect(ImmutableCollectors.toTable());
        return new MappingImpl(propertyDefinitions, classDefinitions);
    }

    private static Table.Cell<RDFAtomPredicate, IRI, IQ> asCell(MappingAssertion assertion) {
        MappingAssertionIndex index = assertion.getIndex();
        return Tables.immutableCell((Object)index.getPredicate(), (Object)index.getIri(), (Object)assertion.getQuery());
    }
}

