/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.spec.mapping.parser.impl;

import it.unibz.inf.ontop.com.google.common.collect.ImmutableList;
import it.unibz.inf.ontop.exception.TargetQueryParserException;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.spec.mapping.TargetAtom;
import it.unibz.inf.ontop.spec.mapping.TargetAtomFactory;
import it.unibz.inf.ontop.spec.mapping.parser.TargetQueryParser;
import it.unibz.inf.ontop.spec.mapping.parser.impl.TurtleOBDALexer;
import it.unibz.inf.ontop.spec.mapping.parser.impl.TurtleOBDAParser;
import it.unibz.inf.ontop.spec.mapping.parser.impl.TurtleOBDASQLVisitor;
import it.unibz.inf.ontop.spec.mapping.parser.impl.TurtleOBDAVisitor;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.BaseErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CodePointCharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.misc.ParseCancellationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTurtleOBDAParser
implements TargetQueryParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractTurtleOBDAParser.class);
    private final Supplier<TurtleOBDAVisitor<ImmutableTerm>> termVisitorSupplier;
    private final TargetAtomFactory targetAtomFactory;

    public AbstractTurtleOBDAParser(TargetAtomFactory targetAtomFactory, Supplier<TurtleOBDAVisitor<ImmutableTerm>> termVisitorSupplier) {
        this.targetAtomFactory = targetAtomFactory;
        this.termVisitorSupplier = termVisitorSupplier;
    }

    @Override
    public ImmutableList<TargetAtom> parse(String input) throws TargetQueryParserException {
        try {
            CodePointCharStream inputStream = CharStreams.fromString((String)input);
            TurtleOBDALexer lexer = new TurtleOBDALexer((CharStream)inputStream);
            lexer.removeErrorListeners();
            lexer.addErrorListener((ANTLRErrorListener)new ThrowingErrorListener());
            CommonTokenStream tokenStream = new CommonTokenStream((TokenSource)lexer);
            TurtleOBDAParser parser = new TurtleOBDAParser((TokenStream)tokenStream);
            parser.removeErrorListeners();
            parser.addErrorListener((ANTLRErrorListener)new ThrowingErrorListener());
            TurtleOBDASQLVisitor visitor = new TurtleOBDASQLVisitor(this.targetAtomFactory, this.termVisitorSupplier.get());
            return (ImmutableList)((Stream)visitor.visitParse(parser.parse())).collect(ImmutableCollectors.toList());
        }
        catch (ParseCancellationException e) {
            throw (TargetQueryParserException)e.getCause();
        }
        catch (RuntimeException e) {
            throw new TargetQueryParserException(e.getMessage(), e);
        }
    }

    private static class ThrowingErrorListener
    extends BaseErrorListener {
        private ThrowingErrorListener() {
        }

        public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String msg, RecognitionException e) throws ParseCancellationException {
            LOGGER.debug("Syntax error location: column {}, line {}\n{}", new Object[]{charPositionInLine, line, msg});
            throw new ParseCancellationException(msg, (Throwable)new TargetQueryParserException(line, charPositionInLine, msg, e));
        }
    }
}

