/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.injection.impl;

import com.google.inject.Injector;
import com.google.inject.Module;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableMap;
import it.unibz.inf.ontop.exception.InvalidOntopConfigurationException;
import it.unibz.inf.ontop.exception.MissingInputMappingException;
import it.unibz.inf.ontop.exception.OBDASpecificationException;
import it.unibz.inf.ontop.injection.OntopMappingConfiguration;
import it.unibz.inf.ontop.injection.OntopMappingSettings;
import it.unibz.inf.ontop.injection.OntopModelConfiguration;
import it.unibz.inf.ontop.injection.OntopOBDASettings;
import it.unibz.inf.ontop.injection.OntopOptimizationConfiguration;
import it.unibz.inf.ontop.injection.OntopOptimizationSettings;
import it.unibz.inf.ontop.injection.impl.OntologySupplier;
import it.unibz.inf.ontop.injection.impl.OntopMappingModule;
import it.unibz.inf.ontop.injection.impl.OntopMappingSettingsImpl;
import it.unibz.inf.ontop.injection.impl.OntopModelConfigurationImpl;
import it.unibz.inf.ontop.injection.impl.OntopOBDAConfigurationImpl;
import it.unibz.inf.ontop.injection.impl.OntopOptimizationConfigurationImpl;
import it.unibz.inf.ontop.iq.executor.ProposalExecutor;
import it.unibz.inf.ontop.iq.proposal.QueryOptimizationProposal;
import it.unibz.inf.ontop.spec.OBDASpecInput;
import it.unibz.inf.ontop.spec.OBDASpecification;
import it.unibz.inf.ontop.spec.OBDASpecificationExtractor;
import it.unibz.inf.ontop.spec.mapping.TMappingExclusionConfig;
import it.unibz.inf.ontop.spec.mapping.pp.PreProcessedMapping;
import it.unibz.inf.ontop.spec.ontology.Ontology;
import java.io.File;
import java.io.Reader;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.apache.commons.rdf.api.Graph;

public class OntopMappingConfigurationImpl
extends OntopOBDAConfigurationImpl
implements OntopMappingConfiguration {
    private final OntopMappingSettings settings;
    private final OntopMappingOptions options;
    private final OntopOptimizationConfigurationImpl optimizationConfiguration;

    OntopMappingConfigurationImpl(OntopMappingSettings settings, OntopMappingOptions options) {
        super((OntopOBDASettings)settings, options.obdaOptions);
        this.settings = settings;
        this.options = options;
        this.optimizationConfiguration = new OntopOptimizationConfigurationImpl((OntopOptimizationSettings)settings, options.optimizationOptions);
    }

    OntopMappingConfigurationImpl(OntopMappingSettings settings, OntopMappingOptions options, Supplier<Injector> injectorSupplier) {
        super((OntopOBDASettings)settings, options.obdaOptions, injectorSupplier);
        this.settings = settings;
        this.options = options;
        this.optimizationConfiguration = new OntopOptimizationConfigurationImpl((OntopOptimizationSettings)settings, options.optimizationOptions);
    }

    @Override
    public Optional<TMappingExclusionConfig> getTmappingExclusions() {
        return this.options.excludeFromTMappings;
    }

    @Override
    public OntopMappingSettings getSettings() {
        return this.settings;
    }

    protected ImmutableMap<Class<? extends QueryOptimizationProposal>, Class<? extends ProposalExecutor>> generateOptimizationConfigurationMap() {
        ImmutableMap.Builder internalExecutorMapBuilder = ImmutableMap.builder();
        internalExecutorMapBuilder.putAll((Map)super.generateOptimizationConfigurationMap());
        internalExecutorMapBuilder.putAll((Map)this.optimizationConfiguration.generateOptimizationConfigurationMap());
        return internalExecutorMapBuilder.build();
    }

    protected OBDASpecification loadOBDASpecification() throws OBDASpecificationException {
        return this.loadSpecification(Optional::empty, Optional::empty, Optional::empty, Optional::empty, Optional::empty, Optional::empty, Optional::empty, Optional::empty, Optional::empty, Optional::empty);
    }

    OBDASpecification loadSpecification(OntologySupplier ontologySupplier, Supplier<Optional<PreProcessedMapping>> ppMappingSupplier, Supplier<Optional<File>> mappingFileSupplier, Supplier<Optional<Reader>> mappingReaderSupplier, Supplier<Optional<Graph>> mappingGraphSupplier, Supplier<Optional<File>> constraintFileSupplier, Supplier<Optional<File>> dbMetadataFileSupplier, Supplier<Optional<Reader>> dbMetadataReaderSupplier, Supplier<Optional<File>> ontopViewFileSupplier, Supplier<Optional<Reader>> ontopViewReaderSupplier) throws OBDASpecificationException {
        OBDASpecificationExtractor extractor = (OBDASpecificationExtractor)this.getInjector().getInstance(OBDASpecificationExtractor.class);
        Optional<Ontology> optionalOntology = ontologySupplier.get();
        Optional<PreProcessedMapping> optionalPPMapping = ppMappingSupplier.get();
        OBDASpecInput.Builder specInputBuilder = OBDASpecInput.defaultBuilder();
        constraintFileSupplier.get().ifPresent(specInputBuilder::addConstraintFile);
        dbMetadataFileSupplier.get().ifPresent(specInputBuilder::addDBMetadataFile);
        dbMetadataReaderSupplier.get().ifPresent(specInputBuilder::addDBMetadataReader);
        ontopViewFileSupplier.get().ifPresent(specInputBuilder::addOntopViewFile);
        ontopViewReaderSupplier.get().ifPresent(specInputBuilder::addOntopViewReader);
        if (optionalPPMapping.isPresent()) {
            PreProcessedMapping ppMapping = optionalPPMapping.get();
            return extractor.extract(specInputBuilder.build(), ppMapping, optionalOntology, this.getExecutorRegistry());
        }
        Optional<File> optionalMappingFile = mappingFileSupplier.get();
        if (optionalMappingFile.isPresent()) {
            specInputBuilder.addMappingFile(optionalMappingFile.get());
            return extractor.extract(specInputBuilder.build(), optionalOntology, this.getExecutorRegistry());
        }
        Optional<Reader> optionalMappingReader = mappingReaderSupplier.get();
        if (optionalMappingReader.isPresent()) {
            specInputBuilder.addMappingReader(optionalMappingReader.get());
            return extractor.extract(specInputBuilder.build(), optionalOntology, this.getExecutorRegistry());
        }
        Optional<Graph> optionalMappingGraph = mappingGraphSupplier.get();
        if (optionalMappingGraph.isPresent()) {
            specInputBuilder.addMappingGraph(optionalMappingGraph.get());
            return extractor.extract(specInputBuilder.build(), optionalOntology, this.getExecutorRegistry());
        }
        throw new MissingInputMappingException();
    }

    protected Stream<Module> buildGuiceModules() {
        return Stream.concat(Stream.concat(super.buildGuiceModules(), this.optimizationConfiguration.buildGuiceModules()), Stream.of(new OntopMappingModule(this)));
    }

    public static class BuilderImpl<B extends OntopMappingConfiguration.Builder<B>>
    extends OntopMappingBuilderMixin<B> {
        @Override
        public OntopMappingConfiguration build() {
            Properties properties = this.generateProperties();
            OntopMappingSettingsImpl settings = new OntopMappingSettingsImpl(properties);
            OntopMappingOptions options = this.generateMappingOptions();
            return new OntopMappingConfigurationImpl(settings, options);
        }
    }

    static abstract class OntopMappingBuilderMixin<B extends OntopMappingConfiguration.Builder<B>>
    extends OntopOBDAConfigurationImpl.OntopOBDAConfigurationBuilderMixin<B>
    implements OntopMappingConfiguration.Builder<B> {
        private final DefaultOntopMappingBuilderFragment<B> mappingBuilderFragment;
        private final OntopOptimizationConfigurationImpl.DefaultOntopOptimizationBuilderFragment<B> optimizationBuilderFragment;
        private final OntopModelConfigurationImpl.DefaultOntopModelBuilderFragment<B> modelBuilderFragment;
        private boolean isMappingDefined;
        private boolean isDBMetadataDefined;
        private boolean isOntopViewDefined;

        OntopMappingBuilderMixin() {
            OntopMappingBuilderMixin builder = this;
            this.mappingBuilderFragment = new DefaultOntopMappingBuilderFragment<OntopMappingBuilderMixin>(builder, this::declareDBMetadataDefined);
            this.optimizationBuilderFragment = new OntopOptimizationConfigurationImpl.DefaultOntopOptimizationBuilderFragment((OntopOptimizationConfiguration.Builder)builder);
            this.modelBuilderFragment = new OntopModelConfigurationImpl.DefaultOntopModelBuilderFragment((OntopModelConfiguration.Builder)builder);
            this.isMappingDefined = false;
            this.isDBMetadataDefined = false;
        }

        @Override
        public B tMappingExclusionConfig(@Nonnull TMappingExclusionConfig config) {
            return this.mappingBuilderFragment.tMappingExclusionConfig(config);
        }

        @Override
        public B enableOntologyAnnotationQuerying(boolean queryingAnnotationsInOntology) {
            return this.mappingBuilderFragment.enableOntologyAnnotationQuerying(queryingAnnotationsInOntology);
        }

        @Override
        public B enableDefaultDatatypeInference(boolean inferDefaultDatatype) {
            return this.mappingBuilderFragment.enableDefaultDatatypeInference(inferDefaultDatatype);
        }

        final OntopMappingOptions generateMappingOptions() {
            return this.generateMappingOptions(this.generateOBDAOptions());
        }

        final OntopMappingOptions generateMappingOptions(OntopOBDAConfigurationImpl.OntopOBDAOptions obdaOptions) {
            return this.generateMappingOptions(obdaOptions, this.optimizationBuilderFragment.generateOptimizationOptions(obdaOptions.modelOptions));
        }

        final OntopMappingOptions generateMappingOptions(OntopOBDAConfigurationImpl.OntopOBDAOptions obdaOptions, OntopOptimizationConfigurationImpl.OntopOptimizationOptions optimizationOptions) {
            return this.mappingBuilderFragment.generateMappingOptions(obdaOptions, optimizationOptions);
        }

        protected Properties generateProperties() {
            Properties properties = new Properties();
            properties.putAll((Map<?, ?>)super.generateProperties());
            properties.putAll((Map<?, ?>)this.modelBuilderFragment.generateProperties());
            properties.putAll((Map<?, ?>)this.mappingBuilderFragment.generateProperties());
            properties.putAll((Map<?, ?>)this.optimizationBuilderFragment.generateProperties());
            return properties;
        }

        final void declareDBMetadataDefined() {
            if (this.isOBDASpecificationAssigned()) {
                throw new InvalidOntopConfigurationException("The OBDA specification has already been assigned");
            }
            this.isDBMetadataDefined = true;
        }

        final void declareOntopViewDefined() {
            if (this.isOBDASpecificationAssigned()) {
                throw new InvalidOntopConfigurationException("The OBDA specification has already been assigned");
            }
            this.isOntopViewDefined = true;
        }

        void declareOBDASpecificationAssigned() {
            super.declareOBDASpecificationAssigned();
            if (this.isDBMetadataDefined) {
                throw new InvalidOntopConfigurationException("DBMetadata is already defined, cannot assign the OBDA specification");
            }
            if (this.isMappingDefined()) {
                throw new InvalidOntopConfigurationException("The mapping is already defined, cannot assign the OBDA specification");
            }
            if (this.isOntopViewDefined) {
                throw new InvalidOntopConfigurationException("Ontop views are already defined, cannot assign the OBDA specification");
            }
        }

        protected final void declareMappingDefined() {
            if (this.isOBDASpecificationAssigned()) {
                throw new InvalidOntopConfigurationException("The OBDA specification has already been assigned");
            }
            if (this.isMappingDefined) {
                throw new InvalidOntopConfigurationException("The mapping is already defined");
            }
            this.isMappingDefined = true;
        }

        protected final boolean isMappingDefined() {
            return this.isMappingDefined;
        }

        public B properties(@Nonnull Properties properties) {
            return (B)((OntopMappingConfiguration.Builder)this.modelBuilderFragment.properties(properties));
        }

        public B propertyFile(String propertyFilePath) {
            return (B)((OntopMappingConfiguration.Builder)this.modelBuilderFragment.propertyFile(propertyFilePath));
        }

        public B propertyFile(File propertyFile) {
            return (B)((OntopMappingConfiguration.Builder)this.modelBuilderFragment.propertyFile(propertyFile));
        }

        public B enableTestMode() {
            return (B)((OntopMappingConfiguration.Builder)this.modelBuilderFragment.enableTestMode());
        }
    }

    static class DefaultOntopMappingBuilderFragment<B extends OntopMappingConfiguration.Builder<B>>
    implements OntopMappingConfiguration.OntopMappingBuilderFragment<B> {
        private final B builder;
        private Optional<Boolean> queryingAnnotationsInOntology = Optional.empty();
        private Optional<Boolean> inferDefaultDatatype = Optional.empty();
        private Optional<TMappingExclusionConfig> excludeFromTMappings = Optional.empty();

        DefaultOntopMappingBuilderFragment(B builder, Runnable declareDBMetadataCB) {
            this.builder = builder;
        }

        @Override
        public B tMappingExclusionConfig(@Nonnull TMappingExclusionConfig config) {
            this.excludeFromTMappings = Optional.of(config);
            return this.builder;
        }

        @Override
        public B enableOntologyAnnotationQuerying(boolean queryingAnnotationsInOntology) {
            this.queryingAnnotationsInOntology = Optional.of(queryingAnnotationsInOntology);
            return this.builder;
        }

        @Override
        public B enableDefaultDatatypeInference(boolean inferDefaultDatatype) {
            this.inferDefaultDatatype = Optional.of(inferDefaultDatatype);
            return this.builder;
        }

        final OntopMappingOptions generateMappingOptions(OntopOBDAConfigurationImpl.OntopOBDAOptions obdaOptions, OntopOptimizationConfigurationImpl.OntopOptimizationOptions optimizationOptions) {
            return new OntopMappingOptions(this.excludeFromTMappings, obdaOptions, optimizationOptions);
        }

        Properties generateProperties() {
            Properties properties = new Properties();
            this.queryingAnnotationsInOntology.ifPresent(b -> properties.put("ontop.queryOntologyAnnotation", b));
            this.inferDefaultDatatype.ifPresent(b -> properties.put("ontop.inferDefaultDatatype", b));
            return properties;
        }
    }

    static class OntopMappingOptions {
        final OntopOBDAConfigurationImpl.OntopOBDAOptions obdaOptions;
        final OntopOptimizationConfigurationImpl.OntopOptimizationOptions optimizationOptions;
        private final Optional<TMappingExclusionConfig> excludeFromTMappings;

        private OntopMappingOptions(Optional<TMappingExclusionConfig> excludeFromTMappings, OntopOBDAConfigurationImpl.OntopOBDAOptions obdaOptions, OntopOptimizationConfigurationImpl.OntopOptimizationOptions optimizationOptions) {
            this.excludeFromTMappings = excludeFromTMappings;
            this.obdaOptions = obdaOptions;
            this.optimizationOptions = optimizationOptions;
        }
    }
}

