/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.spec.mapping.transformer.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Inject;
import it.unibz.inf.ontop.constraints.ImmutableCQ;
import it.unibz.inf.ontop.constraints.ImmutableCQContainmentCheck;
import it.unibz.inf.ontop.injection.CoreSingletons;
import it.unibz.inf.ontop.injection.IntermediateQueryFactory;
import it.unibz.inf.ontop.iq.IQ;
import it.unibz.inf.ontop.iq.IQTree;
import it.unibz.inf.ontop.iq.node.ConstructionNode;
import it.unibz.inf.ontop.iq.node.ExtensionalDataNode;
import it.unibz.inf.ontop.iq.node.InnerJoinNode;
import it.unibz.inf.ontop.iq.transform.IQTreeVisitingTransformer;
import it.unibz.inf.ontop.iq.transform.impl.LazyRecursiveIQTreeVisitingTransformer;
import it.unibz.inf.ontop.model.atom.RelationPredicate;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.spec.mapping.transformer.MappingCQCOptimizer;
import it.unibz.inf.ontop.spec.mapping.transformer.impl.IQ2CQ;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import java.util.Collection;
import java.util.Optional;
import java.util.stream.Stream;

public class MappingCQCOptimizerImpl
implements MappingCQCOptimizer {
    private final IntermediateQueryFactory iqFactory;
    private final CoreSingletons coreSingletons;

    @Inject
    public MappingCQCOptimizerImpl(IntermediateQueryFactory iqFactory, CoreSingletons coreSingletons) {
        this.iqFactory = iqFactory;
        this.coreSingletons = coreSingletons;
    }

    @Override
    public IQ optimize(final ImmutableCQContainmentCheck<RelationPredicate> cqContainmentCheck, IQ query) {
        IQTree tree = query.getTree();
        final ConstructionNode constructionNode = (ConstructionNode)tree.getRootNode();
        return this.iqFactory.createIQ(query.getProjectionAtom(), tree.acceptTransformer((IQTreeVisitingTransformer)new LazyRecursiveIQTreeVisitingTransformer(this.iqFactory){

            public IQTree transformInnerJoin(IQTree tree, InnerJoinNode rootNode, ImmutableList<IQTree> children0) {
                Optional<ImmutableList<ExtensionalDataNode>> c = IQ2CQ.getExtensionalDataNodes(tree);
                ImmutableList answerVariables = (ImmutableList)Stream.concat(constructionNode.getSubstitution().getImmutableMap().values().stream().flatMap(ImmutableTerm::getVariableStream), rootNode.getOptionalFilterCondition().map(ImmutableTerm::getVariableStream).orElse(Stream.of(new Variable[0]))).distinct().collect(ImmutableCollectors.toList());
                ImmutableList children = c.get();
                int currentIndex = 0;
                while (currentIndex < children.size()) {
                    ImmutableList.Builder builder = ImmutableList.builder();
                    for (int i = 0; i < children.size(); ++i) {
                        if (i == currentIndex) continue;
                        builder.add(children.get(i));
                    }
                    ImmutableList subChildren = builder.build();
                    if (((ImmutableSet)subChildren.stream().flatMap(a -> a.getVariables().stream()).collect(ImmutableCollectors.toSet())).containsAll((Collection)answerVariables)) {
                        if (cqContainmentCheck.isContainedIn(new ImmutableCQ(answerVariables, IQ2CQ.toDataAtoms((ImmutableList<ExtensionalDataNode>)subChildren, MappingCQCOptimizerImpl.this.coreSingletons)), new ImmutableCQ(answerVariables, IQ2CQ.toDataAtoms(children, MappingCQCOptimizerImpl.this.coreSingletons)))) {
                            System.out.println("CQC-REMOVED: " + children.get(currentIndex) + " FROM " + children);
                            children = subChildren;
                            if (children.size() < 2) break;
                            currentIndex = 0;
                            continue;
                        }
                        ++currentIndex;
                        continue;
                    }
                    ++currentIndex;
                }
                return IQ2CQ.toIQTree(children, rootNode.getOptionalFilterCondition(), this.iqFactory);
            }
        }));
    }
}

