/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.spec.mapping.parser.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import it.unibz.inf.ontop.exception.TargetQueryParserException;
import it.unibz.inf.ontop.model.vocabulary.OntopInternal;
import it.unibz.inf.ontop.spec.mapping.TargetAtom;
import it.unibz.inf.ontop.spec.mapping.parser.TargetQueryParser;
import it.unibz.inf.ontop.spec.mapping.parser.impl.TurtleOBDALexer;
import it.unibz.inf.ontop.spec.mapping.parser.impl.TurtleOBDAParser;
import it.unibz.inf.ontop.spec.mapping.parser.impl.TurtleOBDAVisitor;
import it.unibz.inf.ontop.spec.mapping.parser.impl.listener.ThrowingErrorListener;
import java.util.function.Supplier;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CodePointCharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;

public abstract class AbstractTurtleOBDAParser
implements TargetQueryParser {
    private final ImmutableMap<String, String> prefixes;
    private final Supplier<TurtleOBDAVisitor> visitorSupplier;

    public AbstractTurtleOBDAParser(ImmutableMap<String, String> prefixes, Supplier<TurtleOBDAVisitor> visitorSupplier) {
        this.prefixes = prefixes;
        this.visitorSupplier = visitorSupplier;
    }

    @Override
    public ImmutableList<TargetAtom> parse(String input) throws TargetQueryParserException {
        StringBuffer bf = new StringBuffer(input.trim());
        if (!bf.substring(bf.length() - 2, bf.length()).equals(" .")) {
            bf.insert(bf.length() - 1, ' ');
        }
        if (!this.prefixes.isEmpty()) {
            this.appendDirectives(bf);
        }
        try {
            CodePointCharStream inputStream = CharStreams.fromString((String)bf.toString());
            TurtleOBDALexer lexer = new TurtleOBDALexer((CharStream)inputStream);
            lexer.removeErrorListeners();
            lexer.addErrorListener((ANTLRErrorListener)ThrowingErrorListener.INSTANCE);
            CommonTokenStream tokenStream = new CommonTokenStream((TokenSource)lexer);
            TurtleOBDAParser parser = new TurtleOBDAParser((TokenStream)tokenStream);
            parser.removeErrorListeners();
            parser.addErrorListener((ANTLRErrorListener)ThrowingErrorListener.INSTANCE);
            return (ImmutableList)this.visitorSupplier.get().visitParse(parser.parse());
        }
        catch (RuntimeException e) {
            throw new TargetQueryParserException(e.getMessage(), e);
        }
    }

    private void appendDirectives(StringBuffer query) {
        StringBuffer sb = new StringBuffer();
        for (String prefix : this.prefixes.keySet()) {
            sb.append("@PREFIX");
            sb.append(" ");
            sb.append(prefix);
            sb.append(" ");
            sb.append("<");
            sb.append((String)this.prefixes.get((Object)prefix));
            sb.append(">");
            sb.append(" .\n");
        }
        sb.append("@PREFIX " + OntopInternal.PREFIX_XSD + " <" + "http://www.w3.org/2001/XMLSchema#" + "> .\n");
        sb.append("@PREFIX " + OntopInternal.PREFIX_OBDA + " <" + "https://w3id.org/obda/vocabulary#" + "> .\n");
        sb.append("@PREFIX " + OntopInternal.PREFIX_RDF + " <" + "http://www.w3.org/1999/02/22-rdf-syntax-ns#" + "> .\n");
        sb.append("@PREFIX " + OntopInternal.PREFIX_RDFS + " <" + "http://www.w3.org/2000/01/rdf-schema#" + "> .\n");
        sb.append("@PREFIX " + OntopInternal.PREFIX_OWL + " <" + "http://www.w3.org/2002/07/owl#" + "> .\n");
        query.insert(0, sb);
    }
}

