/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.spec.dbschema.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import it.unibz.inf.ontop.dbschema.MetadataProvider;
import it.unibz.inf.ontop.dbschema.QuotedIDFactory;
import it.unibz.inf.ontop.exception.MetadataExtractionException;
import it.unibz.inf.ontop.spec.dbschema.ImplicitDBConstraintsProviderFactory;
import it.unibz.inf.ontop.spec.dbschema.impl.ImplicitDBConstraintsProvider;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class ImplicitDBConstraintsProviderFactoryImpl
implements ImplicitDBConstraintsProviderFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(ImplicitDBConstraintsProviderFactoryImpl.class);

    @Inject
    private ImplicitDBConstraintsProviderFactoryImpl() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public MetadataProvider extract(Optional<File> constraintFile, MetadataProvider baseMetadataProvider) throws MetadataExtractionException {
        if (!constraintFile.isPresent()) {
            return baseMetadataProvider;
        }
        try (BufferedReader reader = new BufferedReader(new FileReader(constraintFile.get()));){
            String line;
            ImmutableList.Builder ucBuilder = ImmutableList.builder();
            ImmutableList.Builder fkBuilder = ImmutableList.builder();
            QuotedIDFactory idFactory = baseMetadataProvider.getQuotedIDFactory();
            while ((line = reader.readLine()) != null) {
                String[] s = line.split(":");
                if (s.length == 2) {
                    ucBuilder.add((Object)new ImplicitDBConstraintsProvider.DatabaseRelationDescriptor(idFactory, s[0], s[1].split(",")));
                    continue;
                }
                if (s.length != 4) continue;
                fkBuilder.add((Object)Maps.immutableEntry((Object)new ImplicitDBConstraintsProvider.DatabaseRelationDescriptor(idFactory, s[0], s[1].split(",")), (Object)new ImplicitDBConstraintsProvider.DatabaseRelationDescriptor(idFactory, s[2], s[3].split(","))));
            }
            ImmutableList foreignKeys = fkBuilder.build();
            String offenders = foreignKeys.stream().filter(c -> ((ImplicitDBConstraintsProvider.DatabaseRelationDescriptor)c.getKey()).attributeIds.size() != ((ImplicitDBConstraintsProvider.DatabaseRelationDescriptor)c.getValue()).attributeIds.size()).map(c -> c.getKey() + " does not match " + c.getValue()).collect(Collectors.joining(", "));
            if (!offenders.isEmpty()) {
                throw new MetadataExtractionException("Different numbers of columns for user-supplied foreign keys: " + offenders);
            }
            ImplicitDBConstraintsProvider implicitDBConstraintsProvider = new ImplicitDBConstraintsProvider(baseMetadataProvider, (ImmutableList<ImplicitDBConstraintsProvider.DatabaseRelationDescriptor>)ucBuilder.build(), (ImmutableList<Map.Entry<ImplicitDBConstraintsProvider.DatabaseRelationDescriptor, ImplicitDBConstraintsProvider.DatabaseRelationDescriptor>>)foreignKeys);
            return implicitDBConstraintsProvider;
        }
        catch (FileNotFoundException e) {
            LOGGER.warn("Could not find file {} in directory {}\nCurrent dir using System:{}", new Object[]{constraintFile, System.getenv().get("PWD"), System.getProperty("user.dir")});
            throw new MetadataExtractionException("Constraint file " + constraintFile + " does not exist");
        }
        catch (IOException e) {
            LOGGER.warn("Problem reading keys from the constraint file {}\n{}", constraintFile, (Object)e.getMessage());
            throw new MetadataExtractionException((Exception)e);
        }
    }
}

