/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.spec.mapping.transformer.impl;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableList;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableMap;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableMultimap;
import it.unibz.inf.ontop.com.google.common.collect.Maps;
import it.unibz.inf.ontop.constraints.ImmutableCQContainmentCheck;
import it.unibz.inf.ontop.constraints.impl.BasicLinearInclusionDependenciesImpl;
import it.unibz.inf.ontop.constraints.impl.DBLinearInclusionDependenciesImpl;
import it.unibz.inf.ontop.constraints.impl.ImmutableCQContainmentCheckUnderLIDs;
import it.unibz.inf.ontop.datalog.UnionFlattener;
import it.unibz.inf.ontop.exception.MinorOntopInternalBugException;
import it.unibz.inf.ontop.injection.CoreSingletons;
import it.unibz.inf.ontop.injection.IntermediateQueryFactory;
import it.unibz.inf.ontop.iq.IQ;
import it.unibz.inf.ontop.iq.tools.UnionBasedQueryMerger;
import it.unibz.inf.ontop.model.atom.AtomFactory;
import it.unibz.inf.ontop.model.atom.RDFAtomPredicate;
import it.unibz.inf.ontop.model.atom.RelationPredicate;
import it.unibz.inf.ontop.model.term.IRIConstant;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.vocabulary.RDF;
import it.unibz.inf.ontop.spec.mapping.MappingAssertion;
import it.unibz.inf.ontop.spec.mapping.MappingAssertionIndex;
import it.unibz.inf.ontop.spec.mapping.TMappingExclusionConfig;
import it.unibz.inf.ontop.spec.mapping.transformer.MappingCQCOptimizer;
import it.unibz.inf.ontop.spec.mapping.transformer.MappingSaturator;
import it.unibz.inf.ontop.spec.mapping.transformer.QueryUnionSplitter;
import it.unibz.inf.ontop.spec.mapping.transformer.impl.TMappingEntry;
import it.unibz.inf.ontop.spec.mapping.transformer.impl.TMappingRule;
import it.unibz.inf.ontop.spec.ontology.ClassExpression;
import it.unibz.inf.ontop.spec.ontology.ClassifiedTBox;
import it.unibz.inf.ontop.spec.ontology.DataPropertyExpression;
import it.unibz.inf.ontop.spec.ontology.DataSomeValuesFrom;
import it.unibz.inf.ontop.spec.ontology.Equivalences;
import it.unibz.inf.ontop.spec.ontology.EquivalencesDAG;
import it.unibz.inf.ontop.spec.ontology.OClass;
import it.unibz.inf.ontop.spec.ontology.ObjectPropertyExpression;
import it.unibz.inf.ontop.spec.ontology.ObjectSomeValuesFrom;
import it.unibz.inf.ontop.substitution.SubstitutionFactory;
import it.unibz.inf.ontop.utils.CoreUtilsFactory;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import java.util.Collection;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Stream;

@Singleton
public class TMappingSaturatorImpl
implements MappingSaturator {
    private final TMappingExclusionConfig tMappingExclusionConfig;
    private final AtomFactory atomFactory;
    private final TermFactory termFactory;
    private final QueryUnionSplitter unionSplitter;
    private final UnionFlattener unionNormalizer;
    private final MappingCQCOptimizer mappingCqcOptimizer;
    private final IntermediateQueryFactory iqFactory;
    private final UnionBasedQueryMerger queryMerger;
    private final SubstitutionFactory substitutionFactory;
    private final CoreUtilsFactory coreUtilsFactory;
    private final CoreSingletons coreSingletons;

    @Inject
    private TMappingSaturatorImpl(TMappingExclusionConfig tMappingExclusionConfig, QueryUnionSplitter unionSplitter, UnionFlattener unionNormalizer, MappingCQCOptimizer mappingCqcOptimizer, UnionBasedQueryMerger queryMerger, CoreSingletons coreSingletons) {
        this.tMappingExclusionConfig = tMappingExclusionConfig;
        this.atomFactory = coreSingletons.getAtomFactory();
        this.termFactory = coreSingletons.getTermFactory();
        this.unionSplitter = unionSplitter;
        this.unionNormalizer = unionNormalizer;
        this.mappingCqcOptimizer = mappingCqcOptimizer;
        this.iqFactory = coreSingletons.getIQFactory();
        this.queryMerger = queryMerger;
        this.substitutionFactory = coreSingletons.getSubstitutionFactory();
        this.coreUtilsFactory = coreSingletons.getCoreUtilsFactory();
        this.coreSingletons = coreSingletons;
    }

    @Override
    public ImmutableList<MappingAssertion> saturate(ImmutableList<MappingAssertion> mapping, ClassifiedTBox reasoner) {
        ImmutableCQContainmentCheckUnderLIDs cqc = new ImmutableCQContainmentCheckUnderLIDs((BasicLinearInclusionDependenciesImpl)new DBLinearInclusionDependenciesImpl(this.coreUtilsFactory, this.atomFactory));
        ImmutableMap original = ((ImmutableMultimap)mapping.stream().flatMap(a -> this.unionSplitter.splitUnion(this.unionNormalizer.optimize(a.getQuery())).map(IQ::normalizeForOptimization).map(q -> this.mappingCqcOptimizer.optimize((ImmutableCQContainmentCheck<RelationPredicate>)cqc, (IQ)q)).map(q -> Maps.immutableEntry((Object)a.getIndex(), (Object)new TMappingRule((IQ)q, this.termFactory, this.iqFactory)))).collect(ImmutableCollectors.toMultimap())).asMap();
        ImmutableMap saturated = (ImmutableMap)original.keySet().stream().map(MappingAssertionIndex::getPredicate).distinct().map(rdfAtomPredicate -> new TMappingRuleHeadConstructorProvider((RDFAtomPredicate)rdfAtomPredicate, this.termFactory)).flatMap(provider -> Stream.concat(Stream.concat(reasoner.objectPropertiesDAG().stream().filter(node -> !((ObjectPropertyExpression)node.getRepresentative()).isInverse() && !this.tMappingExclusionConfig.contains((ObjectPropertyExpression)node.getRepresentative())).flatMap(node -> node.getMembers().stream().filter(d -> !d.isInverse() || d.getInverse() != node.getRepresentative()).map(this.saturator((Equivalences)node, (EquivalencesDAG)reasoner.objectPropertiesDAG(), (ImmutableMap<MappingAssertionIndex, Collection<TMappingRule>>)original, provider::constructor, (ImmutableCQContainmentCheckUnderLIDs<RelationPredicate>)cqc))), reasoner.dataPropertiesDAG().stream().filter(node -> !this.tMappingExclusionConfig.contains((DataPropertyExpression)node.getRepresentative())).flatMap(node -> node.getMembers().stream().map(this.saturator((Equivalences)node, (EquivalencesDAG)reasoner.dataPropertiesDAG(), (ImmutableMap<MappingAssertionIndex, Collection<TMappingRule>>)original, provider::constructor, (ImmutableCQContainmentCheckUnderLIDs<RelationPredicate>)cqc)))), reasoner.classesDAG().stream().filter(node -> node.getRepresentative() instanceof OClass && !this.tMappingExclusionConfig.contains((OClass)node.getRepresentative())).flatMap(node -> node.getMembers().stream().filter(d -> d instanceof OClass).map(this.saturator((Equivalences)node, (EquivalencesDAG)reasoner.classesDAG(), (ImmutableMap<MappingAssertionIndex, Collection<TMappingRule>>)original, provider::constructor, (ImmutableCQContainmentCheckUnderLIDs<RelationPredicate>)cqc))))).filter(e -> !((ImmutableList)e.getValue()).isEmpty()).collect(ImmutableCollectors.toMap());
        ImmutableMap combined = (ImmutableMap)Stream.concat(saturated.entrySet().stream(), original.entrySet().stream().filter(e -> !saturated.containsKey(e.getKey())).map(e -> Maps.immutableEntry(e.getKey(), ((Collection)e.getValue()).stream().collect(TMappingEntry.toTMappingEntry((ImmutableCQContainmentCheckUnderLIDs<RelationPredicate>)cqc, this.coreSingletons))))).collect(ImmutableCollectors.toMap());
        return (ImmutableList)combined.entrySet().stream().map(e -> new MappingAssertion((MappingAssertionIndex)e.getKey(), this.toIQ((Collection)e.getValue()), null)).collect(ImmutableCollectors.toList());
    }

    private IQ toIQ(Collection<TMappingRule> rules) {
        return ((IQ)this.queryMerger.mergeDefinitions((Collection)rules.stream().map(r -> r.asIQ(this.iqFactory, this.termFactory, this.substitutionFactory)).collect(ImmutableCollectors.toList())).get()).normalizeForOptimization();
    }

    private <T> Function<T, Map.Entry<MappingAssertionIndex, ImmutableList<TMappingRule>>> saturator(Equivalences<T> node, EquivalencesDAG<T> dag, ImmutableMap<MappingAssertionIndex, Collection<TMappingRule>> original, Function<T, TMappingRuleHeadConstructor> constructor, ImmutableCQContainmentCheckUnderLIDs<RelationPredicate> cqc) {
        IRIConstant iri = constructor.apply(node.getRepresentative()).getIri();
        ImmutableList<TMappingRule> saturatedRepresentative = dag.getSub(node).stream().flatMap(subnode -> subnode.getMembers().stream()).map(constructor).flatMap(t -> ((Collection)original.getOrDefault((Object)t.indexOf(), (Object)ImmutableList.of())).stream().map(m -> new TMappingRule(t.getArguments(m.getHeadTerms(), iri), (TMappingRule)m))).collect(TMappingEntry.toTMappingEntry(cqc, this.coreSingletons));
        return constructor.andThen(t -> Maps.immutableEntry((Object)t.indexOf(), saturatedRepresentative.stream().map(m -> new TMappingRule(t.getArguments(m.getHeadTerms(), t.getIri()), (TMappingRule)m)).collect(ImmutableCollectors.toList())));
    }

    private static class TMappingRuleHeadConstructorProvider {
        private final RDFAtomPredicate p;
        private final TermFactory termFactory;
        private final IRIConstant rdfType;

        TMappingRuleHeadConstructorProvider(RDFAtomPredicate rdfAtomPredicate, TermFactory termFactory) {
            this.p = rdfAtomPredicate;
            this.termFactory = termFactory;
            this.rdfType = termFactory.getConstantIRI(RDF.TYPE);
        }

        TMappingRuleHeadConstructor constructor(ClassExpression ce) {
            if (ce instanceof OClass) {
                OClass oc = (OClass)ce;
                return new TMappingRuleHeadConstructor(MappingAssertionIndex.ofClass(this.p, oc.getIRI()), this.termFactory){

                    @Override
                    public ImmutableList<ImmutableTerm> getArguments(ImmutableList<ImmutableTerm> args, IRIConstant newIri) {
                        return p.updateSPO(args, p.getSubject(args), (ImmutableTerm)rdfType, (ImmutableTerm)newIri);
                    }
                };
            }
            if (ce instanceof ObjectSomeValuesFrom) {
                final ObjectPropertyExpression ope = ((ObjectSomeValuesFrom)ce).getProperty();
                return new TMappingRuleHeadConstructor(MappingAssertionIndex.ofProperty(this.p, ope.getIRI()), this.termFactory){

                    @Override
                    public ImmutableList<ImmutableTerm> getArguments(ImmutableList<ImmutableTerm> args, IRIConstant newIri) {
                        return p.updateSPO(args, ope.isInverse() ? p.getObject(args) : p.getSubject(args), (ImmutableTerm)rdfType, (ImmutableTerm)newIri);
                    }
                };
            }
            if (ce instanceof DataSomeValuesFrom) {
                DataPropertyExpression dpe = ((DataSomeValuesFrom)ce).getProperty();
                return new TMappingRuleHeadConstructor(MappingAssertionIndex.ofProperty(this.p, dpe.getIRI()), this.termFactory){

                    @Override
                    public ImmutableList<ImmutableTerm> getArguments(ImmutableList<ImmutableTerm> args, IRIConstant newIri) {
                        return p.updateSPO(args, p.getSubject(args), (ImmutableTerm)rdfType, (ImmutableTerm)newIri);
                    }
                };
            }
            throw new MinorOntopInternalBugException("Unexpected type" + ce);
        }

        TMappingRuleHeadConstructor constructor(final ObjectPropertyExpression ope) {
            return new TMappingRuleHeadConstructor(MappingAssertionIndex.ofProperty(this.p, ope.getIRI()), this.termFactory){

                @Override
                public ImmutableList<ImmutableTerm> getArguments(ImmutableList<ImmutableTerm> args, IRIConstant newIri) {
                    return ope.isInverse() ? p.updateSPO(args, p.getObject(args), (ImmutableTerm)newIri, p.getSubject(args)) : p.updateSPO(args, p.getSubject(args), (ImmutableTerm)newIri, p.getObject(args));
                }
            };
        }

        TMappingRuleHeadConstructor constructor(DataPropertyExpression dpe) {
            return new TMappingRuleHeadConstructor(MappingAssertionIndex.ofProperty(this.p, dpe.getIRI()), this.termFactory){

                @Override
                public ImmutableList<ImmutableTerm> getArguments(ImmutableList<ImmutableTerm> args, IRIConstant newIri) {
                    return p.updateSPO(args, p.getSubject(args), (ImmutableTerm)newIri, p.getObject(args));
                }
            };
        }
    }

    private static abstract class TMappingRuleHeadConstructor {
        final MappingAssertionIndex index;
        final IRIConstant iri;

        TMappingRuleHeadConstructor(MappingAssertionIndex index, TermFactory termFactory) {
            this.index = index;
            this.iri = termFactory.getConstantIRI(index.getIri());
        }

        MappingAssertionIndex indexOf() {
            return this.index;
        }

        IRIConstant getIri() {
            return this.iri;
        }

        abstract ImmutableList<ImmutableTerm> getArguments(ImmutableList<ImmutableTerm> var1, IRIConstant var2);
    }
}

