/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.spec.mapping.transformer.impl;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableList;
import it.unibz.inf.ontop.injection.IntermediateQueryFactory;
import it.unibz.inf.ontop.iq.BinaryNonCommutativeIQTree;
import it.unibz.inf.ontop.iq.IQ;
import it.unibz.inf.ontop.iq.IQTree;
import it.unibz.inf.ontop.iq.NaryIQTree;
import it.unibz.inf.ontop.iq.node.BinaryNonCommutativeOperatorNode;
import it.unibz.inf.ontop.iq.node.LeftJoinNode;
import it.unibz.inf.ontop.iq.node.QueryNode;
import it.unibz.inf.ontop.iq.node.UnionNode;
import it.unibz.inf.ontop.model.atom.DistinctVariableOnlyDataAtom;
import it.unibz.inf.ontop.spec.mapping.transformer.QueryUnionSplitter;
import it.unibz.inf.ontop.utils.VariableGenerator;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Optional;
import java.util.stream.Stream;

@Singleton
public class QueryUnionSplitterImpl
implements QueryUnionSplitter {
    private final IntermediateQueryFactory iqFactory;

    @Inject
    private QueryUnionSplitterImpl(IntermediateQueryFactory iqFactory) {
        this.iqFactory = iqFactory;
    }

    @Override
    public Stream<IQ> splitUnion(IQ query) {
        DistinctVariableOnlyDataAtom projectionAtom = query.getProjectionAtom();
        VariableGenerator variableGenerator = query.getVariableGenerator();
        IQTree tree = query.getTree();
        return this.findFirstSplittableUnion(query).map(unionTree -> unionTree.getChildren().stream().map(c -> tree.replaceSubTree((IQTree)unionTree, c)).map(t -> t.normalizeForOptimization(variableGenerator)).map(t -> this.iqFactory.createIQ(projectionAtom, t)).map(IQ::normalizeForOptimization)).orElseGet(() -> Stream.of(query));
    }

    private Optional<NaryIQTree> findFirstSplittableUnion(IQ query) {
        LinkedList<IQTree> nodesToVisit = new LinkedList<IQTree>();
        nodesToVisit.add(query.getTree());
        while (!nodesToVisit.isEmpty()) {
            IQTree childTree = (IQTree)nodesToVisit.poll();
            if (childTree.getRootNode() instanceof UnionNode) {
                return Optional.of((NaryIQTree)childTree);
            }
            nodesToVisit.addAll((Collection<IQTree>)this.extractChildrenToVisit(childTree));
        }
        return Optional.empty();
    }

    private ImmutableList<IQTree> extractChildrenToVisit(IQTree tree) {
        QueryNode node = tree.getRootNode();
        if (node instanceof BinaryNonCommutativeOperatorNode) {
            if (node instanceof LeftJoinNode) {
                return ImmutableList.of((Object)((BinaryNonCommutativeIQTree)tree).getLeftChild());
            }
            return ImmutableList.of();
        }
        return tree.getChildren();
    }
}

