/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.spec.mapping.transformer.impl;

import it.unibz.inf.ontop.com.google.common.collect.ImmutableList;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableMap;
import it.unibz.inf.ontop.exception.MinorOntopInternalBugException;
import it.unibz.inf.ontop.injection.CoreSingletons;
import it.unibz.inf.ontop.iq.IQTree;
import it.unibz.inf.ontop.iq.node.AggregationNode;
import it.unibz.inf.ontop.iq.node.BinaryNonCommutativeOperatorNode;
import it.unibz.inf.ontop.iq.node.ConstructionNode;
import it.unibz.inf.ontop.iq.node.FilterNode;
import it.unibz.inf.ontop.iq.node.InnerJoinNode;
import it.unibz.inf.ontop.iq.node.LeftJoinNode;
import it.unibz.inf.ontop.iq.node.NaryOperatorNode;
import it.unibz.inf.ontop.iq.node.OrderByNode;
import it.unibz.inf.ontop.iq.node.UnaryOperatorNode;
import it.unibz.inf.ontop.iq.transform.IQTreeTransformer;
import it.unibz.inf.ontop.iq.transform.impl.DefaultRecursiveIQTreeVisitingTransformer;
import it.unibz.inf.ontop.iq.type.UniqueTermTypeExtractor;
import it.unibz.inf.ontop.model.term.DBConstant;
import it.unibz.inf.ontop.model.term.ImmutableExpression;
import it.unibz.inf.ontop.model.term.ImmutableFunctionalTerm;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.NonGroundTerm;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.functionsymbol.FunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.NotYetTypedEqualityFunctionSymbol;
import it.unibz.inf.ontop.model.type.DBTermType;
import it.unibz.inf.ontop.spec.mapping.transformer.MappingEqualityTransformer;
import it.unibz.inf.ontop.substitution.ImmutableSubstitution;
import it.unibz.inf.ontop.substitution.SubstitutionFactory;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import javax.inject.Inject;

public class MappingEqualityTransformerImpl
implements MappingEqualityTransformer {
    private final IQTreeTransformer expressionTransformer;

    @Inject
    protected MappingEqualityTransformerImpl(UniqueTermTypeExtractor typeExtractor, CoreSingletons coreSingletons) {
        this.expressionTransformer = new ExpressionTransformer(typeExtractor, coreSingletons);
    }

    @Override
    public IQTree transform(IQTree tree) {
        return this.expressionTransformer.transform(tree);
    }

    protected static class ExpressionTransformer
    extends DefaultRecursiveIQTreeVisitingTransformer {
        private final UniqueTermTypeExtractor typeExtractor;
        private final TermFactory termFactory;
        private final SubstitutionFactory substitutionFactory;

        protected ExpressionTransformer(UniqueTermTypeExtractor typeExtractor, CoreSingletons coreSingletons) {
            super(coreSingletons);
            this.typeExtractor = typeExtractor;
            this.termFactory = coreSingletons.getTermFactory();
            this.substitutionFactory = coreSingletons.getSubstitutionFactory();
        }

        public IQTree transformConstruction(IQTree tree, ConstructionNode rootNode, IQTree child) {
            IQTree newChild = this.transform(child);
            ImmutableSubstitution initialSubstitution = rootNode.getSubstitution();
            ImmutableSubstitution newSubstitution = this.substitutionFactory.getSubstitution((ImmutableMap)initialSubstitution.getImmutableMap().entrySet().stream().collect(ImmutableCollectors.toMap(Map.Entry::getKey, e -> this.transformTerm((ImmutableTerm)e.getValue(), child))));
            return newChild.equals(child) && newSubstitution.equals(initialSubstitution) ? tree : this.iqFactory.createUnaryIQTree((UnaryOperatorNode)this.iqFactory.createConstructionNode(rootNode.getVariables(), newSubstitution), newChild);
        }

        public IQTree transformAggregation(IQTree tree, AggregationNode rootNode, IQTree child) {
            IQTree newChild = this.transform(child);
            ImmutableSubstitution initialSubstitution = rootNode.getSubstitution();
            ImmutableSubstitution newSubstitution = this.substitutionFactory.getSubstitution((ImmutableMap)initialSubstitution.getImmutableMap().entrySet().stream().collect(ImmutableCollectors.toMap(Map.Entry::getKey, e -> this.transformFunctionalTerm((ImmutableFunctionalTerm)e.getValue(), child))));
            return newChild.equals(child) && newSubstitution.equals(initialSubstitution) ? tree : this.iqFactory.createUnaryIQTree((UnaryOperatorNode)this.iqFactory.createAggregationNode(rootNode.getGroupingVariables(), newSubstitution), newChild);
        }

        public IQTree transformFilter(IQTree tree, FilterNode rootNode, IQTree child) {
            IQTree newChild = this.transform(child);
            ImmutableExpression initialExpression = rootNode.getFilterCondition();
            ImmutableExpression newExpression = this.transformExpression(initialExpression, tree);
            FilterNode newFilterNode = newExpression.equals(initialExpression) ? rootNode : rootNode.changeFilterCondition(newExpression);
            return newFilterNode.equals(rootNode) && newChild.equals(child) ? tree : this.iqFactory.createUnaryIQTree((UnaryOperatorNode)newFilterNode, newChild);
        }

        public IQTree transformOrderBy(IQTree tree, OrderByNode rootNode, IQTree child) {
            IQTree newChild = this.transform(child);
            ImmutableList initialComparators = rootNode.getComparators();
            ImmutableList newComparators = (ImmutableList)initialComparators.stream().map(c -> this.iqFactory.createOrderComparator(this.transformNonGroundTerm(c.getTerm(), tree), c.isAscending())).collect(ImmutableCollectors.toList());
            return newComparators.equals((Object)initialComparators) && newChild.equals(child) ? tree : this.iqFactory.createUnaryIQTree((UnaryOperatorNode)this.iqFactory.createOrderByNode(newComparators), newChild);
        }

        public IQTree transformLeftJoin(IQTree tree, LeftJoinNode rootNode, IQTree leftChild, IQTree rightChild) {
            IQTree newLeftChild = this.transform(leftChild);
            IQTree newRightChild = this.transform(rightChild);
            Optional initialExpression = rootNode.getOptionalFilterCondition();
            Optional<ImmutableExpression> newExpression = initialExpression.map(e -> this.transformExpression((ImmutableExpression)e, tree));
            LeftJoinNode newLeftJoinNode = newExpression.equals(initialExpression) ? rootNode : rootNode.changeOptionalFilterCondition(newExpression);
            return newLeftJoinNode.equals(rootNode) && newLeftChild.equals(leftChild) && newRightChild.equals(rightChild) ? tree : this.iqFactory.createBinaryNonCommutativeIQTree((BinaryNonCommutativeOperatorNode)newLeftJoinNode, newLeftChild, newRightChild);
        }

        public IQTree transformInnerJoin(IQTree tree, InnerJoinNode rootNode, ImmutableList<IQTree> children) {
            ImmutableList newChildren = (ImmutableList)children.stream().map(arg_0 -> ((ExpressionTransformer)this).transform(arg_0)).collect(ImmutableCollectors.toList());
            Optional initialExpression = rootNode.getOptionalFilterCondition();
            Optional<ImmutableExpression> newExpression = initialExpression.map(e -> this.transformExpression((ImmutableExpression)e, tree));
            InnerJoinNode newJoinNode = newExpression.equals(initialExpression) ? rootNode : rootNode.changeOptionalFilterCondition(newExpression);
            return newJoinNode.equals(rootNode) && newChildren.equals(children) ? tree : this.iqFactory.createNaryIQTree((NaryOperatorNode)newJoinNode, newChildren);
        }

        protected ImmutableTerm transformTerm(ImmutableTerm term, IQTree tree) {
            return term instanceof ImmutableFunctionalTerm ? this.transformFunctionalTerm((ImmutableFunctionalTerm)term, tree) : term;
        }

        protected NonGroundTerm transformNonGroundTerm(NonGroundTerm term, IQTree tree) {
            return term instanceof ImmutableFunctionalTerm ? (NonGroundTerm)this.transformFunctionalTerm((ImmutableFunctionalTerm)term, tree) : term;
        }

        protected ImmutableExpression transformExpression(ImmutableExpression expression, IQTree tree) {
            return (ImmutableExpression)this.transformFunctionalTerm((ImmutableFunctionalTerm)expression, tree);
        }

        protected ImmutableFunctionalTerm transformFunctionalTerm(ImmutableFunctionalTerm functionalTerm, IQTree tree) {
            ImmutableList initialTerms = functionalTerm.getTerms();
            ImmutableList newTerms = (ImmutableList)initialTerms.stream().map(t -> t instanceof ImmutableFunctionalTerm ? this.transformFunctionalTerm((ImmutableFunctionalTerm)t, tree) : t).collect(ImmutableCollectors.toList());
            FunctionSymbol functionSymbol = functionalTerm.getFunctionSymbol();
            if (functionSymbol instanceof NotYetTypedEqualityFunctionSymbol) {
                return this.transformEquality((ImmutableList<ImmutableTerm>)newTerms, tree);
            }
            return newTerms.equals((Object)initialTerms) ? functionalTerm : this.termFactory.getImmutableFunctionalTerm(functionSymbol, newTerms);
        }

        protected ImmutableExpression transformEquality(ImmutableList<ImmutableTerm> newTerms, IQTree tree) {
            if (newTerms.size() != 2) {
                throw new MinorOntopInternalBugException("Was expecting the not yet typed equalities to be binary");
            }
            ImmutableTerm term1 = (ImmutableTerm)newTerms.get(0);
            ImmutableTerm term2 = (ImmutableTerm)newTerms.get(1);
            ImmutableList extractedTypes = (ImmutableList)newTerms.stream().map(t -> this.typeExtractor.extractUniqueTermType(t, tree)).collect(ImmutableCollectors.toList());
            if (extractedTypes.stream().allMatch(type -> type.filter(t -> t instanceof DBTermType).isPresent())) {
                DBTermType type2;
                ImmutableList types = (ImmutableList)extractedTypes.stream().map(Optional::get).map(t -> (DBTermType)t).collect(ImmutableCollectors.toList());
                DBTermType type1 = (DBTermType)types.get(0);
                return type1.equals(type2 = (DBTermType)types.get(1)) ? this.transformSameTypeEquality(type1, term1, term2, tree) : this.transformDifferentTypesEquality(type1, type2, term1, term2);
            }
            return this.termFactory.getDBNonStrictDefaultEquality(term1, term2);
        }

        private ImmutableExpression transformSameTypeEquality(DBTermType type, ImmutableTerm term1, ImmutableTerm term2, IQTree tree) {
            if (type.areEqualitiesStrict()) {
                return this.termFactory.getStrictEquality(term1, term2, new ImmutableTerm[0]);
            }
            if (this.areIndependentFromConstants(term1, term2, tree) && type.areEqualitiesBetweenTwoDBAttributesStrict()) {
                return this.termFactory.getStrictEquality(term1, term2, new ImmutableTerm[0]);
            }
            switch (type.getCategory()) {
                case DECIMAL: 
                case FLOAT_DOUBLE: {
                    return this.termFactory.getDBNonStrictNumericEquality(term1, term2);
                }
                case DATETIME: {
                    return this.termFactory.getDBNonStrictDatetimeEquality(term1, term2);
                }
            }
            return this.termFactory.getDBNonStrictDefaultEquality(term1, term2);
        }

        protected ImmutableExpression transformDifferentTypesEquality(DBTermType type1, DBTermType type2, ImmutableTerm term1, ImmutableTerm term2) {
            if (this.areCompatibleForStrictEq(type1, type2)) {
                return this.termFactory.getStrictEquality(term1, term2, new ImmutableTerm[0]);
            }
            DBTermType.Category category1 = type1.getCategory();
            DBTermType.Category category2 = type2.getCategory();
            switch (category1) {
                case INTEGER: 
                case STRING: {
                    switch (category2) {
                        case DECIMAL: 
                        case FLOAT_DOUBLE: {
                            return this.termFactory.getDBNonStrictNumericEquality(term1, term2);
                        }
                    }
                    break;
                }
                case DECIMAL: 
                case FLOAT_DOUBLE: {
                    switch (category2) {
                        case DECIMAL: 
                        case FLOAT_DOUBLE: 
                        case INTEGER: {
                            return this.termFactory.getDBNonStrictNumericEquality(term1, term2);
                        }
                    }
                    break;
                }
                case DATETIME: {
                    if (category2 != DBTermType.Category.DATETIME) break;
                    return this.termFactory.getDBNonStrictDatetimeEquality(term1, term2);
                }
            }
            return this.termFactory.getDBNonStrictDefaultEquality(term1, term2);
        }

        protected boolean areIndependentFromConstants(ImmutableTerm term1, ImmutableTerm term2, IQTree tree) {
            return !(term1 instanceof DBConstant) && !(term2 instanceof DBConstant);
        }

        private boolean areCompatibleForStrictEq(DBTermType type1, DBTermType type2) {
            return Stream.of(type1.areEqualitiesStrict(type2), type2.areEqualitiesStrict(type1)).filter(Optional::isPresent).map(Optional::get).reduce((b1, b2) -> b1 != false && b2 != false).orElse(false);
        }
    }
}

