/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.spec.mapping;

import it.unibz.inf.ontop.com.google.common.collect.ImmutableList;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableSet;
import it.unibz.inf.ontop.exception.MinorOntopInternalBugException;
import it.unibz.inf.ontop.injection.IntermediateQueryFactory;
import it.unibz.inf.ontop.iq.IQ;
import it.unibz.inf.ontop.iq.IQTree;
import it.unibz.inf.ontop.iq.UnaryIQTree;
import it.unibz.inf.ontop.iq.node.ConstructionNode;
import it.unibz.inf.ontop.model.atom.DistinctVariableOnlyDataAtom;
import it.unibz.inf.ontop.model.atom.RDFAtomPredicate;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.model.vocabulary.RDF;
import it.unibz.inf.ontop.spec.mapping.MappingAssertionIndex;
import it.unibz.inf.ontop.spec.mapping.pp.PPMappingAssertionProvenance;
import it.unibz.inf.ontop.substitution.ImmutableSubstitution;
import java.util.Optional;
import org.apache.commons.rdf.api.IRI;

public class MappingAssertion {
    private MappingAssertionIndex index;
    private final IQ query;
    private final PPMappingAssertionProvenance provenance;

    public MappingAssertion(MappingAssertionIndex index, IQ query, PPMappingAssertionProvenance provenance) {
        this.index = index;
        this.query = query;
        this.provenance = provenance;
    }

    public MappingAssertion(IQ query, PPMappingAssertionProvenance provenance) {
        this.query = query;
        this.provenance = provenance;
    }

    public IQ getQuery() {
        return this.query;
    }

    public PPMappingAssertionProvenance getProvenance() {
        return this.provenance;
    }

    public MappingAssertion copyOf(IQ query) {
        return query.getProjectionAtom() == this.query.getProjectionAtom() ? new MappingAssertion(this.index, query, this.provenance) : new MappingAssertion(query, this.provenance);
    }

    public MappingAssertion copyOf(IQTree tree, IntermediateQueryFactory iqFactory) {
        return new MappingAssertion(this.index, iqFactory.createIQ(this.query.getProjectionAtom(), tree), this.provenance);
    }

    public ImmutableSet<Variable> getProjectedVariables() {
        return this.query.getTree().getVariables();
    }

    public RDFAtomPredicate getRDFAtomPredicate() {
        if (this.index == null) {
            return Optional.of(this.query.getProjectionAtom().getPredicate()).filter(p -> p instanceof RDFAtomPredicate).map(p -> (RDFAtomPredicate)p).orElseThrow(() -> new MinorOntopInternalBugException("The mapping assertion does not have an RDFAtomPredicate"));
        }
        return this.index.getPredicate();
    }

    public ImmutableList<ImmutableTerm> getTerms() {
        return this.getTopSubstitution().apply(this.getProjectionAtom().getArguments());
    }

    public ImmutableSubstitution<ImmutableTerm> getTopSubstitution() {
        return Optional.of(this.query.getTree()).filter(t -> t.getRootNode() instanceof ConstructionNode).map(IQTree::getRootNode).map(n -> (ConstructionNode)n).map(ConstructionNode::getSubstitution).orElseThrow(() -> new MinorOntopInternalBugException("The mapping assertion was expecting to start with a construction node\n" + this.query));
    }

    public IQTree getTopChild() {
        return ((UnaryIQTree)this.query.getTree()).getChild();
    }

    public DistinctVariableOnlyDataAtom getProjectionAtom() {
        return this.query.getProjectionAtom();
    }

    public MappingAssertionIndex getIndex() {
        if (this.index == null) {
            ImmutableList<ImmutableTerm> substitutedArguments;
            RDFAtomPredicate rdfAtomPredicate = this.getRDFAtomPredicate();
            IRI propertyIRI = (IRI)rdfAtomPredicate.getPropertyIRI(substitutedArguments = this.getTerms()).orElseThrow(() -> new MinorOntopInternalBugException("The definition of the predicate is not always a ground term" + this.query));
            this.index = propertyIRI.equals((Object)RDF.TYPE) ? MappingAssertionIndex.ofClass(rdfAtomPredicate, (IRI)rdfAtomPredicate.getClassIRI(substitutedArguments).orElseThrow(() -> new MinorOntopInternalBugException("The definition of the predicate is not always a ground term" + this.query))) : MappingAssertionIndex.ofProperty(rdfAtomPredicate, propertyIRI);
        }
        return this.index;
    }
}

