/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.spec.dbschema.impl;

import it.unibz.inf.ontop.com.google.common.collect.ImmutableList;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableMultimap;
import it.unibz.inf.ontop.dbschema.AttributeNotFoundException;
import it.unibz.inf.ontop.dbschema.DatabaseRelationDefinition;
import it.unibz.inf.ontop.dbschema.ForeignKeyConstraint;
import it.unibz.inf.ontop.dbschema.FunctionalDependency;
import it.unibz.inf.ontop.dbschema.MetadataLookup;
import it.unibz.inf.ontop.dbschema.MetadataProvider;
import it.unibz.inf.ontop.dbschema.QuotedID;
import it.unibz.inf.ontop.dbschema.QuotedIDFactory;
import it.unibz.inf.ontop.dbschema.RelationID;
import it.unibz.inf.ontop.dbschema.UniqueConstraint;
import it.unibz.inf.ontop.dbschema.impl.DelegatingMetadataProvider;
import it.unibz.inf.ontop.exception.MetadataExtractionException;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImplicitDBConstraintsProvider
extends DelegatingMetadataProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(ImplicitDBConstraintsProvider.class);
    private final ImmutableMultimap<RelationID, DatabaseRelationDescriptor> uniqueConstraints;
    private final ImmutableMultimap<RelationID, Map.Entry<DatabaseRelationDescriptor, DatabaseRelationDescriptor>> foreignKeys;

    ImplicitDBConstraintsProvider(MetadataProvider provider, ImmutableList<DatabaseRelationDescriptor> uniqueConstraints, ImmutableList<Map.Entry<DatabaseRelationDescriptor, DatabaseRelationDescriptor>> foreignKeys) throws MetadataExtractionException {
        super(provider);
        this.uniqueConstraints = (ImmutableMultimap)uniqueConstraints.stream().collect(ImmutableCollectors.toMultimap(c -> c.tableId, Function.identity()));
        this.foreignKeys = (ImmutableMultimap)foreignKeys.stream().collect(ImmutableCollectors.toMultimap(c -> ((DatabaseRelationDescriptor)c.getKey()).tableId, Function.identity()));
    }

    public void insertIntegrityConstraints(DatabaseRelationDefinition relation, MetadataLookup metadataLookup) throws MetadataExtractionException {
        this.provider.insertIntegrityConstraints(relation, metadataLookup);
        try {
            int counter = 0;
            for (DatabaseRelationDescriptor uc : (ImmutableList)relation.getAllIDs().stream().flatMap(id -> this.uniqueConstraints.get(id).stream()).collect(ImmutableCollectors.toList())) {
                String name = this.getTableName(relation) + "_USER_UC_" + counter++;
                FunctionalDependency.Builder builder = UniqueConstraint.builder((DatabaseRelationDefinition)relation, (String)name);
                for (QuotedID a : uc.attributeIds) {
                    builder.addDeterminant(a);
                }
                builder.build();
            }
            for (Map.Entry fkc : (ImmutableList)relation.getAllIDs().stream().flatMap(id -> this.foreignKeys.get(id).stream()).collect(ImmutableCollectors.toList())) {
                DatabaseRelationDefinition referencedRelation;
                try {
                    referencedRelation = metadataLookup.getRelation(((DatabaseRelationDescriptor)fkc.getValue()).tableId);
                }
                catch (MetadataExtractionException e) {
                    LOGGER.warn("Cannot find table {} for user-supplied FK {} -> {}", new Object[]{((DatabaseRelationDescriptor)fkc.getValue()).tableId, ((DatabaseRelationDescriptor)fkc.getKey()).toString(), ((DatabaseRelationDescriptor)fkc.getKey()).toString()});
                    continue;
                }
                String name = this.getTableName(relation) + "_USER_FK_" + this.getTableName(referencedRelation) + "_" + counter++;
                ForeignKeyConstraint.Builder builder = ForeignKeyConstraint.builder((String)name, (DatabaseRelationDefinition)relation, (DatabaseRelationDefinition)referencedRelation);
                for (int i = 0; i < ((DatabaseRelationDescriptor)fkc.getKey()).attributeIds.size(); ++i) {
                    builder.add((QuotedID)((DatabaseRelationDescriptor)fkc.getKey()).attributeIds.get(i), (QuotedID)((DatabaseRelationDescriptor)fkc.getValue()).attributeIds.get(i));
                }
                builder.build();
            }
        }
        catch (AttributeNotFoundException e) {
            throw new MetadataExtractionException("Error in user-supplied unique constraints: " + e.getAttributeID() + " not found in " + e.getRelation());
        }
    }

    private String getTableName(DatabaseRelationDefinition relation) {
        return relation.getID().getTableID().getName();
    }

    static final class DatabaseRelationDescriptor {
        final RelationID tableId;
        final ImmutableList<QuotedID> attributeIds;

        DatabaseRelationDescriptor(QuotedIDFactory idFactory, String tableName, String[] attributeNames) {
            this.tableId = this.getRelationIDFromString(idFactory, tableName);
            this.attributeIds = (ImmutableList)Stream.of(attributeNames).map(arg_0 -> ((QuotedIDFactory)idFactory).createAttributeID(arg_0)).collect(ImmutableCollectors.toList());
        }

        private RelationID getRelationIDFromString(QuotedIDFactory idFactory, String tableName) {
            String[] names = tableName.split("\\.");
            return names.length == 1 ? idFactory.createRelationID(null, tableName) : idFactory.createRelationID(names[0], names[1]);
        }

        public String toString() {
            return this.tableId + "" + this.attributeIds;
        }
    }
}

