/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.exception;

import it.unibz.inf.ontop.exception.Indicator;
import it.unibz.inf.ontop.exception.InvalidMappingException;
import java.util.List;

public class InvalidMappingExceptionWithIndicator
extends InvalidMappingException {
    private static final long serialVersionUID = 1L;
    public static final int MAPPING_ID_IS_BLANK = 1;
    public static final int TARGET_QUERY_IS_BLANK = 2;
    public static final int SOURCE_QUERY_IS_BLANK = 3;
    public static final int UNKNOWN_PREDICATE_IN_TARGET_QUERY = 4;
    public static final int ERROR_PARSING_TARGET_QUERY = 5;

    public InvalidMappingExceptionWithIndicator(List<Indicator> indicators) {
        super(InvalidMappingExceptionWithIndicator.buildMessage(indicators));
    }

    private static String buildMessage(List<Indicator> indicators) {
        StringBuilder sb = new StringBuilder();
        if (!indicators.isEmpty()) {
            sb.append("\n");
            sb.append("The syntax of the mapping is invalid (and therefore cannot be processed). Problems: \n\n");
            for (Indicator indicator : indicators) {
                int lineNumber = indicator.getLineNumber();
                String mappingId = "";
                switch (indicator.getReason()) {
                    case 1: {
                        sb.append(String.format("Line %d: Mapping ID is missing\n\n", lineNumber));
                        break;
                    }
                    case 2: {
                        mappingId = (String)indicator.getHint();
                        if (!mappingId.isEmpty()) {
                            sb.append(String.format("MappingId = '%s'\n", mappingId));
                        }
                        sb.append(String.format("Line %d: Target is missing\n\n", lineNumber));
                        break;
                    }
                    case 3: {
                        mappingId = (String)indicator.getHint();
                        if (!mappingId.isEmpty()) {
                            sb.append(String.format("MappingId = '%s'\n", mappingId));
                        }
                        sb.append(String.format("Line %d: Source query is missing\n\n", lineNumber));
                        break;
                    }
                    case 4: {
                        Object[] hints1 = (Object[])indicator.getHint();
                        mappingId = (String)hints1[0];
                        if (!mappingId.isEmpty()) {
                            sb.append(String.format("MappingId = '%s'\n", mappingId));
                        }
                        List unknownPredicates = (List)hints1[1];
                        sb.append(String.format("Line %d: %s (unknown predicate)\n\n", lineNumber, unknownPredicates));
                        break;
                    }
                    case 5: {
                        String[] hints2 = (String[])indicator.getHint();
                        mappingId = hints2[0];
                        if (!mappingId.isEmpty()) {
                            sb.append(String.format("MappingId = '%s'\n", mappingId));
                        }
                        String targetString = hints2[1];
                        sb.append(String.format("Line %d: Invalid target: '%s'\n", lineNumber, targetString));
                        String exceptions = hints2[2];
                        sb.append(String.format("Debug information\n%s\n", exceptions));
                    }
                }
            }
        }
        return sb.toString();
    }
}

