/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.spec.mapping.transformer.impl;

import it.unibz.inf.ontop.com.google.common.collect.ImmutableList;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableMap;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableSet;
import it.unibz.inf.ontop.com.google.common.collect.Maps;
import it.unibz.inf.ontop.exception.MinorOntopInternalBugException;
import it.unibz.inf.ontop.injection.IntermediateQueryFactory;
import it.unibz.inf.ontop.iq.IQ;
import it.unibz.inf.ontop.iq.IQTree;
import it.unibz.inf.ontop.iq.node.ConstructionNode;
import it.unibz.inf.ontop.iq.node.ExtensionalDataNode;
import it.unibz.inf.ontop.iq.node.UnaryOperatorNode;
import it.unibz.inf.ontop.model.atom.DistinctVariableOnlyDataAtom;
import it.unibz.inf.ontop.model.term.ImmutableExpression;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.model.term.VariableOrGroundTerm;
import it.unibz.inf.ontop.spec.mapping.transformer.impl.IQ2CQ;
import it.unibz.inf.ontop.substitution.ImmutableSubstitution;
import it.unibz.inf.ontop.substitution.SubstitutionFactory;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import it.unibz.inf.ontop.utils.VariableGenerator;
import java.util.Map;
import java.util.Optional;
import java.util.stream.IntStream;
import java.util.stream.Stream;

public class TMappingRule {
    private final DistinctVariableOnlyDataAtom projectionAtom;
    private final ImmutableList<ImmutableTerm> headTerms;
    private final ImmutableList<ExtensionalDataNode> extensionalNodes;
    private final ImmutableList<ImmutableList<ImmutableExpression>> filter;

    public TMappingRule(IQ iq, TermFactory termFactory, IntermediateQueryFactory iqFactory) {
        this.projectionAtom = iq.getProjectionAtom();
        this.headTerms = ((ConstructionNode)iq.getTree().getRootNode()).getSubstitution().apply(this.projectionAtom.getArguments());
        IQTree tree = (IQTree)iq.getTree().getChildren().get(0);
        ImmutableList<ExtensionalDataNode> dataAtoms = IQ2CQ.getExtensionalDataNodes(tree).get();
        ImmutableSet<ImmutableExpression> joinConditions = IQ2CQ.getFilterExpressions(tree);
        VariableGenerator variableGenerator = iq.getVariableGenerator();
        ImmutableMap valueMap = (ImmutableMap)dataAtoms.stream().flatMap(n -> n.getArgumentMap().values().stream()).filter(t -> !(t instanceof Variable)).distinct().collect(ImmutableCollectors.toMap(t -> t, t -> variableGenerator.generateNewVariable()));
        this.extensionalNodes = (ImmutableList)dataAtoms.stream().map(n -> iqFactory.createExtensionalDataNode(n.getRelationDefinition(), (ImmutableMap)n.getArgumentMap().entrySet().stream().collect(ImmutableCollectors.toMap(Map.Entry::getKey, e -> (VariableOrGroundTerm)valueMap.getOrDefault(e.getValue(), e.getValue()))))).collect(ImmutableCollectors.toList());
        ImmutableList filterAtoms = (ImmutableList)Stream.concat(joinConditions.stream(), valueMap.entrySet().stream().map(e -> termFactory.getStrictEquality((ImmutableTerm)e.getKey(), (ImmutableTerm)e.getValue(), new ImmutableTerm[0]))).collect(ImmutableCollectors.toList());
        this.filter = filterAtoms.isEmpty() ? ImmutableList.of() : ImmutableList.of((Object)filterAtoms);
    }

    TMappingRule(TMappingRule baseRule, ImmutableList<ImmutableList<ImmutableExpression>> filter) {
        this.projectionAtom = baseRule.projectionAtom;
        this.headTerms = baseRule.headTerms;
        this.extensionalNodes = baseRule.extensionalNodes;
        this.filter = filter;
    }

    TMappingRule(ImmutableList<ImmutableTerm> headTerms, TMappingRule baseRule) {
        this.projectionAtom = baseRule.projectionAtom;
        this.headTerms = headTerms;
        this.extensionalNodes = baseRule.extensionalNodes;
        this.filter = baseRule.filter;
    }

    public IQ asIQ(IntermediateQueryFactory iqFactory, TermFactory termFactory, SubstitutionFactory substitutionFactory) {
        Optional mergedConditions = termFactory.getDisjunction(this.filter.stream().map(arg_0 -> ((TermFactory)termFactory).getConjunction(arg_0)));
        if (this.projectionAtom.getArity() != this.headTerms.size()) {
            throw new MinorOntopInternalBugException("size mismatch");
        }
        ImmutableSubstitution substitution = substitutionFactory.getSubstitution((ImmutableMap)IntStream.range(0, this.projectionAtom.getArity()).mapToObj(i -> Maps.immutableEntry((Object)this.projectionAtom.getTerm(i), (Object)this.headTerms.get(i))).filter(e -> !((Variable)e.getKey()).equals(e.getValue())).collect(ImmutableCollectors.toMap()));
        return iqFactory.createIQ(this.projectionAtom, (IQTree)iqFactory.createUnaryIQTree((UnaryOperatorNode)iqFactory.createConstructionNode(this.projectionAtom.getVariables(), substitution), IQ2CQ.toIQTree(this.extensionalNodes, mergedConditions, iqFactory)));
    }

    public ImmutableList<ImmutableTerm> getHeadTerms() {
        return this.headTerms;
    }

    public ImmutableList<ExtensionalDataNode> getDatabaseAtoms() {
        return this.extensionalNodes;
    }

    public ImmutableList<ImmutableList<ImmutableExpression>> getConditions() {
        return this.filter;
    }

    public int hashCode() {
        return this.headTerms.hashCode() ^ this.extensionalNodes.hashCode() ^ this.filter.hashCode();
    }

    public boolean equals(Object other) {
        if (other instanceof TMappingRule) {
            TMappingRule otherRule = (TMappingRule)other;
            return this.projectionAtom.equals(otherRule.projectionAtom) && this.headTerms.equals(otherRule.headTerms) && this.extensionalNodes.equals(otherRule.extensionalNodes) && this.filter.equals(otherRule.filter);
        }
        return false;
    }

    public String toString() {
        return this.projectionAtom.getPredicate() + "(" + this.headTerms + ") <- " + this.extensionalNodes + " FILTER " + this.filter;
    }
}

