/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.spec.mapping.transformer.impl;

import com.google.inject.Inject;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableList;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableSet;
import it.unibz.inf.ontop.injection.CoreSingletons;
import it.unibz.inf.ontop.injection.IntermediateQueryFactory;
import it.unibz.inf.ontop.iq.IQ;
import it.unibz.inf.ontop.iq.IQTree;
import it.unibz.inf.ontop.iq.UnaryIQTree;
import it.unibz.inf.ontop.iq.node.ConstructionNode;
import it.unibz.inf.ontop.iq.node.UnaryOperatorNode;
import it.unibz.inf.ontop.model.atom.DistinctVariableOnlyDataAtom;
import it.unibz.inf.ontop.model.atom.RDFAtomPredicate;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.vocabulary.RDF;
import it.unibz.inf.ontop.spec.mapping.MappingAssertion;
import it.unibz.inf.ontop.spec.mapping.MappingAssertionIndex;
import it.unibz.inf.ontop.spec.mapping.pp.PPMappingAssertionProvenance;
import it.unibz.inf.ontop.spec.mapping.transformer.ABoxFactIntoMappingConverter;
import it.unibz.inf.ontop.spec.ontology.AnnotationAssertion;
import it.unibz.inf.ontop.spec.ontology.Assertion;
import it.unibz.inf.ontop.spec.ontology.OntologyABox;
import it.unibz.inf.ontop.substitution.SubstitutionFactory;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import it.unibz.inf.ontop.utils.VariableGenerator;
import java.util.Collection;
import java.util.stream.Stream;
import org.apache.commons.rdf.api.IRI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LegacyABoxFactIntoMappingConverter
implements ABoxFactIntoMappingConverter {
    private static final Logger LOGGER = LoggerFactory.getLogger(LegacyABoxFactIntoMappingConverter.class);
    private final TermFactory termFactory;
    private final IntermediateQueryFactory iqFactory;
    private final SubstitutionFactory substitutionFactory;
    private final DistinctVariableOnlyDataAtom projectionAtom;
    private final RDFAtomPredicate rdfAtomPredicate;

    @Inject
    public LegacyABoxFactIntoMappingConverter(CoreSingletons coreSingletons) {
        this.termFactory = coreSingletons.getTermFactory();
        this.iqFactory = coreSingletons.getIQFactory();
        this.substitutionFactory = coreSingletons.getSubstitutionFactory();
        VariableGenerator projectedVariableGenerator = coreSingletons.getCoreUtilsFactory().createVariableGenerator((Collection)ImmutableSet.of());
        this.projectionAtom = coreSingletons.getAtomFactory().getDistinctTripleAtom(projectedVariableGenerator.generateNewVariable(), projectedVariableGenerator.generateNewVariable(), projectedVariableGenerator.generateNewVariable());
        this.rdfAtomPredicate = (RDFAtomPredicate)this.projectionAtom.getPredicate();
    }

    @Override
    public ImmutableList<MappingAssertion> convert(OntologyABox ontology, boolean isOntologyAnnotationQueryingEnabled) {
        ImmutableList assertions = (ImmutableList)Stream.concat(Stream.concat(Stream.concat(ontology.getClassAssertions().stream().map(ca -> new MappingAssertion(MappingAssertionIndex.ofClass(this.rdfAtomPredicate, ca.getConcept().getIRI()), this.createFact((ImmutableTerm)ca.getIndividual(), RDF.TYPE, this.getIRI(ca.getConcept().getIRI())), new ABoxFactProvenance((Assertion)ca))), ontology.getObjectPropertyAssertions().stream().map(pa -> new MappingAssertion(MappingAssertionIndex.ofProperty(this.rdfAtomPredicate, pa.getProperty().getIRI()), this.createFact((ImmutableTerm)pa.getSubject(), pa.getProperty().getIRI(), (ImmutableTerm)pa.getObject()), new ABoxFactProvenance((Assertion)pa)))), ontology.getDataPropertyAssertions().stream().map(da -> new MappingAssertion(MappingAssertionIndex.ofProperty(this.rdfAtomPredicate, da.getProperty().getIRI()), this.createFact((ImmutableTerm)da.getSubject(), da.getProperty().getIRI(), (ImmutableTerm)da.getValue()), new ABoxFactProvenance((Assertion)da)))), (isOntologyAnnotationQueryingEnabled ? ontology.getAnnotationAssertions().stream() : Stream.of(new AnnotationAssertion[0])).map(aa -> new MappingAssertion(MappingAssertionIndex.ofProperty(this.rdfAtomPredicate, aa.getProperty().getIRI()), this.createFact((ImmutableTerm)aa.getSubject(), aa.getProperty().getIRI(), (ImmutableTerm)aa.getValue()), new ABoxFactProvenance((Assertion)aa)))).collect(ImmutableCollectors.toList());
        LOGGER.debug("Appended {} object property assertions as fact rules", (Object)ontology.getObjectPropertyAssertions().size());
        LOGGER.debug("Appended {} data property assertions as fact rules", (Object)ontology.getDataPropertyAssertions().size());
        LOGGER.debug("Appended {} annotation assertions as fact rules", (Object)ontology.getAnnotationAssertions().size());
        LOGGER.debug("Appended {} class assertions from ontology as fact rules", (Object)ontology.getClassAssertions().size());
        return assertions;
    }

    private IQ createFact(ImmutableTerm subject, IRI property, ImmutableTerm object) {
        ConstructionNode topConstructionNode = this.iqFactory.createConstructionNode(this.projectionAtom.getVariables(), this.substitutionFactory.getSubstitution(this.projectionAtom.getTerm(0), subject, this.projectionAtom.getTerm(1), this.getIRI(property), this.projectionAtom.getTerm(2), object));
        UnaryIQTree constructionTree = this.iqFactory.createUnaryIQTree((UnaryOperatorNode)topConstructionNode, (IQTree)this.iqFactory.createTrueNode());
        return this.iqFactory.createIQ(this.projectionAtom, (IQTree)constructionTree);
    }

    private ImmutableTerm getIRI(IRI iri) {
        return this.termFactory.getConstantIRI(iri);
    }

    private class ABoxFactProvenance
    implements PPMappingAssertionProvenance {
        private final String provenance;

        private ABoxFactProvenance(Assertion a) {
            this.provenance = a.toString();
        }

        @Override
        public String getProvenanceInfo() {
            return this.provenance;
        }
    }
}

