/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.spec.mapping.transformer.impl;

import it.unibz.inf.ontop.com.google.common.collect.ImmutableList;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableMap;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableSet;
import it.unibz.inf.ontop.injection.CoreSingletons;
import it.unibz.inf.ontop.injection.IntermediateQueryFactory;
import it.unibz.inf.ontop.iq.IQTree;
import it.unibz.inf.ontop.iq.node.ExtensionalDataNode;
import it.unibz.inf.ontop.iq.node.FilterNode;
import it.unibz.inf.ontop.iq.node.InnerJoinNode;
import it.unibz.inf.ontop.iq.node.NaryOperatorNode;
import it.unibz.inf.ontop.iq.node.QueryNode;
import it.unibz.inf.ontop.iq.node.TrueNode;
import it.unibz.inf.ontop.iq.node.UnaryOperatorNode;
import it.unibz.inf.ontop.model.atom.AtomFactory;
import it.unibz.inf.ontop.model.atom.AtomPredicate;
import it.unibz.inf.ontop.model.atom.DataAtom;
import it.unibz.inf.ontop.model.atom.RelationPredicate;
import it.unibz.inf.ontop.model.term.ImmutableExpression;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import it.unibz.inf.ontop.utils.VariableGenerator;
import java.util.Collection;
import java.util.Optional;
import java.util.stream.IntStream;

public class IQ2CQ {
    public static ImmutableList<DataAtom<RelationPredicate>> toDataAtoms(ImmutableList<ExtensionalDataNode> nodes, CoreSingletons singletons) {
        AtomFactory atomFactory = singletons.getAtomFactory();
        VariableGenerator variableGenerator = singletons.getCoreUtilsFactory().createVariableGenerator((Collection)nodes.stream().flatMap(a -> a.getVariables().stream()).collect(ImmutableCollectors.toSet()));
        return (ImmutableList)nodes.stream().map(node -> IQ2CQ.toDataAtom(node, variableGenerator, atomFactory)).collect(ImmutableCollectors.toList());
    }

    private static DataAtom<RelationPredicate> toDataAtom(ExtensionalDataNode node, VariableGenerator variableGenerator, AtomFactory atomFactory) {
        ImmutableMap argumentMap = node.getArgumentMap();
        RelationPredicate predicate = node.getRelationDefinition().getAtomPredicate();
        ImmutableList newArguments = (ImmutableList)IntStream.range(0, predicate.getArity()).boxed().map(i -> Optional.ofNullable(argumentMap.get(i)).map(t -> t).orElseGet(() -> ((VariableGenerator)variableGenerator).generateNewVariable())).collect(ImmutableCollectors.toList());
        return atomFactory.getDataAtom((AtomPredicate)predicate, newArguments);
    }

    public static IQTree toIQTree(ImmutableList<? extends IQTree> extensionalNodes, Optional<ImmutableExpression> joiningConditions, IntermediateQueryFactory iqFactory) {
        switch (extensionalNodes.size()) {
            case 0: {
                return iqFactory.createTrueNode();
            }
            case 1: {
                return joiningConditions.isPresent() ? iqFactory.createUnaryIQTree((UnaryOperatorNode)iqFactory.createFilterNode(joiningConditions.get()), (IQTree)extensionalNodes.get(0)) : (IQTree)extensionalNodes.get(0);
            }
        }
        return iqFactory.createNaryIQTree((NaryOperatorNode)iqFactory.createInnerJoinNode(joiningConditions), (ImmutableList)extensionalNodes.stream().collect(ImmutableCollectors.toList()));
    }

    public static Optional<ImmutableList<ExtensionalDataNode>> getExtensionalDataNodes(IQTree tree) {
        QueryNode node = tree.getRootNode();
        if (node instanceof FilterNode) {
            return Optional.of(ImmutableList.of((Object)((ExtensionalDataNode)tree.getChildren().get(0))));
        }
        if (node instanceof ExtensionalDataNode) {
            return Optional.of(ImmutableList.of((Object)((ExtensionalDataNode)tree)));
        }
        if (node instanceof TrueNode) {
            return Optional.of(ImmutableList.of());
        }
        if (node instanceof InnerJoinNode) {
            if (tree.getChildren().stream().anyMatch(c -> !(c.getRootNode() instanceof ExtensionalDataNode))) {
                return Optional.empty();
            }
            return Optional.of(tree.getChildren().stream().map(n -> (ExtensionalDataNode)n).collect(ImmutableCollectors.toList()));
        }
        return Optional.empty();
    }

    public static ImmutableSet<ImmutableExpression> getFilterExpressions(IQTree tree) {
        QueryNode node = tree.getRootNode();
        if (node instanceof FilterNode) {
            return (ImmutableSet)((ImmutableExpression)((FilterNode)tree.getRootNode()).getOptionalFilterCondition().get()).flattenAND().collect(ImmutableCollectors.toSet());
        }
        if (node instanceof ExtensionalDataNode) {
            return ImmutableSet.of();
        }
        if (node instanceof TrueNode) {
            return ImmutableSet.of();
        }
        if (node instanceof InnerJoinNode) {
            return ((InnerJoinNode)tree.getRootNode()).getOptionalFilterCondition().map(e -> (ImmutableSet)e.flattenAND().collect(ImmutableCollectors.toSet())).orElseGet(ImmutableSet::of);
        }
        throw new IllegalStateException("Use getExtensionalDataNodes first to check whether it's a CQ");
    }
}

