/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.spec.mapping.impl;

import it.unibz.inf.ontop.com.google.common.collect.ImmutableList;
import it.unibz.inf.ontop.model.atom.DistinctVariableOnlyDataAtom;
import it.unibz.inf.ontop.model.atom.RDFAtomPredicate;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.spec.mapping.TargetAtom;
import it.unibz.inf.ontop.substitution.ImmutableSubstitution;
import it.unibz.inf.ontop.substitution.InjectiveVar2VarSubstitution;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import java.util.Optional;
import org.apache.commons.rdf.api.IRI;

public class TargetAtomImpl
implements TargetAtom {
    protected final DistinctVariableOnlyDataAtom atom;
    protected final ImmutableSubstitution<ImmutableTerm> substitution;

    protected TargetAtomImpl(DistinctVariableOnlyDataAtom atom, ImmutableSubstitution<ImmutableTerm> substitution) {
        this.atom = atom;
        this.substitution = substitution;
    }

    @Override
    public DistinctVariableOnlyDataAtom getProjectionAtom() {
        return this.atom;
    }

    @Override
    public ImmutableSubstitution<ImmutableTerm> getSubstitution() {
        return this.substitution;
    }

    @Override
    public ImmutableTerm getSubstitutedTerm(int index) {
        return this.substitution.apply((ImmutableTerm)this.atom.getTerm(index));
    }

    @Override
    public ImmutableList<ImmutableTerm> getSubstitutedTerms() {
        return (ImmutableList)this.atom.getArguments().stream().map(arg_0 -> this.substitution.apply(arg_0)).collect(ImmutableCollectors.toList());
    }

    @Override
    public TargetAtom rename(InjectiveVar2VarSubstitution renamingSubstitution) {
        return new TargetAtomImpl(renamingSubstitution.applyToDistinctVariableOnlyDataAtom(this.atom), (ImmutableSubstitution<ImmutableTerm>)renamingSubstitution.applyRenaming(this.substitution));
    }

    @Override
    public TargetAtom changeSubstitution(ImmutableSubstitution<ImmutableTerm> newSubstitution) {
        return new TargetAtomImpl(this.atom, newSubstitution);
    }

    @Override
    public Optional<IRI> getPredicateIRI() {
        return Optional.of(this.atom.getPredicate()).filter(p -> p instanceof RDFAtomPredicate).map(p -> (RDFAtomPredicate)p).flatMap(p -> p.getPredicateIRI(this.getSubstitutedTerms()));
    }

    public String toString() {
        return this.atom.toString() + " with " + this.substitution.toString();
    }
}

