/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.spec.mapping.transformer.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import it.unibz.inf.ontop.exception.OntopInternalBugException;
import it.unibz.inf.ontop.injection.CoreSingletons;
import it.unibz.inf.ontop.injection.IntermediateQueryFactory;
import it.unibz.inf.ontop.injection.OntopMappingSettings;
import it.unibz.inf.ontop.injection.QueryTransformerFactory;
import it.unibz.inf.ontop.iq.IQ;
import it.unibz.inf.ontop.iq.IQTree;
import it.unibz.inf.ontop.iq.node.IntensionalDataNode;
import it.unibz.inf.ontop.iq.node.NaryOperatorNode;
import it.unibz.inf.ontop.iq.node.UnaryOperatorNode;
import it.unibz.inf.ontop.iq.optimizer.impl.AbstractIntensionalQueryMerger;
import it.unibz.inf.ontop.iq.tools.UnionBasedQueryMerger;
import it.unibz.inf.ontop.model.atom.AtomFactory;
import it.unibz.inf.ontop.model.atom.AtomPredicate;
import it.unibz.inf.ontop.model.atom.DataAtom;
import it.unibz.inf.ontop.model.atom.DistinctVariableOnlyDataAtom;
import it.unibz.inf.ontop.model.atom.RDFAtomPredicate;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.model.term.VariableOrGroundTerm;
import it.unibz.inf.ontop.model.vocabulary.Ontop;
import it.unibz.inf.ontop.spec.mapping.MappingAssertion;
import it.unibz.inf.ontop.spec.mapping.transformer.MappingCanonicalTransformer;
import it.unibz.inf.ontop.substitution.SubstitutionFactory;
import it.unibz.inf.ontop.utils.CoreUtilsFactory;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import it.unibz.inf.ontop.utils.VariableGenerator;
import java.util.Collection;
import java.util.Optional;
import java.util.Set;

public class MappingCanonicalTransformerImpl
implements MappingCanonicalTransformer {
    private final IntermediateQueryFactory iqFactory;
    private final QueryTransformerFactory transformerFactory;
    private final SubstitutionFactory substitutionFactory;
    private final AtomFactory atomFactory;
    private final UnionBasedQueryMerger queryMerger;
    private final CoreUtilsFactory coreUtilsFactory;
    private final OntopMappingSettings settings;

    @Inject
    private MappingCanonicalTransformerImpl(CoreSingletons coreSingletons, QueryTransformerFactory transformerFactory, UnionBasedQueryMerger queryMerger, OntopMappingSettings settings) {
        this.coreUtilsFactory = coreSingletons.getCoreUtilsFactory();
        this.settings = settings;
        this.iqFactory = coreSingletons.getIQFactory();
        this.transformerFactory = transformerFactory;
        this.substitutionFactory = coreSingletons.getSubstitutionFactory();
        this.atomFactory = coreSingletons.getAtomFactory();
        this.queryMerger = queryMerger;
    }

    @Override
    public ImmutableList<MappingAssertion> transform(ImmutableList<MappingAssertion> mapping) {
        Optional<IQ> canIRIDefinition = this.extractCanIRIDefinition(mapping);
        return canIRIDefinition.isPresent() ? this.transformMapping(mapping, new IntensionalQueryMerger(canIRIDefinition.get())) : mapping;
    }

    private Optional<IQ> extractCanIRIDefinition(ImmutableList<MappingAssertion> mapping) {
        return this.queryMerger.mergeDefinitions((Collection)mapping.stream().filter(a -> a.getIndex().getIri().equals((Object)Ontop.CANONICAL_IRI)).map(MappingAssertion::getQuery).collect(ImmutableCollectors.toList()));
    }

    private ImmutableList<MappingAssertion> transformMapping(ImmutableList<MappingAssertion> mapping, IntensionalQueryMerger intensionalQueryMerger) {
        return (ImmutableList)mapping.stream().filter(a -> !a.getIndex().getIri().equals((Object)Ontop.CANONICAL_IRI)).map(a -> this.transformAssertion((MappingAssertion)a, intensionalQueryMerger)).collect(ImmutableCollectors.toList());
    }

    private MappingAssertion transformAssertion(MappingAssertion assertion, IntensionalQueryMerger intensionalQueryMerger) {
        return this.settings.isCanIRIComplete() ? this.transformAssertionWithJoin(assertion, intensionalQueryMerger) : this.transformAssertionWithLeftJoin(assertion, intensionalQueryMerger);
    }

    private MappingAssertion transformAssertionWithLeftJoin(MappingAssertion assertion, IntensionalQueryMerger intensionalQueryMerger) {
        throw new RuntimeException("TODO: implement");
    }

    private MappingAssertion transformAssertionWithJoin(MappingAssertion assertion, IntensionalQueryMerger intensionalQueryMerger) {
        RDFAtomPredicate rdfAtomPredicate = assertion.getRDFAtomPredicate();
        if (assertion.getIndex().isClass()) {
            return this.canonizeWithJoin(assertion, intensionalQueryMerger, arg_0 -> ((RDFAtomPredicate)rdfAtomPredicate).getSubject(arg_0), (arg_0, arg_1) -> ((RDFAtomPredicate)rdfAtomPredicate).updateSubject(arg_0, arg_1));
        }
        MappingAssertion assertionWithCanonizedSubject = this.canonizeWithJoin(assertion, intensionalQueryMerger, arg_0 -> ((RDFAtomPredicate)rdfAtomPredicate).getSubject(arg_0), (arg_0, arg_1) -> ((RDFAtomPredicate)rdfAtomPredicate).updateSubject(arg_0, arg_1));
        return this.canonizeWithJoin(assertionWithCanonizedSubject, intensionalQueryMerger, arg_0 -> ((RDFAtomPredicate)rdfAtomPredicate).getObject(arg_0), (arg_0, arg_1) -> ((RDFAtomPredicate)rdfAtomPredicate).updateObject(arg_0, arg_1));
    }

    private MappingAssertion canonizeWithJoin(MappingAssertion assertion, IntensionalQueryMerger intensionalQueryMerger, RDFAtomPredicate.ComponentGetter componentGetter, RDFAtomPredicate.ComponentUpdater componentUpdater) {
        ImmutableList variables = assertion.getProjectionAtom().getArguments();
        Variable replacedVar = (Variable)componentGetter.get(variables);
        IQ iq = assertion.getQuery();
        Variable newVariable = this.createFreshVariable(iq, intensionalQueryMerger, replacedVar);
        IntensionalDataNode idn = this.iqFactory.createIntensionalDataNode(this.atomFactory.getIntensionalTripleAtom((VariableOrGroundTerm)newVariable, Ontop.CANONICAL_IRI, (VariableOrGroundTerm)replacedVar));
        DistinctVariableOnlyDataAtom projectionAtom = this.atomFactory.getDistinctVariableOnlyDataAtom((AtomPredicate)assertion.getRDFAtomPredicate(), componentUpdater.update(variables, (ImmutableTerm)newVariable));
        IQ intensionalCanonizedQuery = this.iqFactory.createIQ(projectionAtom, this.getIntensionalCanonizedTree(iq, projectionAtom, idn));
        IQ canonizedQuery = intensionalQueryMerger.optimize(intensionalCanonizedQuery).normalizeForOptimization();
        return canonizedQuery.getTree().isDeclaredAsEmpty() ? assertion : assertion.copyOf(canonizedQuery);
    }

    private IQTree getIntensionalCanonizedTree(IQ assertion, DistinctVariableOnlyDataAtom projAtom, IntensionalDataNode intensionalDataNode) {
        return this.iqFactory.createUnaryIQTree((UnaryOperatorNode)this.iqFactory.createConstructionNode(projAtom.getVariables()), (IQTree)this.iqFactory.createNaryIQTree((NaryOperatorNode)this.iqFactory.createInnerJoinNode(), ImmutableList.of((Object)assertion.getTree(), (Object)intensionalDataNode)));
    }

    private Variable createFreshVariable(IQ iq, IntensionalQueryMerger intensionalQueryMerger, Variable formerVariable) {
        VariableGenerator variableGenerator = this.coreUtilsFactory.createVariableGenerator((Collection)Sets.union((Set)iq.getTree().getKnownVariables(), intensionalQueryMerger.getKnownVariables()).immutableCopy());
        return variableGenerator.generateNewVariableFromVar(formerVariable);
    }

    private class IntensionalQueryMerger
    extends AbstractIntensionalQueryMerger {
        private final IQ definition;

        IntensionalQueryMerger(IQ definition) {
            super(MappingCanonicalTransformerImpl.this.iqFactory);
            this.definition = definition;
        }

        protected AbstractIntensionalQueryMerger.QueryMergingTransformer createTransformer(ImmutableSet<Variable> knownVariables) {
            VariableGenerator variableGenerator = MappingCanonicalTransformerImpl.this.coreUtilsFactory.createVariableGenerator(knownVariables);
            return new QueryMergingTransformer(variableGenerator);
        }

        public ImmutableSet<Variable> getKnownVariables() {
            return this.definition.getTree().getKnownVariables();
        }

        private class UnexpectedPredicateException
        extends OntopInternalBugException {
            UnexpectedPredicateException(AtomPredicate predicate) {
                super("canonical IRI predicate expected instead of :" + predicate);
            }
        }

        private class QueryMergingTransformer
        extends AbstractIntensionalQueryMerger.QueryMergingTransformer {
            QueryMergingTransformer(VariableGenerator variableGenerator) {
                super(variableGenerator, MappingCanonicalTransformerImpl.this.iqFactory, MappingCanonicalTransformerImpl.this.substitutionFactory, MappingCanonicalTransformerImpl.this.transformerFactory);
            }

            protected Optional<IQ> getDefinition(IntensionalDataNode dataNode) {
                DataAtom atom = dataNode.getProjectionAtom();
                if (Optional.of(atom.getPredicate()).filter(p -> p instanceof RDFAtomPredicate).map(p -> (RDFAtomPredicate)p).flatMap(p -> p.getPropertyIRI(atom.getArguments())).filter(i -> i.equals((Object)Ontop.CANONICAL_IRI)).isPresent()) {
                    return Optional.of(IntensionalQueryMerger.this.definition);
                }
                throw new UnexpectedPredicateException(atom.getPredicate());
            }

            protected IQTree handleIntensionalWithoutDefinition(IntensionalDataNode dataNode) {
                return dataNode;
            }
        }
    }
}

