/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.spec.mapping.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import it.unibz.inf.ontop.model.atom.AtomFactory;
import it.unibz.inf.ontop.model.atom.DistinctVariableOnlyDataAtom;
import it.unibz.inf.ontop.model.term.IRIConstant;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.model.vocabulary.RDF;
import it.unibz.inf.ontop.spec.mapping.TargetAtom;
import it.unibz.inf.ontop.spec.mapping.TargetAtomFactory;
import it.unibz.inf.ontop.spec.mapping.impl.TargetAtomImpl;
import it.unibz.inf.ontop.substitution.ImmutableSubstitution;
import it.unibz.inf.ontop.substitution.SubstitutionFactory;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import java.util.stream.IntStream;
import org.apache.commons.rdf.api.IRI;

public class TargetAtomFactoryImpl
implements TargetAtomFactory {
    private final AtomFactory atomFactory;
    private final SubstitutionFactory substitutionFactory;
    private final Variable s;
    private final Variable p;
    private final Variable o;
    private final Variable g;
    private final TermFactory termFactory;

    @Inject
    private TargetAtomFactoryImpl(AtomFactory atomFactory, SubstitutionFactory substitutionFactory, TermFactory termFactory) {
        this.atomFactory = atomFactory;
        this.substitutionFactory = substitutionFactory;
        this.termFactory = termFactory;
        this.s = this.termFactory.getVariable("s");
        this.p = this.termFactory.getVariable("p");
        this.o = this.termFactory.getVariable("o");
        this.g = this.termFactory.getVariable("g");
    }

    @Override
    public TargetAtom getTripleTargetAtom(ImmutableTerm subject, ImmutableTerm pred, ImmutableTerm object) {
        DistinctVariableOnlyDataAtom projectionAtom = this.atomFactory.getDistinctTripleAtom(subject instanceof Variable ? (Variable)subject : this.s, pred instanceof Variable && !pred.equals(subject) ? (Variable)pred : this.p, object instanceof Variable && !object.equals(subject) && !object.equals(pred) ? (Variable)object : this.o);
        ImmutableList initialTerms = ImmutableList.of((Object)subject, (Object)pred, (Object)object);
        ImmutableSubstitution substitution = this.substitutionFactory.getSubstitution((ImmutableMap)IntStream.range(0, 3).boxed().map(i -> Maps.immutableEntry((Object)projectionAtom.getTerm(i.intValue()), (Object)initialTerms.get(i.intValue()))).filter(e -> !((Variable)e.getKey()).equals(e.getValue())).collect(ImmutableCollectors.toMap()));
        return new TargetAtomImpl(projectionAtom, (ImmutableSubstitution<ImmutableTerm>)substitution);
    }

    @Override
    public TargetAtom getQuadTargetAtom(ImmutableTerm subject, ImmutableTerm pred, ImmutableTerm object, ImmutableTerm graph) {
        DistinctVariableOnlyDataAtom projectionAtom = this.atomFactory.getDistinctQuadAtom(subject instanceof Variable ? (Variable)subject : this.s, pred instanceof Variable && !pred.equals(subject) ? (Variable)pred : this.p, object instanceof Variable && !object.equals(subject) && !object.equals(pred) ? (Variable)object : this.o, graph instanceof Variable ? (Variable)graph : this.g);
        ImmutableList initialTerms = ImmutableList.of((Object)subject, (Object)pred, (Object)object, (Object)graph);
        ImmutableSubstitution substitution = this.substitutionFactory.getSubstitution((ImmutableMap)IntStream.range(0, 4).boxed().map(i -> Maps.immutableEntry((Object)projectionAtom.getTerm(i.intValue()), (Object)initialTerms.get(i.intValue()))).filter(e -> !((Variable)e.getKey()).equals(e.getValue())).collect(ImmutableCollectors.toMap()));
        return new TargetAtomImpl(projectionAtom, (ImmutableSubstitution<ImmutableTerm>)substitution);
    }

    @Override
    public TargetAtom getTripleTargetAtom(ImmutableTerm subjectTerm, IRI classIRI) {
        return this.getTripleTargetAtom(subjectTerm, (ImmutableTerm)this.createIRIConstant(RDF.TYPE), (ImmutableTerm)this.createIRIConstant(classIRI));
    }

    @Override
    public TargetAtom getQuadTargetAtom(ImmutableTerm subjectTerm, IRI classIRI, ImmutableTerm graphTerm) {
        return this.getQuadTargetAtom(subjectTerm, (ImmutableTerm)this.createIRIConstant(RDF.TYPE), (ImmutableTerm)this.createIRIConstant(classIRI), graphTerm);
    }

    @Override
    public TargetAtom getTripleTargetAtom(ImmutableTerm subjectTerm, IRI propertyIRI, ImmutableTerm objectTerm) {
        return this.getTripleTargetAtom(subjectTerm, (ImmutableTerm)this.createIRIConstant(propertyIRI), objectTerm);
    }

    @Override
    public TargetAtom getTargetAtom(DistinctVariableOnlyDataAtom projectionAtom, ImmutableSubstitution<ImmutableTerm> substitution) {
        return new TargetAtomImpl(projectionAtom, substitution);
    }

    private IRIConstant createIRIConstant(IRI iri) {
        return this.termFactory.getConstantIRI(iri);
    }
}

