/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.spec.mapping;

import it.unibz.inf.ontop.spec.ontology.DataPropertyExpression;
import it.unibz.inf.ontop.spec.ontology.OClass;
import it.unibz.inf.ontop.spec.ontology.ObjectPropertyExpression;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class TMappingExclusionConfig {
    private final Set<String> classes;
    private final Set<String> properties;
    private static final TMappingExclusionConfig EMPTY = new TMappingExclusionConfig(Collections.emptySet(), Collections.emptySet());

    public TMappingExclusionConfig(Set<String> classes, Set<String> properties) {
        this.classes = classes;
        this.properties = properties;
    }

    public boolean contains(OClass cls) {
        return this.classes.contains(cls.getIRI().getIRIString());
    }

    public boolean contains(ObjectPropertyExpression propertyExpression) {
        return !propertyExpression.isInverse() && this.properties.contains(propertyExpression.getIRI().getIRIString());
    }

    public boolean contains(DataPropertyExpression propertyExpression) {
        return this.properties.contains(propertyExpression.getIRI().getIRIString());
    }

    public static TMappingExclusionConfig empty() {
        return EMPTY;
    }

    public static TMappingExclusionConfig parseFile(String fileName) throws IOException {
        String s;
        HashSet<String> classes = new HashSet<String>();
        HashSet<String> properties = new HashSet<String>();
        BufferedReader in = new BufferedReader(new FileReader(fileName));
        while ((s = in.readLine()) != null) {
            if ((s = s.trim()).isEmpty() || s.startsWith("#")) continue;
            String separator = " ";
            String[] s2 = s.split("\\" + separator);
            if (s2.length != 2) {
                throw new IllegalArgumentException("cannot parse line (too many columns): " + s);
            }
            try {
                int arity = Integer.parseInt(s2[1]);
                if (arity == 1) {
                    classes.add(s2[0]);
                    continue;
                }
                if (Integer.parseInt(s2[1]) == 2) {
                    properties.add(s2[0]);
                    continue;
                }
                throw new IllegalArgumentException("cannot parse line (wrong arity): " + s);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("cannot parse line (wrong arity): " + s);
            }
        }
        TMappingExclusionConfig conf = new TMappingExclusionConfig(classes, properties);
        return conf;
    }
}

