/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.spec;

import it.unibz.inf.ontop.spec.impl.OBDASpecInputImpl;
import java.io.File;
import java.io.Reader;
import java.util.Optional;
import org.apache.commons.rdf.api.Graph;

public interface OBDASpecInput {
    public static final String MAPPING_KEY = "mapping";
    public static final String CONSTRAINT_KEY = "constraint";

    public Optional<File> getFile(String var1);

    public Optional<Reader> getReader(String var1);

    public Optional<Graph> getGraph(String var1);

    public static Builder defaultBuilder() {
        return new OBDASpecInputImpl.BuilderImpl();
    }

    default public Optional<File> getMappingFile() {
        return this.getFile(MAPPING_KEY);
    }

    default public Optional<Reader> getMappingReader() {
        return this.getReader(MAPPING_KEY);
    }

    default public Optional<Graph> getMappingGraph() {
        return this.getGraph(MAPPING_KEY);
    }

    default public Optional<File> getConstraintFile() {
        return this.getFile(CONSTRAINT_KEY);
    }

    public static interface Builder {
        public Builder addFile(String var1, File var2);

        public Builder addReader(String var1, Reader var2);

        public Builder addGraph(String var1, Graph var2);

        public OBDASpecInput build();

        default public Builder addMappingFile(File mappingFile) {
            return this.addFile(OBDASpecInput.MAPPING_KEY, mappingFile);
        }

        default public Builder addMappingReader(Reader mappingReader) {
            return this.addReader(OBDASpecInput.MAPPING_KEY, mappingReader);
        }

        default public Builder addMappingGraph(Graph mappingGraph) {
            return this.addGraph(OBDASpecInput.MAPPING_KEY, mappingGraph);
        }

        default public Builder addConstraintFile(File constraintFile) {
            return this.addFile(OBDASpecInput.CONSTRAINT_KEY, constraintFile);
        }
    }
}

