/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.injection.impl;

import com.google.common.collect.ImmutableList;
import com.google.inject.Module;
import it.unibz.inf.ontop.injection.MappingCoreSingletons;
import it.unibz.inf.ontop.injection.OntopMappingConfiguration;
import it.unibz.inf.ontop.injection.OntopMappingSettings;
import it.unibz.inf.ontop.injection.OntopModelSettings;
import it.unibz.inf.ontop.injection.TargetQueryParserFactory;
import it.unibz.inf.ontop.injection.impl.MappingCoreSingletonsImpl;
import it.unibz.inf.ontop.injection.impl.OntopAbstractModule;
import it.unibz.inf.ontop.spec.mapping.TMappingExclusionConfig;
import it.unibz.inf.ontop.spec.mapping.TargetAtomFactory;
import it.unibz.inf.ontop.spec.mapping.parser.TargetQueryParser;
import it.unibz.inf.ontop.spec.mapping.transformer.ABoxFactIntoMappingConverter;
import it.unibz.inf.ontop.spec.mapping.transformer.MappingCQCOptimizer;
import it.unibz.inf.ontop.spec.mapping.transformer.MappingCanonicalTransformer;
import it.unibz.inf.ontop.spec.mapping.transformer.MappingCaster;
import it.unibz.inf.ontop.spec.mapping.transformer.MappingDatatypeFiller;
import it.unibz.inf.ontop.spec.mapping.transformer.MappingDistinctTransformer;
import it.unibz.inf.ontop.spec.mapping.transformer.MappingEqualityTransformer;
import it.unibz.inf.ontop.spec.mapping.transformer.MappingSameAsInverseRewriter;
import it.unibz.inf.ontop.spec.mapping.transformer.MappingSaturator;
import it.unibz.inf.ontop.spec.mapping.transformer.MappingTransformer;
import it.unibz.inf.ontop.spec.mapping.transformer.MappingVariableNameNormalizer;
import it.unibz.inf.ontop.spec.mapping.transformer.QueryUnionSplitter;
import it.unibz.inf.ontop.spec.mapping.validation.MappingOntologyComplianceValidator;
import java.util.List;

public class OntopMappingModule
extends OntopAbstractModule {
    private final OntopMappingConfiguration configuration;

    OntopMappingModule(OntopMappingConfiguration configuration) {
        super((OntopModelSettings)configuration.getSettings());
        this.configuration = configuration;
    }

    protected void configure() {
        this.bindTMappingExclusionConfig();
        this.bind(OntopMappingSettings.class).toInstance((Object)this.configuration.getSettings());
        this.bindFromSettings(MappingVariableNameNormalizer.class);
        this.bindFromSettings(MappingSaturator.class);
        this.bindFromSettings(MappingCanonicalTransformer.class);
        this.bindFromSettings(ABoxFactIntoMappingConverter.class);
        this.bindFromSettings(MappingDatatypeFiller.class);
        this.bindFromSettings(MappingTransformer.class);
        this.bindFromSettings(MappingOntologyComplianceValidator.class);
        this.bindFromSettings(MappingSameAsInverseRewriter.class);
        this.bindFromSettings(MappingCQCOptimizer.class);
        this.bindFromSettings(QueryUnionSplitter.class);
        this.bindFromSettings(MappingCaster.class);
        this.bindFromSettings(MappingDistinctTransformer.class);
        this.bindFromSettings(MappingEqualityTransformer.class);
        this.bindFromSettings(TargetAtomFactory.class);
        this.bind(MappingCoreSingletons.class).to(MappingCoreSingletonsImpl.class);
        Module targetQueryParserModule = this.buildFactory((List)ImmutableList.of(TargetQueryParser.class), TargetQueryParserFactory.class);
        this.install(targetQueryParserModule);
    }

    private void bindTMappingExclusionConfig() {
        TMappingExclusionConfig tMappingExclusionConfig = this.configuration.getTmappingExclusions().orElseGet(TMappingExclusionConfig::empty);
        this.bind(TMappingExclusionConfig.class).toInstance((Object)tMappingExclusionConfig);
    }
}

