/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.spec.mapping.validation.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.UnmodifiableIterator;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import it.unibz.inf.ontop.exception.MappingOntologyMismatchException;
import it.unibz.inf.ontop.exception.OntopInternalBugException;
import it.unibz.inf.ontop.iq.IQ;
import it.unibz.inf.ontop.iq.node.ConstructionNode;
import it.unibz.inf.ontop.model.term.ImmutableFunctionalTerm;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.RDFConstant;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.model.type.ObjectRDFType;
import it.unibz.inf.ontop.model.type.RDFDatatype;
import it.unibz.inf.ontop.model.type.RDFTermType;
import it.unibz.inf.ontop.model.type.TermType;
import it.unibz.inf.ontop.model.type.TermTypeInference;
import it.unibz.inf.ontop.model.type.TypeFactory;
import it.unibz.inf.ontop.model.vocabulary.RDFS;
import it.unibz.inf.ontop.spec.mapping.MappingWithProvenance;
import it.unibz.inf.ontop.spec.mapping.pp.PPMappingAssertionProvenance;
import it.unibz.inf.ontop.spec.mapping.utils.MappingTools;
import it.unibz.inf.ontop.spec.mapping.validation.MappingOntologyComplianceValidator;
import it.unibz.inf.ontop.spec.ontology.ClassifiedTBox;
import it.unibz.inf.ontop.spec.ontology.DataPropertyRangeExpression;
import it.unibz.inf.ontop.spec.ontology.DataRangeExpression;
import it.unibz.inf.ontop.spec.ontology.Datatype;
import it.unibz.inf.ontop.spec.ontology.Equivalences;
import it.unibz.inf.ontop.spec.ontology.Ontology;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.StreamSupport;
import org.apache.commons.rdf.api.IRI;

@Singleton
public class MappingOntologyComplianceValidatorImpl
implements MappingOntologyComplianceValidator {
    private static final String DATA_PROPERTY_STR = "a data property";
    private static final String OBJECT_PROPERTY_STR = "an object property";
    private static final String ANNOTATION_PROPERTY_STR = "an annotation property";
    private static final String CLASS_STR = "a class";
    private final TermFactory termFactory;
    private final TypeFactory typeFactory;

    @Inject
    private MappingOntologyComplianceValidatorImpl(TermFactory termFactory, TypeFactory typeFactory) {
        this.termFactory = termFactory;
        this.typeFactory = typeFactory;
    }

    @Override
    public void validate(MappingWithProvenance mapping, Ontology ontology) throws MappingOntologyMismatchException {
        ImmutableMultimap<IRI, Datatype> datatypeMap = this.computeDataTypeMap(ontology.tbox());
        for (Map.Entry entry : mapping.getProvenanceMap().entrySet()) {
            this.validateAssertion((IQ)entry.getKey(), (PPMappingAssertionProvenance)entry.getValue(), ontology, datatypeMap);
        }
    }

    private void validateAssertion(IQ mappingAssertion, PPMappingAssertionProvenance provenance, Ontology ontology, ImmutableMultimap<IRI, Datatype> datatypeMap) throws MappingOntologyMismatchException {
        ImmutableList projectedVariables = mappingAssertion.getProjectionAtom().getArguments();
        MappingTools.RDFPredicateInfo predicateClassification = MappingTools.extractRDFPredicate(mappingAssertion);
        Optional<RDFTermType> tripleObjectType = predicateClassification.isClass() ? Optional.empty() : this.extractTripleObjectType(mappingAssertion);
        this.checkTripleObject(predicateClassification.getIri(), tripleObjectType, provenance, ontology, datatypeMap);
    }

    private Optional<RDFTermType> extractTripleObjectType(IQ mappingAssertion) throws TripleObjectTypeInferenceException {
        ImmutableList projectedVariables = mappingAssertion.getProjectionAtom().getArguments();
        Variable objectVariable = (Variable)projectedVariables.get(2);
        ImmutableTerm constructionTerm = (ImmutableTerm)Optional.of(mappingAssertion.getTree().getRootNode()).filter(n -> n instanceof ConstructionNode).map(n -> (ConstructionNode)n).map(ConstructionNode::getSubstitution).flatMap(s -> Optional.ofNullable(s.get(objectVariable))).orElseThrow(() -> new TripleObjectTypeInferenceException(mappingAssertion, objectVariable, "Not defined in the root node (expected for a mapping assertion)"));
        if (constructionTerm instanceof ImmutableFunctionalTerm) {
            ImmutableFunctionalTerm constructionFunctionalTerm = (ImmutableFunctionalTerm)constructionTerm;
            Optional<RDFTermType> optionalType = constructionFunctionalTerm.inferType().flatMap(TermTypeInference::getTermType).filter(t -> t instanceof RDFTermType).map(t -> (RDFTermType)t);
            if (!optionalType.isPresent()) {
                throw new TripleObjectTypeInferenceException(mappingAssertion, objectVariable, "Not defined in the root node (expected for a mapping assertion)");
            }
            return optionalType;
        }
        if (constructionTerm instanceof RDFConstant) {
            return Optional.of(((RDFConstant)constructionTerm).getType());
        }
        throw new TripleObjectTypeInferenceException(mappingAssertion, objectVariable, "Was expecting a functional or constant term (variables are not yet supported). \nTerm definition: " + constructionTerm);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void checkTripleObject(IRI predicateIRI, Optional<RDFTermType> optionalTripleObjectType, PPMappingAssertionProvenance provenance, Ontology ontology, ImmutableMultimap<IRI, Datatype> datatypeMap) throws MappingOntologyMismatchException {
        if (optionalTripleObjectType.isPresent()) {
            RDFTermType tripleObjectType = optionalTripleObjectType.get();
            if (tripleObjectType.isAbstract()) {
                throw new AbstractTripleObjectTypeException(predicateIRI, (TermType)tripleObjectType);
            }
            if (tripleObjectType instanceof ObjectRDFType) {
                this.checkObjectOrAnnotationProperty(predicateIRI, provenance, ontology);
                return;
            }
            if (!(tripleObjectType instanceof RDFDatatype)) throw new UndeterminedTripleObjectTypeException(predicateIRI, (TermType)tripleObjectType);
            this.checkDataOrAnnotationProperty((RDFDatatype)tripleObjectType, predicateIRI, provenance, ontology, datatypeMap);
            return;
        } else {
            this.checkClass(predicateIRI, provenance, ontology);
        }
    }

    private void checkObjectOrAnnotationProperty(IRI predicateIRI, PPMappingAssertionProvenance provenance, Ontology ontology) throws MappingOntologyMismatchException {
        if (ontology.tbox().dataProperties().contains(predicateIRI)) {
            throw new MappingOntologyMismatchException(MappingOntologyComplianceValidatorImpl.generatePropertyOrClassConflictMessage(predicateIRI, provenance, DATA_PROPERTY_STR, OBJECT_PROPERTY_STR));
        }
        if (ontology.tbox().classes().contains(predicateIRI)) {
            throw new MappingOntologyMismatchException(MappingOntologyComplianceValidatorImpl.generatePropertyOrClassConflictMessage(predicateIRI, provenance, CLASS_STR, OBJECT_PROPERTY_STR));
        }
    }

    private void checkDataOrAnnotationProperty(RDFDatatype tripleObjectType, IRI predicateIRI, PPMappingAssertionProvenance provenance, Ontology ontology, ImmutableMultimap<IRI, Datatype> datatypeMap) throws MappingOntologyMismatchException {
        Datatype declaredDatatype;
        if (ontology.tbox().objectProperties().contains(predicateIRI)) {
            throw new MappingOntologyMismatchException(MappingOntologyComplianceValidatorImpl.generatePropertyOrClassConflictMessage(predicateIRI, provenance, OBJECT_PROPERTY_STR, DATA_PROPERTY_STR));
        }
        if (ontology.tbox().classes().contains(predicateIRI)) {
            throw new MappingOntologyMismatchException(MappingOntologyComplianceValidatorImpl.generatePropertyOrClassConflictMessage(predicateIRI, provenance, CLASS_STR, DATA_PROPERTY_STR));
        }
        UnmodifiableIterator unmodifiableIterator = datatypeMap.get((Object)predicateIRI).iterator();
        while (unmodifiableIterator.hasNext() && !(declaredDatatype = (Datatype)unmodifiableIterator.next()).getIRI().equals((Object)RDFS.LITERAL)) {
            RDFDatatype declaredTermType = this.typeFactory.getDatatype(declaredDatatype.getIRI());
            if (tripleObjectType.isA((TermType)declaredTermType)) continue;
            throw new MappingOntologyMismatchException(predicateIRI + " is declared with datatype " + declaredDatatype + " in the ontology, but has datatype " + tripleObjectType.getIRI() + " according to the following triplesMap (either declared in the triplesMap, or inferred from its source):\n[\n" + provenance.getProvenanceInfo() + "\n]\n");
        }
    }

    private void checkClass(IRI predicateIRI, PPMappingAssertionProvenance provenance, Ontology ontology) throws MappingOntologyMismatchException {
        if (ontology.tbox().objectProperties().contains(predicateIRI)) {
            throw new MappingOntologyMismatchException(MappingOntologyComplianceValidatorImpl.generatePropertyOrClassConflictMessage(predicateIRI, provenance, OBJECT_PROPERTY_STR, CLASS_STR));
        }
        if (ontology.tbox().dataProperties().contains(predicateIRI)) {
            throw new MappingOntologyMismatchException(MappingOntologyComplianceValidatorImpl.generatePropertyOrClassConflictMessage(predicateIRI, provenance, DATA_PROPERTY_STR, CLASS_STR));
        }
        if (ontology.annotationProperties().contains(predicateIRI)) {
            throw new MappingOntologyMismatchException(MappingOntologyComplianceValidatorImpl.generatePropertyOrClassConflictMessage(predicateIRI, provenance, ANNOTATION_PROPERTY_STR, DATA_PROPERTY_STR));
        }
    }

    private static String generatePropertyOrClassConflictMessage(IRI predicateIRI, PPMappingAssertionProvenance provenance, String declaredTypeString, String usedTypeString) {
        return predicateIRI + " is declared as " + declaredTypeString + " in the ontology, but is used as " + usedTypeString + " in the triplesMap: \n[\n" + provenance.getProvenanceInfo() + "\n]";
    }

    private ImmutableMultimap<IRI, Datatype> computeDataTypeMap(ClassifiedTBox reasoner) {
        return (ImmutableMultimap)StreamSupport.stream(reasoner.dataRangesDAG().spliterator(), false).flatMap(n -> this.getPartialPredicateToDatatypeMap((Equivalences<DataRangeExpression>)n, reasoner).entrySet().stream()).collect(ImmutableCollectors.toMultimap(e -> (IRI)e.getKey(), Map.Entry::getValue));
    }

    private ImmutableMap<IRI, Datatype> getPartialPredicateToDatatypeMap(Equivalences<DataRangeExpression> nodeSet, ClassifiedTBox reasoner) {
        DataRangeExpression node = (DataRangeExpression)nodeSet.getRepresentative();
        return ImmutableMap.builder().putAll(this.getDescendentNodesPartialMap(reasoner, node, nodeSet)).putAll(this.getEquivalentNodesPartialMap(node, nodeSet)).build();
    }

    private ImmutableMap<IRI, Datatype> getDescendentNodesPartialMap(ClassifiedTBox reasoner, DataRangeExpression node, Equivalences<DataRangeExpression> nodeSet) {
        if (node instanceof Datatype) {
            return (ImmutableMap)reasoner.dataRangesDAG().getSub(nodeSet).stream().map(Equivalences::getRepresentative).filter(d -> d != node).map(this::getPredicateIRI).filter(Optional::isPresent).collect(ImmutableCollectors.toMap(Optional::get, d -> (Datatype)node));
        }
        return ImmutableMap.of();
    }

    private ImmutableMap<IRI, Datatype> getEquivalentNodesPartialMap(DataRangeExpression node, Equivalences<DataRangeExpression> nodeSet) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (DataRangeExpression equivalent : nodeSet) {
            if (equivalent == node) continue;
            if (equivalent instanceof Datatype) {
                this.getPredicateIRI(node).ifPresent(p -> builder.put(p, (Object)((Datatype)equivalent)));
            }
            if (!(node instanceof Datatype)) continue;
            this.getPredicateIRI(equivalent).ifPresent(p -> builder.put(p, (Object)((Datatype)node)));
        }
        return builder.build();
    }

    private Optional<IRI> getPredicateIRI(DataRangeExpression expression) {
        if (expression instanceof Datatype) {
            return Optional.of(((Datatype)expression).getIRI());
        }
        if (expression instanceof DataPropertyRangeExpression) {
            return Optional.of(((DataPropertyRangeExpression)expression).getProperty().getIRI());
        }
        return Optional.empty();
    }

    private Variable generateFreshVariable() {
        return this.termFactory.getVariable("fresh-" + UUID.randomUUID());
    }

    private static class AbstractTripleObjectTypeException
    extends OntopInternalBugException {
        AbstractTripleObjectTypeException(IRI iri, TermType tripleObjectType) {
            super("Internal bug: abstract type (" + tripleObjectType + ") for " + iri + ". Should have been detected earlier.");
        }
    }

    private static class UndeterminedTripleObjectTypeException
    extends OntopInternalBugException {
        UndeterminedTripleObjectTypeException(IRI iri, TermType tripleObjectType) {
            super("Internal bug: undetermined type (" + tripleObjectType + ") for " + iri);
        }
    }

    private static class TripleObjectTypeInferenceException
    extends OntopInternalBugException {
        TripleObjectTypeInferenceException(IQ mappingAssertion, Variable tripleObjectVariable, String reason) {
            super("Internal bug: cannot infer the type of " + tripleObjectVariable + " in: \n" + mappingAssertion + "\n Reason: " + reason);
        }

        TripleObjectTypeInferenceException(IQ mappingAssertion, String reason) {
            super("Internal bug: cannot infer the type of the object term  in: \n" + mappingAssertion + "\n Reason: " + reason);
        }
    }
}

