/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.spec.mapping.utils;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import it.unibz.inf.ontop.exception.OntopInternalBugException;
import it.unibz.inf.ontop.iq.IQ;
import it.unibz.inf.ontop.model.atom.DistinctVariableOnlyDataAtom;
import it.unibz.inf.ontop.model.atom.RDFAtomPredicate;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.vocabulary.RDF;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import java.util.Optional;
import java.util.function.Function;
import org.apache.commons.rdf.api.IRI;

public class MappingTools {
    public static RDFPredicateInfo extractRDFPredicate(IQ mappingAssertion) {
        DistinctVariableOnlyDataAtom projectionAtom = mappingAssertion.getProjectionAtom();
        RDFAtomPredicate rdfAtomPredicate = Optional.of(projectionAtom.getPredicate()).filter(p -> p instanceof RDFAtomPredicate).map(p -> (RDFAtomPredicate)p).orElseThrow(() -> new MappingPredicateIRIExtractionException("The following mapping assertion is not having a RDFAtomPredicate: " + mappingAssertion));
        ImmutableSet possibleSubstitutedArguments = (ImmutableSet)mappingAssertion.getTree().getPossibleVariableDefinitions().stream().map(s -> s.apply(projectionAtom.getArguments())).collect(ImmutableCollectors.toSet());
        IRI propertyIRI = MappingTools.extractIRI((ImmutableSet<ImmutableList<? extends ImmutableTerm>>)possibleSubstitutedArguments, arg_0 -> ((RDFAtomPredicate)rdfAtomPredicate).getPropertyIRI(arg_0));
        return propertyIRI.equals((Object)RDF.TYPE) ? new RDFPredicateInfo(true, MappingTools.extractIRI((ImmutableSet<ImmutableList<? extends ImmutableTerm>>)possibleSubstitutedArguments, arg_0 -> ((RDFAtomPredicate)rdfAtomPredicate).getClassIRI(arg_0))) : new RDFPredicateInfo(false, propertyIRI);
    }

    private static IRI extractIRI(ImmutableSet<ImmutableList<? extends ImmutableTerm>> possibleSubstitutedArguments, Function<ImmutableList<? extends ImmutableTerm>, Optional<IRI>> iriExtractor) {
        ImmutableList possibleIris = (ImmutableList)possibleSubstitutedArguments.stream().map(iriExtractor).distinct().collect(ImmutableCollectors.toList());
        if (!possibleIris.stream().allMatch(Optional::isPresent)) {
            throw new MappingPredicateIRIExtractionException("The definition of the predicate is not always a ground term");
        }
        if (possibleIris.size() != 1) {
            throw new MappingPredicateIRIExtractionException("The definition of the predicate is not unique: " + possibleIris + " from " + possibleSubstitutedArguments);
        }
        return possibleIris.stream().map(Optional::get).findFirst().get();
    }

    public static class RDFPredicateInfo {
        private final boolean isClass;
        private final IRI iri;

        public RDFPredicateInfo(boolean isClass, IRI iri) {
            this.isClass = isClass;
            this.iri = iri;
        }

        public boolean isClass() {
            return this.isClass;
        }

        public IRI getIri() {
            return this.iri;
        }

        public int hashCode() {
            return this.iri.hashCode();
        }

        public boolean equals(Object o) {
            if (o instanceof RDFPredicateInfo) {
                RDFPredicateInfo other = (RDFPredicateInfo)o;
                return this.iri.equals((Object)other.iri) && this.isClass == other.isClass;
            }
            return false;
        }

        public String toString() {
            return (this.isClass ? "C/" : "P/") + this.iri;
        }
    }

    private static class MappingPredicateIRIExtractionException
    extends OntopInternalBugException {
        private MappingPredicateIRIExtractionException(String message) {
            super("Internal bug: " + message);
        }
    }
}

