/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.spec.mapping.transformer.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import it.unibz.inf.ontop.injection.IntermediateQueryFactory;
import it.unibz.inf.ontop.iq.IQ;
import it.unibz.inf.ontop.iq.IQTree;
import it.unibz.inf.ontop.iq.node.ConstructionNode;
import it.unibz.inf.ontop.iq.node.ExtensionalDataNode;
import it.unibz.inf.ontop.iq.node.UnaryOperatorNode;
import it.unibz.inf.ontop.model.atom.AtomFactory;
import it.unibz.inf.ontop.model.atom.DistinctVariableOnlyDataAtom;
import it.unibz.inf.ontop.model.atom.RDFAtomPredicate;
import it.unibz.inf.ontop.model.term.IRIConstant;
import it.unibz.inf.ontop.model.term.ImmutableExpression;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.model.term.VariableOrGroundTerm;
import it.unibz.inf.ontop.model.vocabulary.RDF;
import it.unibz.inf.ontop.spec.mapping.transformer.impl.IQ2CQ;
import it.unibz.inf.ontop.spec.mapping.utils.MappingTools;
import it.unibz.inf.ontop.substitution.ImmutableSubstitution;
import it.unibz.inf.ontop.substitution.SubstitutionFactory;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import it.unibz.inf.ontop.utils.VariableGenerator;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.commons.rdf.api.IRI;

public class TMappingRule {
    private final MappingTools.RDFPredicateInfo predicateInfo;
    private final DistinctVariableOnlyDataAtom projectionAtom;
    private final ImmutableSubstitution<ImmutableTerm> substitution;
    private final ImmutableList<ExtensionalDataNode> extensionalNodes;
    private final ImmutableList<ImmutableList<ImmutableExpression>> filter;
    private final TermFactory termFactory;

    public TMappingRule(IQ iq, TermFactory termFactory, AtomFactory atomFactory) {
        this.termFactory = termFactory;
        this.predicateInfo = MappingTools.extractRDFPredicate(iq);
        this.projectionAtom = iq.getProjectionAtom();
        this.substitution = ((ConstructionNode)iq.getTree().getRootNode()).getSubstitution();
        IQTree tree = (IQTree)iq.getTree().getChildren().get(0);
        ImmutableList<ExtensionalDataNode> dataAtoms = IQ2CQ.getExtensionalDataNodes(tree).get();
        ImmutableSet<ImmutableExpression> joinConditions = IQ2CQ.getFilterExpressions(tree);
        VariableGenerator variableGenerator = iq.getVariableGenerator();
        ImmutableMap valueMap = (ImmutableMap)dataAtoms.stream().flatMap(n -> n.getProjectionAtom().getArguments().stream()).filter(t -> !(t instanceof Variable)).distinct().collect(ImmutableCollectors.toMap(t -> t, t -> variableGenerator.generateNewVariable()));
        this.extensionalNodes = (ImmutableList)dataAtoms.stream().map(n -> n.newAtom(atomFactory.getDataAtom(n.getProjectionAtom().getPredicate(), (ImmutableList)n.getProjectionAtom().getArguments().stream().map(term -> (VariableOrGroundTerm)valueMap.getOrDefault(term, term)).collect(ImmutableCollectors.toList())))).collect(ImmutableCollectors.toList());
        ImmutableList filterAtoms = (ImmutableList)Stream.concat(joinConditions.stream(), valueMap.entrySet().stream().map(e -> termFactory.getStrictEquality((ImmutableTerm)e.getKey(), (ImmutableTerm)e.getValue(), new ImmutableTerm[0]))).collect(ImmutableCollectors.toList());
        this.filter = filterAtoms.isEmpty() ? ImmutableList.of() : ImmutableList.of((Object)filterAtoms);
    }

    TMappingRule(TMappingRule baseRule, ImmutableList<ImmutableList<ImmutableExpression>> filter) {
        this.termFactory = baseRule.termFactory;
        this.predicateInfo = baseRule.predicateInfo;
        this.projectionAtom = baseRule.projectionAtom;
        this.substitution = baseRule.substitution;
        this.extensionalNodes = baseRule.extensionalNodes;
        this.filter = filter;
    }

    TMappingRule(ImmutableList<ImmutableTerm> headTerms, MappingTools.RDFPredicateInfo predicateInfo, TMappingRule baseRule, SubstitutionFactory substitutionFactory) {
        this.termFactory = baseRule.termFactory;
        this.predicateInfo = predicateInfo;
        this.projectionAtom = baseRule.projectionAtom;
        if (predicateInfo.isClass()) {
            this.substitution = substitutionFactory.getSubstitution(this.projectionAtom.getTerm(0), (ImmutableTerm)headTerms.get(0), this.projectionAtom.getTerm(1), (ImmutableTerm)this.getConstantIRI(RDF.TYPE), this.projectionAtom.getTerm(2), (ImmutableTerm)this.getConstantIRI(predicateInfo.getIri()));
        } else if (headTerms.get(1) instanceof Variable) {
            if (!((ImmutableTerm)headTerms.get(1)).equals(this.projectionAtom.getTerm(2))) {
                throw new IllegalStateException("The last argument does not match");
            }
            this.substitution = substitutionFactory.getSubstitution(this.projectionAtom.getTerm(0), (ImmutableTerm)headTerms.get(0), this.projectionAtom.getTerm(1), (ImmutableTerm)this.getConstantIRI(predicateInfo.getIri()));
        } else {
            this.substitution = substitutionFactory.getSubstitution(this.projectionAtom.getTerm(0), (ImmutableTerm)headTerms.get(0), this.projectionAtom.getTerm(1), (ImmutableTerm)this.getConstantIRI(predicateInfo.getIri()), this.projectionAtom.getTerm(2), (ImmutableTerm)headTerms.get(1));
        }
        this.extensionalNodes = baseRule.extensionalNodes;
        this.filter = baseRule.filter;
    }

    private IRIConstant getConstantIRI(IRI iri) {
        return this.termFactory.getConstantIRI(iri);
    }

    public MappingTools.RDFPredicateInfo getPredicateInfo() {
        return this.predicateInfo;
    }

    public IQ asIQ(IntermediateQueryFactory iqFactory) {
        Optional<ImmutableExpression> mergedConditions = this.filter.stream().map(list -> (ImmutableExpression)list.stream().reduce((r, e) -> this.termFactory.getConjunction(e, new ImmutableExpression[]{r})).get()).reduce((r, e) -> this.termFactory.getDisjunction(e, new ImmutableExpression[]{r}));
        return iqFactory.createIQ(this.projectionAtom, (IQTree)iqFactory.createUnaryIQTree((UnaryOperatorNode)iqFactory.createConstructionNode(this.projectionAtom.getVariables(), this.substitution), IQ2CQ.toIQTree(this.extensionalNodes, mergedConditions, iqFactory)));
    }

    public ImmutableList<ImmutableTerm> getHeadTerms() {
        return this.predicateInfo.isClass() ? ImmutableList.of((Object)this.substitution.applyToVariable(this.projectionAtom.getTerm(0))) : ImmutableList.of((Object)this.substitution.applyToVariable(this.projectionAtom.getTerm(0)), (Object)this.substitution.applyToVariable(this.projectionAtom.getTerm(2)));
    }

    public ImmutableList<ExtensionalDataNode> getDatabaseAtoms() {
        return this.extensionalNodes;
    }

    public ImmutableList<ImmutableList<ImmutableExpression>> getConditions() {
        return this.filter;
    }

    public RDFAtomPredicate getRDFAtomPredicate() {
        return (RDFAtomPredicate)this.projectionAtom.getPredicate();
    }

    public int hashCode() {
        return this.predicateInfo.getIri().hashCode() ^ this.substitution.hashCode() ^ this.extensionalNodes.hashCode() ^ this.filter.hashCode();
    }

    public boolean equals(Object other) {
        if (other instanceof TMappingRule) {
            TMappingRule otherRule = (TMappingRule)other;
            return this.projectionAtom.getArguments().equals((Object)otherRule.projectionAtom.getArguments()) && this.substitution.equals(otherRule.substitution) && this.extensionalNodes.equals(otherRule.extensionalNodes) && this.filter.equals(otherRule.filter);
        }
        return false;
    }

    public String toString() {
        return this.predicateInfo.getIri() + "(" + this.substitution.apply(this.projectionAtom.getArguments()) + ") <- " + this.extensionalNodes + " FILTER " + this.filter;
    }
}

