/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.spec.mapping.transformer.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableTable;
import com.google.common.collect.Table;
import com.google.common.collect.Tables;
import com.google.inject.Inject;
import it.unibz.inf.ontop.constraints.ImmutableCQContainmentCheck;
import it.unibz.inf.ontop.constraints.impl.ImmutableCQContainmentCheckUnderLIDs;
import it.unibz.inf.ontop.datalog.QueryUnionSplitter;
import it.unibz.inf.ontop.datalog.UnionFlattener;
import it.unibz.inf.ontop.injection.IntermediateQueryFactory;
import it.unibz.inf.ontop.injection.SpecificationFactory;
import it.unibz.inf.ontop.iq.IQ;
import it.unibz.inf.ontop.iq.tools.UnionBasedQueryMerger;
import it.unibz.inf.ontop.iq.transform.NoNullValueEnforcer;
import it.unibz.inf.ontop.model.atom.AtomFactory;
import it.unibz.inf.ontop.model.atom.RDFAtomPredicate;
import it.unibz.inf.ontop.model.atom.RelationPredicate;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.spec.mapping.Mapping;
import it.unibz.inf.ontop.spec.mapping.TMappingExclusionConfig;
import it.unibz.inf.ontop.spec.mapping.transformer.MappingCQCOptimizer;
import it.unibz.inf.ontop.spec.mapping.transformer.impl.TMappingEntry;
import it.unibz.inf.ontop.spec.mapping.transformer.impl.TMappingRule;
import it.unibz.inf.ontop.spec.mapping.utils.MappingTools;
import it.unibz.inf.ontop.spec.ontology.ClassExpression;
import it.unibz.inf.ontop.spec.ontology.ClassifiedTBox;
import it.unibz.inf.ontop.spec.ontology.DataPropertyExpression;
import it.unibz.inf.ontop.spec.ontology.DataSomeValuesFrom;
import it.unibz.inf.ontop.spec.ontology.EquivalencesDAG;
import it.unibz.inf.ontop.spec.ontology.OClass;
import it.unibz.inf.ontop.spec.ontology.ObjectPropertyExpression;
import it.unibz.inf.ontop.spec.ontology.ObjectSomeValuesFrom;
import it.unibz.inf.ontop.substitution.SubstitutionFactory;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import java.util.Collection;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.apache.commons.rdf.api.IRI;

public class TMappingProcessor {
    private final AtomFactory atomFactory;
    private final TermFactory termFactory;
    private final QueryUnionSplitter unionSplitter;
    private final UnionFlattener unionNormalizer;
    private final MappingCQCOptimizer mappingCqcOptimizer;
    private final NoNullValueEnforcer noNullValueEnforcer;
    private final SpecificationFactory specificationFactory;
    private final IntermediateQueryFactory iqFactory;
    private final UnionBasedQueryMerger queryMerger;
    private final SubstitutionFactory substitutionFactory;

    @Inject
    private TMappingProcessor(AtomFactory atomFactory, TermFactory termFactory, QueryUnionSplitter unionSplitter, UnionFlattener unionNormalizer, MappingCQCOptimizer mappingCqcOptimizer, NoNullValueEnforcer noNullValueEnforcer, SpecificationFactory specificationFactory, IntermediateQueryFactory iqFactory, UnionBasedQueryMerger queryMerger, SubstitutionFactory substitutionFactory) {
        this.atomFactory = atomFactory;
        this.termFactory = termFactory;
        this.unionSplitter = unionSplitter;
        this.unionNormalizer = unionNormalizer;
        this.mappingCqcOptimizer = mappingCqcOptimizer;
        this.noNullValueEnforcer = noNullValueEnforcer;
        this.specificationFactory = specificationFactory;
        this.iqFactory = iqFactory;
        this.queryMerger = queryMerger;
        this.substitutionFactory = substitutionFactory;
    }

    public Mapping getTMappings(Mapping mapping, ClassifiedTBox reasoner, TMappingExclusionConfig excludeFromTMappings, ImmutableCQContainmentCheckUnderLIDs<RelationPredicate> cqContainmentCheck) {
        ImmutableMultimap source = (ImmutableMultimap)mapping.getRDFAtomPredicates().stream().flatMap(p -> mapping.getQueries(p).stream()).flatMap(q -> this.unionSplitter.splitUnion(this.unionNormalizer.optimize(q))).map(q -> this.mappingCqcOptimizer.optimize((ImmutableCQContainmentCheck<RelationPredicate>)cqContainmentCheck, (IQ)q)).map(q -> new TMappingRule((IQ)q, this.termFactory, this.atomFactory)).collect(ImmutableCollectors.toMultimap(q -> q.getPredicateInfo(), q -> q));
        ImmutableMap saturated = (ImmutableMap)Stream.concat(Stream.concat(this.saturate(reasoner.objectPropertiesDAG(), p -> !p.isInverse() && !excludeFromTMappings.contains((ObjectPropertyExpression)p), (ImmutableMultimap<MappingTools.RDFPredicateInfo, TMappingRule>)source, this::indexOf, p -> this.getNewHeadP(p.isInverse()), cqContainmentCheck, (r, p) -> !p.isInverse() || p.getInverse() != r), this.saturate(reasoner.dataPropertiesDAG(), p -> !excludeFromTMappings.contains((DataPropertyExpression)p), (ImmutableMultimap<MappingTools.RDFPredicateInfo, TMappingRule>)source, this::indexOf, p -> this.getNewHeadP(false), cqContainmentCheck, (r, p) -> true)), this.saturate(reasoner.classesDAG(), s -> s instanceof OClass && !excludeFromTMappings.contains((OClass)s), (ImmutableMultimap<MappingTools.RDFPredicateInfo, TMappingRule>)source, this::indexOf, this::getNewHeadC, cqContainmentCheck, (r, c) -> c instanceof OClass)).collect(ImmutableCollectors.toMap());
        ImmutableList entries = (ImmutableList)Stream.concat(saturated.values().stream(), source.asMap().entrySet().stream().filter(e -> !saturated.containsKey(e.getKey())).map(e -> ((Collection)e.getValue()).stream().collect(TMappingEntry.toTMappingEntry(cqContainmentCheck, this.termFactory)))).collect(ImmutableCollectors.toList());
        return this.specificationFactory.createMapping(mapping.getMetadata(), (ImmutableTable)entries.stream().filter(e -> !e.getPredicateInfo().isClass()).map(this::toCell).collect(ImmutableCollectors.toTable()), (ImmutableTable)entries.stream().filter(e -> e.getPredicateInfo().isClass()).map(this::toCell).collect(ImmutableCollectors.toTable()));
    }

    private Table.Cell<RDFAtomPredicate, IRI, IQ> toCell(TMappingEntry e) {
        return Tables.immutableCell((Object)e.getRDFAtomPredicate(), (Object)e.getPredicateInfo().getIri(), (Object)this.noNullValueEnforcer.transform(e.asIQ(this.iqFactory, this.queryMerger)).normalizeForOptimization());
    }

    private <T> Stream<Map.Entry<MappingTools.RDFPredicateInfo, TMappingEntry>> saturate(EquivalencesDAG<T> dag, Predicate<T> representativeFilter, ImmutableMultimap<MappingTools.RDFPredicateInfo, TMappingRule> originalMappingIndex, Function<T, MappingTools.RDFPredicateInfo> indexOf, Function<T, Function<ImmutableList<ImmutableTerm>, ImmutableList<ImmutableTerm>>> getNewHeadGen, ImmutableCQContainmentCheckUnderLIDs<RelationPredicate> cqc, BiPredicate<T, T> populationFilter) {
        BiFunction<Object, Object, Function> headReplacer = (s, d) -> m -> new TMappingRule((ImmutableList<ImmutableTerm>)((ImmutableList)((Function)getNewHeadGen.apply(s)).apply(m.getHeadTerms())), (MappingTools.RDFPredicateInfo)indexOf.apply(d), (TMappingRule)m, this.substitutionFactory);
        ImmutableMap representatives = (ImmutableMap)dag.stream().filter(s -> representativeFilter.test(s.getRepresentative())).collect(ImmutableCollectors.toMap(s -> (MappingTools.RDFPredicateInfo)indexOf.apply(s.getRepresentative()), s -> dag.getSub(s).stream().flatMap(ss -> ss.getMembers().stream()).flatMap(d -> originalMappingIndex.get(indexOf.apply(d)).stream().map((Function)headReplacer.apply(d, s.getRepresentative()))).collect(TMappingEntry.toTMappingEntry(cqc, this.termFactory))));
        BiFunction<Object, Object, Function> headReplacer2 = (s, d) -> m -> new TMappingRule((ImmutableList<ImmutableTerm>)((ImmutableList)((Function)getNewHeadGen.apply(d)).apply(m.getHeadTerms())), (MappingTools.RDFPredicateInfo)indexOf.apply(d), (TMappingRule)m, this.substitutionFactory);
        return dag.stream().filter(s -> representativeFilter.test(s.getRepresentative())).flatMap(s -> ((ImmutableMap)s.getMembers().stream().filter(d -> populationFilter.test(s.getRepresentative(), d)).collect(ImmutableCollectors.toMap(d -> (MappingTools.RDFPredicateInfo)indexOf.apply(d), d -> ((TMappingEntry)representatives.get(indexOf.apply(s.getRepresentative()))).createCopy((Function)headReplacer2.apply(s.getRepresentative(), d))))).entrySet().stream()).filter(e -> !((TMappingEntry)e.getValue()).isEmpty());
    }

    private MappingTools.RDFPredicateInfo indexOf(ClassExpression child) {
        if (child instanceof OClass) {
            return new MappingTools.RDFPredicateInfo(true, ((OClass)child).getIRI());
        }
        if (child instanceof ObjectSomeValuesFrom) {
            return this.indexOf(((ObjectSomeValuesFrom)child).getProperty());
        }
        return this.indexOf(((DataSomeValuesFrom)child).getProperty());
    }

    private MappingTools.RDFPredicateInfo indexOf(ObjectPropertyExpression child) {
        return new MappingTools.RDFPredicateInfo(false, child.getIRI());
    }

    private MappingTools.RDFPredicateInfo indexOf(DataPropertyExpression child) {
        return new MappingTools.RDFPredicateInfo(false, child.getIRI());
    }

    private Function<ImmutableList<ImmutableTerm>, ImmutableList<ImmutableTerm>> getNewHeadC(ClassExpression child) {
        if (child instanceof OClass) {
            return Function.identity();
        }
        if (child instanceof ObjectSomeValuesFrom) {
            ObjectPropertyExpression some = ((ObjectSomeValuesFrom)child).getProperty();
            return some.isInverse() ? head -> ImmutableList.of((Object)head.get(1)) : head -> ImmutableList.of((Object)head.get(0));
        }
        DataPropertyExpression some = ((DataSomeValuesFrom)child).getProperty();
        return head -> ImmutableList.of((Object)head.get(0));
    }

    private Function<ImmutableList<ImmutableTerm>, ImmutableList<ImmutableTerm>> getNewHeadP(boolean isInverse) {
        return isInverse ? head -> ImmutableList.of((Object)head.get(1), (Object)head.get(0)) : Function.identity();
    }
}

